/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContentEntries {
    private ContentEntries() {
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path2, @NotNull Stream<ContentEntry> contentEntries) {
        Optional<ContentEntry> optional2 = contentEntries.filter(contentEntry -> ContentEntries.isPathInContentEntry(path2, contentEntry)).findFirst();
        return optional2.isPresent() ? optional2.get() : null;
    }

    @NotNull
    public static Collection<ContentEntry> findChildContentEntries(@NotNull File path2, @NotNull Stream<ContentEntry> contentEntries) {
        return contentEntries.filter(contentEntry -> ContentEntries.isContentEntryUnderPath(path2, contentEntry)).collect(Collectors.toList());
    }

    public static boolean isPathInContentEntry(@NotNull File path2, @NotNull ContentEntry contentEntry) {
        return FileUtil.isAncestor((File)ContentEntries.findContentEntryPath(contentEntry), (File)path2, (boolean)false);
    }

    private static boolean isContentEntryUnderPath(@NotNull File path2, @NotNull ContentEntry contentEntry) {
        return FileUtil.isAncestor((File)path2, (File)ContentEntries.findContentEntryPath(contentEntry), (boolean)false);
    }

    @NotNull
    private static File findContentEntryPath(@NotNull ContentEntry contentEntry) {
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            return new File(s);
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
    }
}

