/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsCheckBoxList<T>
extends CheckBoxList<T> {
    @NotNull
    private final List<CheckBoxListListener> myListeners = Lists.newCopyOnWriteArrayList();
    @Nullable
    private SelectionChangeListener<ImmutableList<T>> mySelectionChangeListener;

    public PsCheckBoxList(@NotNull List<T> items2) {
        this.setItems(items2, null);
        super.setCheckBoxListListener((index2, value2) -> {
            for (CheckBoxListListener listener2 : this.myListeners) {
                listener2.checkBoxSelectionChanged(index2, value2);
            }
        });
        this.addCheckBoxListListener((index2, value2) -> this.fireSelectionChangedEvent());
    }

    @Deprecated
    public void setCheckBoxListListener(CheckBoxListListener checkBoxListListener) {
        throw new UnsupportedOperationException("Invoke 'setSelectionChangeListener' instead");
    }

    public void addCheckBoxListListener(@NotNull CheckBoxListListener checkBoxListListener) {
        this.myListeners.add(checkBoxListListener);
    }

    @NotNull
    public AnAction createSelectAllAction() {
        return new AnAction("Select All", "", AllIcons.Actions.Selectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PsCheckBoxList.this.setItemsSelected(true);
            }
        };
    }

    @NotNull
    public AnAction createUnselectAllAction() {
        return new AnAction("Unselect All", "", AllIcons.Actions.Unselectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PsCheckBoxList.this.setItemsSelected(false);
            }
        };
    }

    public void setItemsSelected(boolean selected) {
        int itemsCount = this.getItemsCount();
        for (int i2 = 0; i2 < itemsCount; ++i2) {
            Object item = this.getItemAt(i2);
            this.setItemSelected(item, selected);
        }
        this.repaint();
        this.fireSelectionChangedEvent();
    }

    private void fireSelectionChangedEvent() {
        if (this.mySelectionChangeListener != null) {
            this.mySelectionChangeListener.selectionChanged(this.getSelectedItems());
        }
    }

    @NotNull
    public ImmutableList<T> getSelectedItems() {
        int count = this.getItemsCount();
        if (count == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i2 = 0; i2 < count; ++i2) {
            Object item = this.getItemAt(i2);
            if (item == null || !this.isItemSelected(item)) continue;
            listBuilder.add(item);
        }
        return listBuilder.build();
    }

    public void setSelectionChangeListener(@Nullable SelectionChangeListener<ImmutableList<T>> listener2) {
        this.mySelectionChangeListener = listener2;
    }
}

