/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.IdeaProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectSettingsServiceImpl
extends ProjectSettingsService
implements AndroidProjectSettingsService,
ArtifactAwareProjectSettingsService {
    private final Project myProject;
    private final IdeaProjectSettingsService myDelegate;

    public AndroidProjectSettingsServiceImpl(Project project) {
        this.myProject = project;
        this.myDelegate = new IdeaProjectSettingsService(project);
    }

    public void openProjectSettings() {
        this.myDelegate.openProjectSettings();
    }

    public void openGlobalLibraries() {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openGlobalLibraries();
        }
    }

    public void openLibrary(@NotNull Library library) {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibrary(library);
        }
    }

    public boolean canOpenModuleSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return true;
        }
        return this.myDelegate.canOpenModuleSettings();
    }

    public void openModuleLibrarySettings(Module module2) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module2);
        } else {
            this.myDelegate.openModuleLibrarySettings(module2);
        }
    }

    private void showNewPsd(@NotNull Place place) {
        ProjectStructureConfigurable.getInstance(this.myProject).showPlace(place);
    }

    public void openModuleSettings(Module module2) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)));
        } else {
            this.myDelegate.openModuleSettings(module2);
        }
    }

    @Override
    public void openSigningConfiguration(@NotNull Module module2) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)).putPath("android.psd.module", (Object)"Signing Configs"));
    }

    @Override
    public void openSdkSettings() {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"SDK Location"));
    }

    @Override
    public void chooseJdkLocation() {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"SDK Location"));
    }

    @Override
    public void openAndSelectDependency(@NotNull Module module2, @NotNull GradleCoordinate dependency) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Dependencies").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)).putPath(String.format("dependencies.%s.place", GradleProjects.getGradleModulePath(module2)), (Object)dependency.toString()));
    }

    public void openAndSelectBuildTypesEditor(@NotNull Module module2) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Build Variants").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)).putPath("android.psd.build_variants", (Object)"Build Types"));
    }

    public void openAndSelectFlavorsEditor(@NotNull Module module2) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Build Variants").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)).putPath("android.psd.build_variants", (Object)"Flavors"));
    }

    @Override
    public void openAndSelectDependenciesEditor(@NotNull Module module2) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Dependencies").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)));
    }

    public boolean canOpenModuleLibrarySettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleLibrarySettings();
    }

    public boolean canOpenContentEntriesSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenContentEntriesSettings();
    }

    public void openContentEntriesSettings(Module module2) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module2);
        } else {
            this.myDelegate.openContentEntriesSettings(module2);
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleDependenciesSettings();
    }

    public void openModuleDependenciesSettings(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module2);
        } else {
            this.myDelegate.openModuleDependenciesSettings(module2, orderEntry);
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenLibraryOrSdkSettings(orderEntry);
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibraryOrSdkSettings(orderEntry);
        }
    }

    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.processModulesMoved(modules, targetGroup);
    }

    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        if (this.isGradleProjectInAndroidStudio()) {
            Module module2 = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleToSelect);
            assert (module2 != null);
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("base_perspective.module", (Object)GradleProjects.getGradleModulePath(module2)));
        } else {
            this.myDelegate.showModuleConfigurationDialog(moduleToSelect, editorNameToSelect);
        }
    }

    public Sdk chooseAndSetSdk() {
        return this.myDelegate.chooseAndSetSdk();
    }

    public void openArtifactSettings(@Nullable Artifact artifact) {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openArtifactSettings(artifact);
        }
    }

    private boolean isGradleProjectInAndroidStudio() {
        return IdeInfo.getInstance().isAndroidStudio() && AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel();
    }
}

