/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.run.AndroidDeviceSpecUtil;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.OutputBuildActionUtil;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleBuilds;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceSpec;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleTaskRunnerFactory myTaskRunnerFactory;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        this.myProject = project;
        this.myAndroidProjectInfo = AndroidProjectInfo.getInstance(project);
        this.myGradleProjectInfo = GradleProjectInfo.getInstance(project);
        this.myTaskRunnerFactory = new GradleTaskRunnerFactory(this.myProject);
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task2) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task2) {
        String goal = task2.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (this.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task2 = new MakeBeforeRunTask();
            if (this.configurationTypeIsEnabledByDefault(runConfiguration)) {
                task2.setEnabled(true);
            }
            return task2;
        }
        return null;
    }

    public boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (!(ProjectSystemUtil.getProjectSystem(runConfiguration.getProject()) instanceof GradleProjectSystem)) {
            return false;
        }
        return runConfiguration instanceof PreferGradleMake || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    public boolean configurationTypeIsEnabledByDefault(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof PreferGradleMake;
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MakeBeforeRunTask task2) {
        GradleEditTaskDialog dialog2 = new GradleEditTaskDialog(this.myProject);
        dialog2.setGoal(task2.getGoal());
        dialog2.setAvailableGoals(this.createAvailableTasks());
        if (!dialog2.showAndGet()) {
            task2.setInvalid();
            return false;
        }
        task2.setGoal(dialog2.getGoal());
        return true;
    }

    @NotNull
    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<String> gradleTasks = new ArrayList<String>();
        for (Module module2 : moduleManager.getModules()) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet2 = GradleFacet.getInstance(module2);
            if (facet2 == null || (gradleModuleModel = facet2.getGradleModuleModel()) == null) continue;
            gradleTasks.addAll(gradleModuleModel.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MakeBeforeRunTask task2) {
        return task2.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MakeBeforeRunTask task2) {
        if (Boolean.FALSE.equals(env.getUserData(GradleBuilds.BUILD_SHOULD_EXECUTE))) {
            return true;
        }
        RunStats stats = RunStats.from(env);
        try {
            stats.beginBeforeRunTasks();
            boolean bl = this.doExecuteTask(context, configuration, env, task2);
            return bl;
        }
        finally {
            stats.endBeforeRunTasks();
        }
    }

    @VisibleForTesting
    @NotNull
    SyncNeeded isSyncNeeded(@NotNull DataContext context, @NotNull RunConfiguration configuration, Collection<String> abis) {
        if (GradleSyncState.getInstance(this.myProject).isSyncNeeded() != ThreeState.NO && !this.isPostBuildModelsSupported(context, configuration)) {
            return SyncNeeded.SINGLE_VARIANT_SYNC_NEEDED;
        }
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModel = NdkModuleModel.get(module2);
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (ndkModel == null || androidModel == null) continue;
            String selectedVariantName = androidModel.getSelectedVariant().getName();
            Set availableAbis = ndkModel.getSyncedVariantAbis().stream().filter(it -> it.getVariant().equals(selectedVariantName)).map(it -> it.getAbi()).collect(Collectors.toSet());
            if (availableAbis.containsAll(abis)) continue;
            return SyncNeeded.NATIVE_VARIANTS_SYNC_NEEDED;
        }
        return SyncNeeded.NOT_NEEDED;
    }

    @Nullable
    private String runSync(@NotNull SyncNeeded syncNeeded, @NotNull @NotNull Set<@NotNull String> requestedAbis) {
        if (syncNeeded == SyncNeeded.NATIVE_VARIANTS_SYNC_NEEDED) {
            GradleSyncInvoker.getInstance().fetchAndMergeNativeVariants(this.myProject, requestedAbis);
            return null;
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_RUN_SYNC_NEEDED_BEFORE_RUNNING);
        request.runInBackground = false;
        request.forceFullVariantsSync = syncNeeded.isFullSync;
        final AtomicReference errorMsgRef = new AtomicReference();
        GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener(){

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                errorMsgRef.set(errorMessage);
            }
        });
        String result2 = (String)errorMsgRef.get();
        return result2;
    }

    private boolean isPostBuildModelsSupported(@NotNull DataContext context, @NotNull RunConfiguration configuration) {
        Module[] modules;
        for (Module module2 : modules = this.getModules(context, configuration)) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module2);
            if (androidModuleModel == null || androidModuleModel.getFeatures().isPostBuildSyncSupported() || androidModuleModel.getFeatures().isBuildOutputFileSupported()) continue;
            return false;
        }
        return true;
    }

    private boolean doExecuteTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task2) {
        List<String> cmdLineArgs;
        AndroidRunConfigurationBase androidRunConfiguration;
        AndroidRunConfigurationBase androidRunConfigurationBase = androidRunConfiguration = configuration instanceof AndroidRunConfigurationBase ? (AndroidRunConfigurationBase)configuration : null;
        if (!this.myAndroidProjectInfo.requiresAndroidModel()) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
        List<Object> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        @Nullable AndroidDeviceSpec targetDeviceSpec = AndroidDeviceSpecUtil.createSpec(targetDevices);
        if (configuration instanceof RunProfileWithCompileBeforeLaunchOption && ((RunProfileWithCompileBeforeLaunchOption)configuration).isExcludeCompileBeforeLaunchOption()) {
            return true;
        }
        Module[] modules = this.getModules(context, configuration);
        try {
            cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(modules, androidRunConfiguration, targetDeviceSpec);
        }
        catch (Exception e) {
            MakeBeforeRunTaskProvider.getLog().warn("Error generating command line arguments for Gradle task", (Throwable)e);
            return false;
        }
        AndroidVersion targetDeviceVersion = targetDeviceSpec != null ? targetDeviceSpec.getCommonVersion() : null;
        BeforeRunBuilder builder2 = MakeBeforeRunTaskProvider.createBuilder(modules, configuration, targetDeviceVersion, task2.getGoal());
        GradleTaskRunner.DefaultGradleTaskRunner runner = this.myTaskRunnerFactory.createTaskRunner(configuration);
        BuildSettings.getInstance(this.myProject).setRunConfigurationTypeId(configuration.getType().getId());
        try {
            String errorMsg;
            boolean success2 = builder2.build(runner, cmdLineArgs);
            if (androidRunConfiguration != null) {
                Object model2 = runner.getModel();
                if (model2 instanceof OutputBuildAction.PostBuildProjectModels) {
                    androidRunConfiguration.putUserData(GradleApkProvider.POST_BUILD_MODEL, new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model2));
                } else {
                    MakeBeforeRunTaskProvider.getLog().info("Couldn't get post build models.");
                }
            }
            MakeBeforeRunTaskProvider.getLog().info("Gradle invocation complete, success = " + success2);
            HashSet<String> targetAbis = new HashSet<String>(targetDeviceSpec != null ? targetDeviceSpec.getAbis() : Collections.emptyList());
            SyncNeeded syncNeeded = this.isSyncNeeded(context, configuration, targetAbis);
            if (syncNeeded != SyncNeeded.NOT_NEEDED && (errorMsg = this.runSync(syncNeeded, targetAbis)) != null) {
                MakeBeforeRunTaskProvider.getLog().info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
                return false;
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            return success2;
        }
        catch (InvocationTargetException e) {
            MakeBeforeRunTaskProvider.getLog().info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            MakeBeforeRunTaskProvider.getLog().info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(MakeBeforeRunTask.class);
    }

    @VisibleForTesting
    @NotNull
    static List<String> getCommonArguments(@NotNull Module[] modules, @Nullable AndroidRunConfigurationBase configuration, @Nullable AndroidDeviceSpec targetDeviceSpec) throws IOException {
        ArrayList<String> cmdLineArgs = new ArrayList<String>();
        cmdLineArgs.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.enableStableIds", (boolean)true));
        if (configuration != null) {
            cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(modules, configuration, targetDeviceSpec));
            cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration, targetDeviceSpec));
        }
        return cmdLineArgs;
    }

    @VisibleForTesting
    @NotNull
    static List<String> getDeviceSpecificArguments(@NotNull Module[] modules, @NotNull AndroidRunConfigurationBase configuration, @Nullable AndroidDeviceSpec deviceSpec) {
        if (deviceSpec == null) {
            return Collections.emptyList();
        }
        ArrayList<String> properties2 = new ArrayList<String>(3);
        if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, deviceSpec.getMinVersion())) {
            boolean collectListOfLanguages = MakeBeforeRunTaskProvider.shouldCollectListOfLanguages(modules, configuration, deviceSpec.getMinVersion());
            File deviceSpecFile = AndroidDeviceSpecUtil.writeToJsonTempFile(deviceSpec, collectListOfLanguages);
            properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.apkselect.config", (String)deviceSpecFile.getAbsolutePath()));
            if (configuration instanceof AndroidRunConfiguration) {
                String featureList;
                AndroidRunConfiguration androidRunConfiguration = (AndroidRunConfiguration)configuration;
                if (androidRunConfiguration.DEPLOY_AS_INSTANT) {
                    properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.bundle.extractinstant", (boolean)true));
                }
                if (androidRunConfiguration.DEPLOY_APK_FROM_BUNDLE && !(featureList = MakeBeforeRunTaskProvider.getEnabledDynamicFeatureList(modules, androidRunConfiguration)).isEmpty()) {
                    properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.modules.install.list", (String)featureList));
                }
            }
        } else {
            AndroidVersion version2 = deviceSpec.getCommonVersion();
            if (version2 != null) {
                properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(version2.getApiLevel())));
                if (version2.getCodename() != null) {
                    properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.codename", (String)version2.getCodename()));
                }
            }
            if (deviceSpec.getDensity() != null) {
                properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)deviceSpec.getDensity().getResourceValue()));
            }
            if (!deviceSpec.getAbis().isEmpty()) {
                properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join((Iterable)deviceSpec.getAbis())));
            }
            if (configuration instanceof AndroidRunConfiguration && ((AndroidRunConfiguration)configuration).DEPLOY_AS_INSTANT) {
                properties2.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.deploy.instant-app", (boolean)true));
            }
        }
        return properties2;
    }

    @NotNull
    private static String getEnabledDynamicFeatureList(@NotNull Module[] modules, @NotNull AndroidRunConfiguration configuration) {
        HashSet<String> disabledFeatures = new HashSet<String>(configuration.getDisabledDynamicFeatures());
        return Arrays.stream(modules).flatMap(module2 -> DynamicAppUtils.getDependentFeatureModulesForBase(module2).stream()).map(Module::getName).filter(name -> !disabledFeatures.contains(name)).map(moduleName2 -> {
            int index2 = moduleName2.lastIndexOf(46);
            return index2 < 0 ? moduleName2 : moduleName2.substring(index2 + 1);
        }).collect(Collectors.joining(","));
    }

    @NotNull
    private static List<String> getProfilingOptions(@NotNull AndroidRunConfigurationBase configuration, @Nullable AndroidDeviceSpec targetDeviceSpec) throws IOException {
        if (targetDeviceSpec == null) {
            return Collections.emptyList();
        }
        int minFeatureLevel = targetDeviceSpec.getMinVersion().getFeatureLevel();
        LinkedList<String> arguments = new LinkedList<String>();
        ProfilerState state = configuration.getProfilerState();
        if (state.ADVANCED_PROFILING_ENABLED && minFeatureLevel >= 21 && minFeatureLevel < 26) {
            File file2 = EmbeddedDistributionPaths.getInstance().findEmbeddedProfilerTransform();
            arguments.add(AndroidGradleSettings.createProjectProperty((String)"android.advanced.profiling.transforms", (String)file2.getAbsolutePath()));
            Properties profilerProperties = state.toProperties();
            File propertiesFile = FileUtil.createTempFile((String)"profiler", (String)".properties");
            propertiesFile.deleteOnExit();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charsets.UTF_8);
            profilerProperties.store(writer, "Android Studio Profiler Gradle Plugin Properties");
            ((Writer)writer).close();
            arguments.add(AndroidGradleSettings.createJvmArg((String)"android.profiler.properties", (String)propertiesFile.getAbsolutePath()));
        }
        return arguments;
    }

    @NotNull
    private static BeforeRunBuilder createBuilder(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @Nullable AndroidVersion targetDeviceVersion, @Nullable String userGoal) {
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            ArrayListMultimap tasks = ArrayListMultimap.create();
            ((StreamEx)StreamEx.of((Object[])modules).map(module2 -> ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2)).nonNull().distinct()).map(path2 -> Paths.get(path2, new String[0])).forEach(arg_0 -> MakeBeforeRunTaskProvider.lambda$createBuilder$7((ListMultimap)tasks, userGoal, arg_0));
            return new DefaultGradleBuilder((ListMultimap<Path, String>)tasks, null);
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        TestCompileType testCompileType = TestCompileType.get(configuration.getType().getId());
        if (testCompileType == TestCompileType.UNIT_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
        }
        if (configuration instanceof AndroidRunConfigurationBase && MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, (AndroidRunConfigurationBase)configuration, targetDeviceVersion)) {
            return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.APK_FROM_BUNDLE, testCompileType), BuildMode.APK_FROM_BUNDLE);
        }
        return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
    }

    private static boolean useSelectApksFromBundleBuilder(@NotNull Module[] modules, @NotNull AndroidRunConfigurationBase configuration, @Nullable AndroidVersion minTargetDeviceVersion) {
        return Arrays.stream(modules).anyMatch(module2 -> DynamicAppUtils.useSelectApksFromBundleBuilder(module2, configuration, minTargetDeviceVersion));
    }

    private static boolean shouldCollectListOfLanguages(@NotNull Module[] modules, @NotNull AndroidRunConfigurationBase configuration, @Nullable AndroidVersion targetDeviceVersion) {
        return Arrays.stream(modules).allMatch(module2 -> DynamicAppUtils.shouldCollectListOfLanguages(module2, configuration, targetDeviceVersion));
    }

    @NotNull
    private Module[] getModules(@Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (configuration instanceof ModuleRunProfile) {
            if (configuration instanceof AndroidJUnitConfiguration) {
                return ((AndroidJUnitConfiguration)configuration).getModulesToCompile();
            }
            return ((ModuleRunProfile)configuration).getModules();
        }
        return this.myGradleProjectInfo.getModulesToBuildFromSelection(context);
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$createBuilder$7(ListMultimap tasks, String userGoal, Path path2) {
        tasks.put((Object)path2, (Object)userGoal);
    }

    @VisibleForTesting
    static class GradleTaskRunnerFactory {
        @NotNull
        private final Project myProject;

        GradleTaskRunnerFactory(@NotNull Project project) {
            this.myProject = project;
        }

        @NotNull
        GradleTaskRunner.DefaultGradleTaskRunner createTaskRunner(@NotNull RunConfiguration configuration) {
            if (configuration instanceof AndroidRunConfigurationBase) {
                ArrayList<Module> modules = new ArrayList<Module>();
                Module selectedModule = ((JavaRunConfigurationModule)((AndroidRunConfigurationBase)configuration).getConfigurationModule()).getModule();
                if (selectedModule != null) {
                    Module baseModule;
                    modules.add(selectedModule);
                    if (configuration instanceof AndroidTestRunConfiguration && (baseModule = DynamicAppUtils.getBaseFeature(selectedModule)) != null) {
                        modules.add(baseModule);
                    }
                }
                return GradleTaskRunner.newRunner(this.myProject, OutputBuildActionUtil.create(modules));
            }
            return GradleTaskRunner.newRunner(this.myProject, null);
        }
    }

    @VisibleForTesting
    static enum SyncNeeded {
        NOT_NEEDED(false),
        SINGLE_VARIANT_SYNC_NEEDED(false),
        FULL_SYNC_NEEDED(true),
        NATIVE_VARIANTS_SYNC_NEEDED(false);

        public final boolean isFullSync;

        private SyncNeeded(boolean isFullSync) {
            this.isFullSync = isFullSync;
        }
    }
}

