/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.projectView;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ColoredTreeCellRenderer;
import icons.StudioIcons;
import org.jetbrains.android.facet.AndroidFacet;

public class ModuleNodeIconDecorator
implements ProjectViewNodeDecorator {
    public void decorate(ProjectViewNode node2, PresentationData data) {
        if (!(node2 instanceof PsiDirectoryNode)) {
            return;
        }
        PsiDirectoryNode psiDirectoryNode = (PsiDirectoryNode)node2;
        PsiDirectory psiDirectory = (PsiDirectory)psiDirectoryNode.getValue();
        if (psiDirectory == null) {
            return;
        }
        Project project = psiDirectory.getProject();
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return;
        }
        VirtualFile folder = psiDirectory.getVirtualFile();
        Module module2 = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(folder);
        if (module2 != null && !module2.isDisposed()) {
            TestArtifactSearchScopes testScopes;
            if (ModuleUtilCore.isModuleDir((Module)module2, (VirtualFile)folder)) {
                data.setIcon(GradleUtil.getModuleIcon(module2));
            } else if (ProjectRootsUtil.isSourceRoot((VirtualFile)folder, (Project)project) && (testScopes = TestArtifactSearchScopes.getInstance(module2)) != null && testScopes.isAndroidTestSource(folder)) {
                data.setIcon(StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT);
            }
        }
    }

    public void decorate(PackageDependenciesNode node2, ColoredTreeCellRenderer cellRenderer2) {
    }
}

