/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.projectView;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class AndroidTreeStructureProvider
implements TreeStructureProvider {
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        Project project = parent.getProject();
        if (project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            if (parent instanceof NamedLibraryElementNode) {
                Sdk sdk;
                NamedLibraryElement value2 = (NamedLibraryElement)((NamedLibraryElementNode)parent).getValue();
                LibraryOrSdkOrderEntry orderEntry = value2.getOrderEntry();
                if (orderEntry instanceof JdkOrderEntry && (sdk = ((JdkOrderEntry)orderEntry).getJdk()) != null && sdk.getSdkType() instanceof JavaSdk) {
                    ArrayList newChildren = Lists.newArrayList();
                    for (AbstractTreeNode<?> child : children) {
                        if (!AndroidTreeStructureProvider.isRtJar(child)) continue;
                        newChildren.add(child);
                    }
                    if (!newChildren.isEmpty()) {
                        ((ChangeListener)this.myEventDispatcher.getMulticaster()).nodeChanged(parent, newChildren);
                        return newChildren;
                    }
                }
            } else if (AndroidTreeStructureProvider.isRtJar(parent)) {
                ArrayList newChildren = Lists.newArrayList();
                for (AbstractTreeNode<?> child : children) {
                    VirtualFile file2;
                    if (!(child instanceof PsiDirectoryNode) || (file2 = ((PsiDirectoryNode)child).getVirtualFile()) == null || !"java".equals(file2.getName()) && !"javax".equals(file2.getName())) continue;
                    newChildren.add(child);
                }
                if (!newChildren.isEmpty()) {
                    ((ChangeListener)this.myEventDispatcher.getMulticaster()).nodeChanged(parent, newChildren);
                    return newChildren;
                }
            }
        }
        return children;
    }

    private static boolean isRtJar(@NotNull AbstractTreeNode node2) {
        if (node2 instanceof PsiDirectoryNode) {
            VirtualFile file2 = ((PsiDirectoryNode)node2).getVirtualFile();
            return file2 != null && "rt.jar".equals(file2.getName());
        }
        return false;
    }

    @VisibleForTesting
    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode()) {
            this.myEventDispatcher.addListener((EventListener)changeListener);
            return;
        }
        throw new UnsupportedOperationException("'addChangeListener' should only be used in tests");
    }

    @VisibleForTesting
    public static interface ChangeListener
    extends EventListener {
        public void nodeChanged(@NotNull AbstractTreeNode var1, @NotNull Collection<AbstractTreeNode<?>> var2);
    }
}

