/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.utils.BuildScriptUtil;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IgnoredBuildScriptSetupStep
extends ProjectSetupStep {
    @Override
    public void setUpProject(@NotNull Project project) {
        File projectPath = Projects.getBaseDirPath((Project)project);
        File projectBuildPath = BuildScriptUtil.findGradleBuildFile((File)projectPath);
        if (projectBuildPath.exists()) {
            IgnoredBuildScriptSetupStep.checkIsNotIgnored("Build script for project " + project.getName(), projectBuildPath, project);
        }
        File dotGradleFolder = new File(projectPath, ".gradle");
        IgnoredBuildScriptSetupStep.checkIsNotIgnored("Project " + project.getName() + " " + ".gradle" + " folder", dotGradleFolder, project);
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            File buildPath;
            GradleModuleModel gradleModel;
            GradleFacet gradleFacet = GradleFacet.getInstance(module2);
            if (gradleFacet == null || (gradleModel = gradleFacet.getGradleModuleModel()) == null || (buildPath = gradleModel.getBuildFilePath()) == null || !buildPath.exists() || FileUtils.isSameFile((File)buildPath, (File)projectBuildPath)) continue;
            IgnoredBuildScriptSetupStep.checkIsNotIgnored("Build script for module " + module2.getName(), buildPath, project);
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return false;
    }

    public static String getIgnoredFileTypesPathInSettings() {
        return String.format("%s \u2192 Editor \u2192 File Types", ShowSettingsUtil.getSettingsMenuName());
    }

    public static void checkIsNotIgnored(@NotNull String prefix, @NotNull File path2, @NotNull Project project) {
        IgnoredBuildScriptSetupStep.checkIsNotIgnored(prefix, path2, FileTypeManager.getInstance(), GradleSyncMessages.getInstance(project));
    }

    @VisibleForTesting
    static void checkIsNotIgnored(@NotNull String prefix, @NotNull File path2, @NotNull FileTypeManager fileTypeManager, @NotNull GradleSyncMessages messages) {
        if (fileTypeManager.isFileIgnored(path2.getPath())) {
            String[] text2 = new String[]{prefix + " is being ignored. This can cause issues on the IDE.", "You can change ignored files and folders from " + IgnoredBuildScriptSetupStep.getIgnoredFileTypesPathInSettings()};
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.WARNING, text2);
            message2.add(new NotificationHyperlink("open.settings.filetypes", "Open in Settings"){

                @Override
                protected void execute(@NotNull Project project) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, "preferences.fileTypes");
                }
            });
            message2.add(new OpenFileHyperlink(path2.getPath(), "Open ignored " + (path2.isDirectory() ? "folder location" : "file"), -1, -1));
            messages.report(message2);
        }
    }
}

