/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleAndroidModule;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.GradleLibrary;
import com.google.wireless.android.sdk.stats.GradleModule;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectStructureUsageTracker {
    private static final Logger LOG = Logger.getInstance(ProjectStructureUsageTracker.class);
    @NotNull
    private final Project myProject;

    public ProjectStructureUsageTracker(@NotNull Project project) {
        this.myProject = project;
    }

    public void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            try {
                this.trackProjectStructure(moduleManager.getModules());
            }
            catch (Throwable e) {
                LOG.warn("Failed to track project structure", e);
            }
        });
    }

    @VisibleForTesting
    void trackProjectStructure(@NotNull Module[] modules) {
        AndroidModuleModel model2;
        AndroidModuleModel appModel = null;
        AndroidModuleModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        ArrayList<GradleLibrary> gradleLibraries = new ArrayList<GradleLibrary>();
        for (Module module2 : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel == null) continue;
            if (androidModel.getAndroidProject().getProjectType() == 1) {
                libModel = androidModel;
                ++libCount;
                continue;
            }
            appModel = androidModel;
            ++appCount;
            GradleLibrary gradleLibrary = ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidModel);
            gradleLibraries.add(gradleLibrary);
        }
        AndroidModuleModel androidModuleModel = model2 = appModel != null ? appModel : libModel;
        if (model2 != null) {
            ArrayList<GradleAndroidModule> gradleAndroidModules = new ArrayList<GradleAndroidModule>();
            ArrayList<GradleNativeAndroidModule> gradleNativeAndroidModules = new ArrayList<GradleNativeAndroidModule>();
            String appId = AnonymizerUtil.anonymizeUtf8((String)model2.getApplicationId());
            IdeAndroidProject androidProject = model2.getAndroidProject();
            GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(this.myProject);
            if (gradleVersion2 == null) {
                gradleVersion2 = new GradleVersion(0, 0, 0);
            }
            GradleModule gradleModule = GradleModule.newBuilder().setTotalModuleCount((long)modules.length).setAppModuleCount((long)appCount).setLibModuleCount((long)libCount).build();
            for (Module module3 : modules) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(module3);
                if (androidModel != null) {
                    IdeAndroidProject moduleAndroidProject = androidModel.getAndroidProject();
                    GradleAndroidModule.Builder androidModule = GradleAndroidModule.newBuilder();
                    androidModule.setModuleName(AnonymizerUtil.anonymizeUtf8((String)module3.getName())).setSigningConfigCount((long)moduleAndroidProject.getSigningConfigs().size()).setIsLibrary(moduleAndroidProject.getProjectType() == 1).setBuildTypeCount((long)androidModel.getBuildTypeNames().size()).setFlavorCount((long)androidModel.getProductFlavorNames().size()).setFlavorDimension((long)moduleAndroidProject.getFlavorDimensions().size());
                    gradleAndroidModules.add(androidModule.build());
                }
                boolean shouldReportNative = false;
                NdkModuleModel ndkModel = NdkModuleModel.get(module3);
                GradleNativeAndroidModule.NativeBuildSystemType buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
                String moduleName2 = "";
                if (ndkModel != null) {
                    shouldReportNative = true;
                    if (ndkModel.getFeatures().isBuildSystemNameSupported()) {
                        for (String buildSystem : ndkModel.getBuildSystems()) {
                            buildSystemType = ProjectStructureUsageTracker.stringToBuildSystemType(buildSystem);
                        }
                    } else {
                        buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                    }
                    moduleName2 = AnonymizerUtil.anonymizeUtf8((String)ndkModel.getModuleName());
                }
                if (!shouldReportNative) continue;
                GradleNativeAndroidModule.Builder nativeModule = GradleNativeAndroidModule.newBuilder();
                nativeModule.setModuleName(moduleName2).setBuildSystemType(buildSystemType);
                gradleNativeAndroidModules.add(nativeModule.build());
            }
            GradleBuildDetails.Builder gradleBuild = GradleBuildDetails.newBuilder();
            gradleBuild.setAppId(appId).setAndroidPluginVersion(androidProject.getModelVersion()).setGradleVersion(gradleVersion2.toString()).addAllLibraries(gradleLibraries).addModules(gradleModule).addAllAndroidModules(gradleAndroidModules).addAllNativeAndroidModules(gradleNativeAndroidModules);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_DETAILS).setGradleBuildDetails(gradleBuild);
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myProject));
        }
    }

    @VisibleForTesting
    static GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
        switch (buildSystem) {
            case "ndkBuild": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD;
            }
            case "cmake": {
                return GradleNativeAndroidModule.NativeBuildSystemType.CMAKE;
            }
            case "ndkCompile": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
            }
            case "gradle": {
                return GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
            }
        }
        return GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
    }

    private static GradleLibrary trackExternalDependenciesInAndroidApp(@NotNull AndroidModuleModel model2) {
        Ref chosenVariant = new Ref();
        model2.getVariants().forEach(variant2 -> {
            if ("release".equals(variant2.getBuildType())) {
                chosenVariant.set(variant2);
            }
        });
        if (chosenVariant.get() == null) {
            chosenVariant.set((Object)model2.getSelectedVariant());
        }
        IdeDependencies dependencies2 = ((IdeVariant)chosenVariant.get()).getMainArtifact().getLevel2Dependencies();
        return GradleLibrary.newBuilder().setAarDependencyCount((long)dependencies2.getAndroidLibraries().size()).setJarDependencyCount((long)dependencies2.getJavaLibraries().size()).build();
    }
}

