/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class LibraryDependency
extends Dependency {
    @NotNull
    public static final String NAME_PREFIX = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
    @NotNull
    private final Collection<File> myBinaryPaths;
    @NotNull
    private final File myArtifactPath;

    public static LibraryDependency create(@NotNull File artifactPath, @NotNull Collection<File> binaryPaths) {
        return new LibraryDependency(artifactPath, binaryPaths);
    }

    @VisibleForTesting
    public LibraryDependency(@NotNull File artifactPath, @NotNull Collection<File> binaryPaths) {
        this.myBinaryPaths = new LinkedHashSet<File>(binaryPaths);
        this.myArtifactPath = artifactPath;
    }

    @NotNull
    public File[] getBinaryPaths() {
        return this.myBinaryPaths.isEmpty() ? ArrayUtilRt.EMPTY_FILE_ARRAY : this.myBinaryPaths.toArray(new File[0]);
    }

    @NotNull
    public File getArtifactPath() {
        return this.myArtifactPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryDependency)) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)o;
        return Objects.equals(this.myBinaryPaths, that.myBinaryPaths) && Objects.equals(this.myArtifactPath, that.myArtifactPath);
    }

    public int hashCode() {
        return Objects.hash(this.myBinaryPaths, this.myArtifactPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[, pathsByType=" + this.myBinaryPaths + "]";
    }
}

