/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.messages.MessageType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseSyncIssuesReporter {
    BaseSyncIssuesReporter() {
    }

    @NotNull
    GradleSyncMessages getSyncMessages(@NotNull Module module2) {
        return GradleSyncMessages.getInstance(module2.getProject());
    }

    abstract int getSupportedIssueType();

    abstract void report(@NotNull IdeSyncIssue var1, @NotNull Module var2, @Nullable VirtualFile var3, @NotNull SyncIssueUsageReporter var4);

    void reportAll(@NotNull List<IdeSyncIssue> syncIssues2, @NotNull Map<IdeSyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull SyncIssueUsageReporter usageReporter) {
        for (IdeSyncIssue issue2 : syncIssues2) {
            this.report(issue2, moduleMap.get(issue2), buildFileMap.get(moduleMap.get(issue2)), usageReporter);
        }
    }

    @NotNull
    static MessageType getMessageType(@NotNull IdeSyncIssue syncIssue) {
        return syncIssue.getSeverity() == 2 ? MessageType.WARNING : MessageType.INFO;
    }
}

