/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.gradle.project.sync.idea.DependencyUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.InvalidGradleWrapperException;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.PersistentSHA256Checksums;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"findGradleWrapper", "Lcom/android/tools/idea/gradle/util/GradleWrapper;", "projectPath", "", "validateChecksums", "", "wrapper", "validateGradleWrapper", "", "intellij.android.core"})
@JvmName(name="GradleWrapperImportCheck")
public final class GradleWrapperImportCheck {
    public static final void validateGradleWrapper(@NotNull String projectPath) {
        GradleWrapper gradleWrapper = GradleWrapperImportCheck.findGradleWrapper(projectPath);
        if (gradleWrapper == null) {
            return;
        }
        GradleWrapper gradleWrapper2 = gradleWrapper;
        try {
            if (gradleWrapper2.getDistributionSha256Sum() == null) {
                return;
            }
            if (GradleWrapperImportCheck.validateChecksums(gradleWrapper2)) {
                return;
            }
        }
        catch (IOException exception) {
            DependencyUtilKt.getRESOLVER_LOG().warn((Throwable)exception);
        }
        throw (Throwable)new InvalidGradleWrapperException(gradleWrapper2);
    }

    private static final boolean validateChecksums(GradleWrapper wrapper) throws IOException {
        String string = wrapper.getDistributionUrl();
        if (string == null) {
            return false;
        }
        String urlString = string;
        if (StringsKt.equals((String)new URL(urlString).getProtocol(), (String)"file", (boolean)true)) {
            return true;
        }
        PersistentSHA256Checksums checksums = PersistentSHA256Checksums.getInstance();
        return checksums.isChecksumStored(wrapper.getDistributionUrl(), wrapper.getDistributionSha256Sum());
    }

    private static final GradleWrapper findGradleWrapper(String projectPath) {
        File propertiesFile = GradleWrapper.getDefaultPropertiesFilePath(new File(projectPath));
        if (!propertiesFile.isFile()) {
            return null;
        }
        return GradleWrapper.get(propertiesFile, null);
    }
}

