/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.util.PersistentSHA256Checksums;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/issues/ConfirmSHA256FromGradleWrapperQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "distributionSHA", "", "distributionUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "getDistributionSHA", "getDistributionUrl", "id", "getId", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.android.core"})
final class ConfirmSHA256FromGradleWrapperQuickFix
implements DescribedBuildIssueQuickFix {
    @NotNull
    private final String description;
    @NotNull
    private final String id;
    @NotNull
    private final String distributionSHA;
    @NotNull
    private final String distributionUrl;

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataProvider dataProvider) {
        PersistentSHA256Checksums.getInstance().storeChecksum(this.distributionUrl, this.distributionSHA);
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_DISTRIBUTIONSHA256SUM_CONFIRMED_BY_USER);
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public final String getDistributionSHA() {
        return this.distributionSHA;
    }

    @NotNull
    public final String getDistributionUrl() {
        return this.distributionUrl;
    }

    public ConfirmSHA256FromGradleWrapperQuickFix(@NotNull String distributionSHA, @NotNull String distributionUrl) {
        this.distributionSHA = distributionSHA;
        this.distributionUrl = distributionUrl;
        this.description = "Use \"" + StringsKt.take((String)this.distributionSHA, (int)9) + (this.distributionSHA.length() > 9 ? "..." : "") + '\"' + " as checksum for " + this.distributionUrl + " and sync project";
        this.id = "confirm.SHA256.from.gradle.wrapper";
    }

    @Override
    @NotNull
    public String getHtml() {
        return DescribedBuildIssueQuickFix.DefaultImpls.getHtml(this);
    }
}

