/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateKt;
import com.android.tools.idea.gradle.project.sync.ProjectSyncRequest;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.idea.IdeAndroidNativeVariantsModelsWrapper;
import com.android.tools.idea.gradle.project.sync.idea.ProjectResolutionMode;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueData;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssues;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

public class GradleSyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    public static final com.intellij.openapi.util.Key<Boolean> FULL_SYNC_KEY = new com.intellij.openapi.util.Key("android.full.sync");

    public GradleSyncExecutor(@NotNull Project project) {
        this.myProject = project;
    }

    @WorkerThread
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        this.myProject.putUserData(FULL_SYNC_KEY, (Object)request.forceFullVariantsSync);
        Set androidProjectCandidatesPaths = GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().stream().map(ExternalProjectSettings::getExternalProjectPath).collect(Collectors.toSet());
        if (androidProjectCandidatesPaths.isEmpty() && IdeInfo.getInstance().isAndroidStudio()) {
            String foundPath = GradleSyncExecutor.attemptToLinkGradleProject(this.myProject);
            if (foundPath != null) {
                androidProjectCandidatesPaths.add(foundPath);
            } else {
                GradleSyncState.getInstance(this.myProject).syncSkipped(listener2);
                return;
            }
        }
        for (String rootPath : androidProjectCandidatesPaths) {
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, listener2);
            ProgressExecutionMode executionMode = request.getProgressExecutionMode();
            ImportSpecBuilder builder2 = new ImportSpecBuilder(this.myProject, GradleUtil.GRADLE_SYSTEM_ID).callback((ExternalProjectRefreshCallback)setUpTask).use(executionMode);
            this.myProject.putUserData(GradleSyncStateKt.PROJECT_SYNC_REQUEST, (Object)new ProjectSyncRequest(rootPath, request.trigger, request.forceFullVariantsSync));
            ExternalSystemUtil.refreshProject((String)rootPath, (ImportSpec)builder2.build());
        }
    }

    @Nullable
    public static String attemptToLinkGradleProject(@NotNull Project project) {
        @SystemIndependent String projectBasePath = project.getBasePath();
        if (projectBasePath == null) {
            return null;
        }
        String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectBasePath);
        VirtualFile projectRootFolder = project.getBaseDir();
        projectRootFolder.refresh(false, true);
        if (!GradleProjectImportUtil.canOpenGradleProject((VirtualFile)projectRootFolder)) {
            return null;
        }
        GradleProjectSettings projectSettings = new GradleProjectSettings();
        GradleProjectImportUtil.setupGradleSettings((GradleSettings)GradleSettings.getInstance((Project)project));
        GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Path)new File(externalProjectPath).toPath());
        GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)projectSettings.resolveGradleVersion());
        GradleSettings.getInstance((Project)project).setStoreProjectFilesExternally(false);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
        return externalProjectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public List<GradleModuleModels> fetchGradleModels() {
        DataNode projectDataNode;
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        this.myProject.putUserData(FULL_SYNC_KEY, (Object)true);
        try {
            GradleProjectResolver projectResolver = new GradleProjectResolver();
            projectDataNode = projectResolver.resolveProjectInfo(id, projectPath, false, (ExternalSystemExecutionSettings)settings, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        }
        finally {
            this.myProject.putUserData(FULL_SYNC_KEY, null);
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        if (projectDataNode != null) {
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                DataNode androidModelNode;
                DataNode gradleModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.GRADLE_MODULE_MODEL);
                if (gradleModelNode == null) continue;
                PsdModuleModels moduleModules = new PsdModuleModels(((ModuleData)moduleNode.getData()).getExternalName());
                moduleModules.addModel(GradleModuleModel.class, gradleModelNode.getData());
                @NotNull Collection syncIssueNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, AndroidProjectKeys.SYNC_ISSUE);
                if (!syncIssueNodes.isEmpty()) {
                    moduleModules.addModel(SyncIssues.class, new SyncIssues(ContainerUtil.map((Collection)syncIssueNodes, it -> (SyncIssueData)it.getData())));
                }
                if ((androidModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                    moduleModules.addModel(AndroidModuleModel.class, androidModelNode.getData());
                    DataNode ndkModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.NDK_MODEL);
                    if (ndkModelNode != null) {
                        moduleModules.addModel(NdkModuleModel.class, ndkModelNode.getData());
                    }
                    builder2.add((Object)moduleModules);
                    continue;
                }
                DataNode javaModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.JAVA_MODULE_MODEL);
                if (javaModelNode == null) continue;
                moduleModules.addModel(JavaModuleModel.class, javaModelNode.getData());
                builder2.add((Object)moduleModules);
            }
        }
        return builder2.build();
    }

    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull @NotNull Set<@NotNull String> requestedAbis) {
        SelectedVariantCollector variantCollector = new SelectedVariantCollector(this.myProject);
        SelectedVariants selectedVariants = variantCollector.collectSelectedVariants();
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (settings == null) {
            throw new IllegalStateException("Cannot obtain GradleExecutionSettings");
        }
        Map<String, String> variantsByNativeModule = selectedVariants.getSelectedVariants().values().stream().filter(it -> it.getAbiName() != null).collect(Collectors.toMap(it -> it.getModuleId(), it -> it.getVariantName()));
        settings.putUserData(AndroidGradleProjectResolver.REQUESTED_PROJECT_RESOLUTION_MODE_KEY, (Object)new ProjectResolutionMode.FetchNativeVariantsMode(variantsByNativeModule, requestedAbis));
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        GradleProjectResolver projectResolver = new GradleProjectResolver();
        GradlePartialResolverPolicy projectResolverPolicy = new GradlePartialResolverPolicy(it -> it instanceof AndroidGradleProjectResolver);
        DataNode projectDataNode = projectResolver.resolveProjectInfo(id, projectPath, false, settings, (ProjectResolverPolicy)projectResolverPolicy, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        if (projectDataNode == null) {
            Logger.getInstance(GradleSyncExecutor.class).warn("Failed to retrieve native variant models.");
            return;
        }
        @NotNull Collection nativeVariants = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, AndroidProjectKeys.NATIVE_VARIANTS);
        Map<String, Module> moduleMap = Stream.of(ModuleManager.getInstance((Project)this.myProject).getModules()).filter(it -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)it)).collect(Collectors.toMap(it -> ExternalSystemApiUtil.getExternalProjectId((Module)it), it -> it));
        for (DataNode nativeVariantsWrapperNode : nativeVariants) {
            IdeAndroidNativeVariantsModelsWrapper nativeVariantsWrapper = (IdeAndroidNativeVariantsModelsWrapper)nativeVariantsWrapperNode.getData();
            String moduleId = nativeVariantsWrapper.getModuleId();
            Module module2 = moduleMap.get(moduleId);
            if (module2 == null) {
                Logger.getInstance(GradleSyncExecutor.class).error("Module not found. ModuleId: " + moduleId);
                continue;
            }
            NdkFacet ndkFacet = NdkFacet.getInstance(module2);
            if (ndkFacet == null) {
                Logger.getInstance(GradleSyncExecutor.class).error("NdkFacet not found. ModuleId: " + moduleId);
                continue;
            }
            nativeVariantsWrapper.mergeInto(ndkFacet);
        }
    }
}

