/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestCompileType {
    public static final TestCompileType ALL = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant2) {
            ImmutableList.Builder builder2 = ImmutableList.builder();
            if (variant2.getUnitTestArtifact() != null) {
                builder2.add((Object)variant2.getUnitTestArtifact());
            }
            if (variant2.getAndroidTestArtifact() != null) {
                builder2.add((Object)variant2.getAndroidTestArtifact());
            }
            return builder2.build();
        }
    };
    public static final TestCompileType ANDROID_TESTS = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant2) {
            IdeAndroidArtifact testArtifact = variant2.getAndroidTestArtifact();
            return testArtifact != null ? Collections.singleton(testArtifact) : Collections.emptySet();
        }
    };
    public static final TestCompileType UNIT_TESTS = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant2) {
            IdeJavaArtifact testArtifact = variant2.getUnitTestArtifact();
            return testArtifact != null ? Collections.singleton(testArtifact) : Collections.emptySet();
        }
    };
    public static final TestCompileType NONE = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant2) {
            return Collections.emptySet();
        }
    };

    @NotNull
    public abstract Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant var1);

    @NotNull
    public static TestCompileType get(@Nullable String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidBuildCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                return ANDROID_TESTS;
            }
            if (AndroidBuildCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                return UNIT_TESTS;
            }
        }
        return ALL;
    }
}

