/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeTestedTargetVariant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.build.invoker.GradleRootPathFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleTaskFinder {
    private final GradleRootPathFinder myRootPathFinder;

    @NotNull
    public static GradleTaskFinder getInstance() {
        return (GradleTaskFinder)ServiceManager.getService(GradleTaskFinder.class);
    }

    public GradleTaskFinder() {
        this(new GradleRootPathFinder());
    }

    @NonInjectable
    @VisibleForTesting
    GradleTaskFinder(GradleRootPathFinder rootPathFinder) {
        this.myRootPathFinder = rootPathFinder;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecuteForTest(@NotNull Module[] modules, @NotNull Module[] testModules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        ListMultimap<Path, String> allTasks = this.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        ListMultimap<Path, String> testedModulesTasks = this.findTasksToExecute(testModules, buildMode, testCompileType);
        for (Map.Entry task2 : testedModulesTasks.entries()) {
            if (allTasks.values().contains(task2.getValue())) continue;
            allTasks.put(task2.getKey(), task2.getValue());
        }
        return allTasks;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        LinkedHashMultimap tasks = LinkedHashMultimap.create();
        if (BuildMode.ASSEMBLE == buildMode && !GradleTaskFinder.canAssembleModules(modules)) {
            for (Module module2 : modules) {
                Path projectRootPath = this.myRootPathFinder.getProjectRootPath(module2);
                tasks.put((Object)projectRootPath, (Object)"assemble");
            }
            return ArrayListMultimap.create((Multimap)tasks);
        }
        LinkedHashSet<Module> allModules = new LinkedHashSet<Module>();
        for (Object module3 : modules) {
            allModules.addAll(DynamicAppUtils.getModulesToBuild(module3));
        }
        if (testCompileType == TestCompileType.ANDROID_TESTS) {
            for (Object module3 : modules) {
                Module baseAppModule = DynamicAppUtils.getBaseFeature(module3);
                if (baseAppModule == null) continue;
                allModules.add(baseAppModule);
            }
        }
        for (Module module4 : allModules) {
            String modulePath = ExternalSystemModulePropertyManager.getInstance((Module)module4).getLinkedProjectId();
            if (modulePath != null && modulePath.endsWith(":buildSrc")) continue;
            LinkedHashSet<String> moduleTasks = new LinkedHashSet<String>();
            this.findAndAddGradleBuildTasks(module4, buildMode, moduleTasks, testCompileType);
            Path keyPath = this.myRootPathFinder.getProjectRootPath(module4);
            moduleTasks.addAll(tasks.get((Object)keyPath));
            tasks.removeAll((Object)keyPath);
            if (buildMode == BuildMode.REBUILD && !moduleTasks.isEmpty()) {
                tasks.put((Object)keyPath, (Object)"clean");
            }
            tasks.putAll((Object)keyPath, moduleTasks);
        }
        if (tasks.isEmpty()) {
            String format2 = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleTaskFinder.getLogger().info(String.format(format2, modules[0].getProject().getName(), buildMode.name()));
        }
        return ArrayListMultimap.create((Multimap)tasks);
    }

    private static boolean canAssembleModules(@NotNull Module[] modules) {
        if (modules.length == 0) {
            return false;
        }
        Project project = modules[0].getProject();
        return !GradleSyncState.getInstance(project).lastSyncFailed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findAndAddGradleBuildTasks(@NotNull Module module2, @NotNull BuildMode buildMode, @NotNull Set<String> tasks, @NotNull TestCompileType testCompileType) {
        GradleFacet gradleFacet = GradleFacet.getInstance(module2);
        if (gradleFacet == null) {
            return;
        }
        String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
        if (StringUtil.isEmpty((String)gradlePath)) {
            String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module2.getName());
            GradleTaskFinder.getLogger().info(msg);
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet != null) {
            AndroidFacetProperties properties2 = androidFacet.getProperties();
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            switch (buildMode) {
                case CLEAN: 
                case SOURCE_GEN: {
                    this.addAfterSyncTasks(tasks, gradlePath, properties2);
                    if (androidModel == null) return;
                    this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                    return;
                }
                case ASSEMBLE: 
                case REBUILD: {
                    this.addTaskIfSpecified(tasks, gradlePath, properties2.ASSEMBLE_TASK_NAME);
                    if (testCompileType != TestCompileType.ALL && androidModel != null) {
                        for (IdeBaseArtifact artifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                            this.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                        }
                    }
                    this.addAssembleTasksForTargetVariants(tasks, module2);
                    return;
                }
                case BUNDLE: {
                    if (androidModel == null || androidModel.getAndroidProject().getProjectType() != 0) return;
                    String taskName = androidModel.getSelectedVariant().getMainArtifact().getBundleTaskName();
                    this.addTaskIfSpecified(tasks, gradlePath, taskName);
                    return;
                }
                case APK_FROM_BUNDLE: {
                    if (androidModel != null && androidModel.getAndroidProject().getProjectType() == 0) {
                        String taskName = androidModel.getSelectedVariant().getMainArtifact().getApkFromBundleTaskName();
                        this.addTaskIfSpecified(tasks, gradlePath, taskName);
                        return;
                    }
                    if (androidModel == null || androidModel.getAndroidProject().getProjectType() != 6 || testCompileType != TestCompileType.ANDROID_TESTS) return;
                    for (IdeBaseArtifact artifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                        this.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                    }
                    return;
                }
                default: {
                    this.addAfterSyncTasks(tasks, gradlePath, properties2);
                    if (androidModel != null) {
                        this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        for (IdeBaseArtifact artifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                            this.addTaskIfSpecified(tasks, gradlePath, artifact.getCompileTaskName());
                        }
                    }
                    if (testCompileType == TestCompileType.UNIT_TESTS) return;
                    this.addTaskIfSpecified(tasks, gradlePath, properties2.COMPILE_JAVA_TASK_NAME);
                }
            }
            return;
        }
        JavaFacet javaFacet = JavaFacet.getInstance(module2);
        if (javaFacet == null || !((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) return;
        String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
        if (gradleTaskName != null) {
            tasks.add(this.createBuildTask(gradlePath, gradleTaskName));
        }
        if (!TestCompileType.UNIT_TESTS.equals(testCompileType) && !TestCompileType.ALL.equals(testCompileType)) return;
        tasks.add(this.createBuildTask(gradlePath, "testClasses"));
    }

    private void addAssembleTasksForTargetVariants(@NotNull Set<String> tasks, @NotNull Module testOnlyModule) {
        AndroidModuleModel testAndroidModel = AndroidModuleModel.get(testOnlyModule);
        if (testAndroidModel == null || !testAndroidModel.getFeatures().isTestedTargetVariantsSupported() || testAndroidModel.getAndroidProject().getProjectType() != 2) {
            return;
        }
        for (IdeTestedTargetVariant testedTargetVariant : testAndroidModel.getSelectedVariant().getTestedTargetVariants()) {
            String targetVariantName;
            IdeVariant targetVariant;
            AndroidModuleModel targetAndroidModel;
            String targetProjectGradlePath = testedTargetVariant.getTargetProjectPath();
            Module targetModule = GradleUtil.findModuleByGradlePath(testOnlyModule.getProject(), targetProjectGradlePath);
            if (targetModule == null || (targetAndroidModel = AndroidModuleModel.get(targetModule)) == null || (targetVariant = targetAndroidModel.findVariantByName(targetVariantName = testedTargetVariant.getTargetVariant())) == null) continue;
            this.addTaskIfSpecified(tasks, targetProjectGradlePath, targetVariant.getMainArtifact().getAssembleTaskName());
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleTaskFinder.class);
    }

    private void addAfterSyncTasksForTestArtifacts(@NotNull Set<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @NotNull AndroidModuleModel androidModel) {
        IdeVariant variant2 = androidModel.getSelectedVariant();
        Collection<IdeBaseArtifact> testArtifacts = testCompileType.getArtifacts(variant2);
        for (IdeBaseArtifact artifact : testArtifacts) {
            for (String taskName : artifact.getIdeSetupTaskNames()) {
                this.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    private void addAfterSyncTasks(@NotNull Set<String> tasks, @NotNull String gradlePath, @NotNull AndroidFacetProperties properties2) {
        for (String taskName : properties2.AFTER_SYNC_TASK_NAMES) {
            this.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private void addTaskIfSpecified(@NotNull Set<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        if (StringUtil.isNotEmpty((String)gradleTaskName)) {
            String buildTask = this.createBuildTask(gradlePath, gradleTaskName);
            tasks.add(buildTask);
        }
    }

    @NotNull
    public String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath.endsWith(":")) {
            return gradleProjectPath + taskName;
        }
        return gradleProjectPath + ":" + taskName;
    }
}

