/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginInfo {
    public static final String APPLICATION_PLUGIN_ID = "com.android.application";
    public static final String DESCRIPTION = "Android Gradle plugin";
    public static final String ARTIFACT_ID = "gradle";
    public static final String API_ARTIFACT_ID = "gradle-api";
    public static final String GROUP_ID = "com.android.tools.build";
    @NotNull
    private final Module myModule;
    @Nullable
    private final GradleVersion myPluginVersion;
    @Nullable
    private final VirtualFile myPluginBuildFile;

    @Slow
    @Nullable
    public static AndroidPluginInfo find(@NotNull Project project) {
        AndroidPluginInfo modelPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (modelPluginInfo != null && modelPluginInfo.getPluginVersion() != null) {
            return modelPluginInfo;
        }
        AndroidPluginInfo buildPluginInfo = AndroidPluginInfo.findInBuildFiles(project, modelPluginInfo == null ? null : modelPluginInfo.getModule());
        return buildPluginInfo == null ? modelPluginInfo : buildPluginInfo;
    }

    @Slow
    @Nullable
    public static AndroidPluginInfo findFromBuildFiles(@NotNull Project project) {
        return AndroidPluginInfo.findInBuildFiles(project, null);
    }

    @Nullable
    public static AndroidPluginInfo findFromModel(@NotNull Project project) {
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel gradleModel = AndroidModuleModel.get(module2);
            if (gradleModel == null || gradleModel.getAndroidProject().getProjectType() != 0) continue;
            return new AndroidPluginInfo(module2, gradleModel.getModelVersion(), null);
        }
        return null;
    }

    @Slow
    @Nullable
    private static AndroidPluginInfo findInBuildFiles(@NotNull Project project, @Nullable Module appModule) {
        Module fileAppModule = null;
        BuildFileSearchResult result2 = AndroidPluginInfo.searchInBuildFiles(project, appModule == null);
        if (result2.appVirtualFile != null) {
            fileAppModule = ModuleUtilCore.findModuleForFile((VirtualFile)result2.appVirtualFile, (Project)project);
        }
        if (fileAppModule != null || appModule != null) {
            GradleVersion pluginVersion = StringUtil.isNotEmpty((String)result2.pluginVersion) ? GradleVersion.tryParse((String)result2.pluginVersion) : null;
            return new AndroidPluginInfo(fileAppModule == null ? appModule : fileAppModule, pluginVersion, result2.pluginVirtualFile);
        }
        return null;
    }

    @Slow
    @NotNull
    private static BuildFileSearchResult searchInBuildFiles(@NotNull Project project, boolean searchForAppModule) {
        BuildFileSearchResult result2 = new BuildFileSearchResult();
        BuildFileProcessor.getInstance().processRecursively(project, (Processor<? super GradleBuildModel>)((Processor)buildModel -> {
            boolean keepSearchingForPluginVersion;
            List<String> pluginIds;
            boolean keepSearchingForAppModule;
            boolean bl = keepSearchingForAppModule = searchForAppModule && result2.appVirtualFile == null;
            if (keepSearchingForAppModule && (pluginIds = PluginModel.extractNames(buildModel.plugins())).contains(APPLICATION_PLUGIN_ID)) {
                result2.appVirtualFile = buildModel.getVirtualFile();
                keepSearchingForAppModule = false;
            }
            boolean bl2 = keepSearchingForPluginVersion = result2.pluginVersion == null;
            if (keepSearchingForPluginVersion) {
                DependenciesModel dependencies2 = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies2.artifacts("classpath")) {
                    if (!AndroidPluginInfo.isAndroidPlugin(dependency.name().forceString(), dependency.group().toString())) continue;
                    String version2 = dependency.version().toString();
                    if (StringUtil.isNotEmpty((String)version2)) {
                        result2.pluginVirtualFile = buildModel.getVirtualFile();
                        result2.pluginVersion = version2;
                    }
                    keepSearchingForPluginVersion = false;
                    break;
                }
            }
            return keepSearchingForAppModule || keepSearchingForPluginVersion;
        }));
        return result2;
    }

    @VisibleForTesting
    public AndroidPluginInfo(@NotNull Module module2, @Nullable GradleVersion pluginVersion, @Nullable VirtualFile pluginBuildFile) {
        this.myModule = module2;
        this.myPluginVersion = pluginVersion;
        this.myPluginBuildFile = pluginBuildFile;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public LatestKnownPluginVersionProvider getLatestKnownPluginVersionProvider() {
        return LatestKnownPluginVersionProvider.INSTANCE;
    }

    @Nullable
    public GradleVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @Nullable
    public VirtualFile getPluginBuildFile() {
        return this.myPluginBuildFile;
    }

    public boolean isExperimental() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPluginInfo that = (AndroidPluginInfo)o;
        return Objects.equals(this.myModule, that.myModule) && Objects.equals(this.myPluginVersion, that.myPluginVersion) && Objects.equals(this.myPluginBuildFile, that.myPluginBuildFile);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myPluginVersion, this.myPluginBuildFile);
    }

    public static boolean isAndroidPlugin(@NotNull String artifactId, String groupId) {
        return ARTIFACT_ID.equals(artifactId) && GROUP_ID.equals(groupId);
    }

    public static boolean isAndroidPluginOrApi(@NotNull String artifactId, @Nullable String groupId) {
        return AndroidPluginInfo.isAndroidPlugin(artifactId, groupId) || API_ARTIFACT_ID.equals(artifactId) && GROUP_ID.equals(groupId);
    }

    private static class BuildFileSearchResult {
        @Nullable
        VirtualFile appVirtualFile;
        @Nullable
        VirtualFile pluginVirtualFile;
        @Nullable
        String pluginVersion;

        private BuildFileSearchResult() {
        }
    }
}

