/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.utils.BuildScriptUtil;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final ResolvedConfigurationFileLocationProvider myResolvedConfigurationFileLocationProvider;
    @NotNull
    private final Map<GradleDslFile, ClassToInstanceMap<BuildModelNotification>> myNotifications = new HashMap<GradleDslFile, ClassToInstanceMap<BuildModelNotification>>();
    @NotNull
    private final DependencyManager myDependencyManager;
    @Nullable
    private GradleBuildFile myRootProjectFile;

    public void setRootProjectFile(@NotNull GradleBuildFile rootProjectFile) {
        this.myRootProjectFile = rootProjectFile;
    }

    @Nullable
    public GradleBuildFile getRootProjectFile() {
        return this.myRootProjectFile;
    }

    @NotNull
    public static BuildModelContext create(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        return new BuildModelContext(project, resolvedConfigurationFileLocationProvider);
    }

    private BuildModelContext(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myResolvedConfigurationFileLocationProvider = resolvedConfigurationFileLocationProvider;
        this.myDependencyManager = DependencyManager.create();
        this.myRootProjectFile = null;
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        return this.myDependencyManager;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications(@NotNull GradleDslFile file2) {
        return new ArrayList<BuildModelNotification>(this.myNotifications.getOrDefault(file2, (ClassToInstanceMap<BuildModelNotification>)MutableClassToInstanceMap.create()).values());
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull GradleDslFile file2, @NotNull NotificationTypeReference<T> type) {
        ClassToInstanceMap notificationMap = this.myNotifications.computeIfAbsent(file2, f -> MutableClassToInstanceMap.create());
        if (notificationMap.containsKey(type.getClazz())) {
            return (T)((BuildModelNotification)notificationMap.getInstance(type.getClazz()));
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        notificationMap.putInstance(type.getClazz(), (Object)notification);
        return (T)notification;
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myFileCache.getCurrentParsingRoot();
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file2, @NotNull String name, boolean isApplied) {
        return this.myFileCache.getOrCreateBuildFile(file2, name, this, isApplied);
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file2, boolean isApplied) {
        return this.getOrCreateBuildFile(file2, file2.getName(), isApplied);
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile) {
        return this.myFileCache.getOrCreateSettingsFile(settingsFile, this);
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file2, @NotNull String moduleName2) {
        return this.myFileCache.getOrCreatePropertiesFile(file2, moduleName2, this);
    }

    @NotNull
    public GradleBuildFile parseBuildFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String moduleName2, boolean isApplied) {
        GradleBuildFile buildDslFile = new GradleBuildFile(file2, project, moduleName2, this);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!isApplied) {
                this.populateWithParentModuleSubProjectsProperties(buildDslFile);
            }
            this.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
            buildDslFile.parse();
        });
        return buildDslFile;
    }

    public GradleBuildFile parseProjectBuildFile(@NotNull Project project, @Nullable VirtualFile file2) {
        GradleBuildFile result2;
        GradleBuildFile gradleBuildFile = result2 = file2 != null ? new GradleBuildFile(file2, project, ":", this) : null;
        if (result2 != null) {
            this.setRootProjectFile(result2);
            ApplicationManager.getApplication().runReadAction(() -> {
                this.populateWithParentModuleSubProjectsProperties(result2);
                this.populateSiblingDslFileWithGradlePropertiesFile(result2);
                result2.parse();
            });
            this.putBuildFile(file2.getUrl(), result2);
        }
        return result2;
    }

    private void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        this.myFileCache.putBuildFile(name, buildFile);
    }

    @NotNull
    public List<GradleDslFile> getAllRequestedFiles() {
        return this.myFileCache.getAllFiles();
    }

    private void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile) {
        File propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties");
        VirtualFile propertiesFile = VfsUtil.findFileByIoFile((File)propertiesFilePath, (boolean)false);
        if (propertiesFile == null) {
            return;
        }
        GradlePropertiesFile parsedProperties = this.getOrCreatePropertiesFile(propertiesFile, buildDslFile.getName());
        if (parsedProperties == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = new GradlePropertiesModel(parsedProperties);
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    private void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile) {
        VirtualFile maybeSettingsFile = buildDslFile.tryToFindSettingsFile();
        if (maybeSettingsFile == null) {
            return;
        }
        GradleSettingsFile settingsFile = this.getOrCreateSettingsFile(maybeSettingsFile);
        GradleSettingsModelImpl gradleSettingsModel = new GradleSettingsModelImpl(settingsFile);
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (!(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleDslFile parentModuleDslFile = parentModuleModelImpl.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement(SubProjectsDslElement.SUBPROJECTS);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement(subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            GradleDslElement element2 = entry.getValue();
            if (element2 instanceof ApplyDslElement) {
                ApplyDslElement subProjectsApply = (ApplyDslElement)element2;
                ApplyDslElement myApply = new ApplyDslElement(buildDslFile);
                buildDslFile.setParsedElement(myApply);
                for (GradleDslElement appliedElement : subProjectsApply.getAllElements()) {
                    myApply.addParsedElement(appliedElement);
                }
                continue;
            }
            buildDslFile.setParsedElement(element2);
        }
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull Module module2) {
        VirtualFile result2 = this.myResolvedConfigurationFileLocationProvider.getGradleBuildFile(module2);
        if (result2 != null) {
            return result2;
        }
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(module2);
        if (rootPath == null) {
            return null;
        }
        File moduleRoot = new File(FileUtil.toSystemDependentName((String)rootPath));
        return this.getGradleBuildFile(moduleRoot);
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile((File)dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath = BuildScriptUtil.findGradleSettingsFile((File)dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public VirtualFile getProjectSettingsFile() {
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        if (rootPath == null) {
            return null;
        }
        return this.getGradleSettingsFile(new File(FileUtil.toSystemDependentName((String)rootPath)));
    }

    public static interface ResolvedConfigurationFileLocationProvider {
        @Nullable
        public VirtualFile getGradleBuildFile(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Project var1);
    }
}

