/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import org.jetbrains.annotations.NotNull;

public class AdbShellCommandBuilder {
    @NotNull
    private final StringBuilder myCommand = new StringBuilder();
    private boolean myNeedsTrailingQuote;

    public String toString() {
        return this.build();
    }

    @NotNull
    public String build() {
        if (this.myNeedsTrailingQuote) {
            this.myCommand.append("'");
        }
        return this.myCommand.toString();
    }

    @NotNull
    public AdbShellCommandBuilder withText(@NotNull String text2) {
        this.myCommand.append(text2);
        return this;
    }

    @NotNull
    public AdbShellCommandBuilder withSuRootPrefix() {
        if (this.myCommand.length() > 0) {
            throw new IllegalStateException("\"su 0\" must be the first argument");
        }
        this.myCommand.append("su 0 sh -c '");
        this.myNeedsTrailingQuote = true;
        return this;
    }

    public AdbShellCommandBuilder withRunAs(@NotNull String packageName) {
        if (this.myCommand.length() > 0) {
            throw new IllegalStateException("\"run-as\" must be the first argument");
        }
        this.withText("run-as ").withText(packageName).withText(" sh -c '");
        this.myNeedsTrailingQuote = true;
        return this;
    }

    @NotNull
    public AdbShellCommandBuilder withEscapedPath(@NotNull String path2) {
        this.myCommand.append(AdbPathUtil.getEscapedPath(path2));
        return this;
    }

    @NotNull
    public AdbShellCommandBuilder withDirectoryEscapedPath(@NotNull String path2) {
        if (!(path2 = AdbPathUtil.getEscapedPath(path2)).endsWith("/")) {
            path2 = path2 + "/";
        }
        this.myCommand.append(path2);
        return this;
    }
}

