/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.emulator.control.ClipData;
import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.emulator.control.KeyboardEvent;
import com.android.emulator.control.MouseEvent;
import com.android.emulator.control.Rotation;
import com.android.ide.common.util.Cancelable;
import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.emulator.EmptyStreamObserver;
import com.android.tools.idea.emulator.EmulatorConfiguration;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.EmulatorLoadingPanel;
import com.android.tools.idea.emulator.EmulatorUtilsKt;
import com.android.tools.idea.emulator.EmulatorView$WhenMappings;
import com.android.tools.idea.emulator.EmulatorViewKt;
import com.android.tools.idea.emulator.SkinDefinition;
import com.android.tools.idea.emulator.SkinLayout;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.protobuf.Empty;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.SofterReference;
import com.intellij.xml.util.XmlStringUtil;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\n\u008e\u0001\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010P\u001a\u00020\nH\u0016J\b\u0010Q\u001a\u00020\nH\u0016J\b\u0010R\u001a\u00020\nH\u0016J\b\u0010S\u001a\u00020\nH\u0016J\b\u0010T\u001a\u00020UH\u0002J\b\u0010V\u001a\u00020UH\u0002J\u0010\u0010W\u001a\u00020U2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020U2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010[\u001a\u00020U2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010\\\u001a\u00020U2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010]\u001a\u00020*2\u0006\u0010^\u001a\u00020\u001bH\u0002J\b\u0010_\u001a\u00020*H\u0002J\u0010\u0010`\u001a\u00020\u001a2\u0006\u0010a\u001a\u00020bH\u0002J\u0018\u0010c\u001a\u00020*2\u0006\u0010d\u001a\u00020&2\u0006\u0010^\u001a\u00020\u001bH\u0002J\u0018\u0010e\u001a\u00020B2\u0006\u0010f\u001a\u00020*2\u0006\u0010^\u001a\u00020\u001bH\u0002J\u0018\u0010e\u001a\u00020B2\u0006\u0010g\u001a\u00020*2\u0006\u0010f\u001a\u00020*H\u0002J\b\u0010h\u001a\u00020BH\u0002J\u0018\u0010i\u001a\u00020*2\u0006\u0010A\u001a\u00020B2\u0006\u0010^\u001a\u00020\u001bH\u0002J\u0012\u0010j\u001a\u0004\u0018\u00010*2\u0006\u0010k\u001a\u00020lH\u0002J\u0018\u0010m\u001a\u00020U2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010n\u001a\u00020oH\u0016J\b\u0010p\u001a\u00020UH\u0016J\u001c\u0010q\u001a\u0004\u0018\u0001Hr\"\n\b\u0000\u0010r\u0018\u0001*\u00020sH\u0082\b\u00a2\u0006\u0002\u0010tJ\n\u0010u\u001a\u0004\u0018\u00010vH\u0002J\b\u0010w\u001a\u00020xH\u0002J\u0006\u0010y\u001a\u00020UJ\u0006\u0010z\u001a\u00020UJ\b\u0010{\u001a\u00020UH\u0002J\u0010\u0010|\u001a\u00020U2\u0006\u0010}\u001a\u00020~H\u0014J\b\u0010\u007f\u001a\u00020UH\u0002J\t\u0010\u0080\u0001\u001a\u00020UH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020U2\u0006\u0010^\u001a\u00020\u001bH\u0002J\u0011\u0010\u0081\u0001\u001a\u00020B2\u0006\u0010\u0013\u001a\u00020BH\u0002J$\u0010\u0082\u0001\u001a\u00020U2\u0007\u0010\u0083\u0001\u001a\u00020.2\u0007\u0010\u0084\u0001\u001a\u00020.2\u0007\u0010\u0085\u0001\u001a\u00020.H\u0002J\t\u0010\u0086\u0001\u001a\u00020UH\u0002J\u0010\u0010\u0087\u0001\u001a\u00020U2\u0007\u0010\u0088\u0001\u001a\u00020xJ\u0012\u0010\u0089\u0001\u001a\u00020U2\u0007\u0010X\u001a\u00030\u008a\u0001H\u0002J\u0011\u0010\u008b\u0001\u001a\u00020U2\u0006\u0010n\u001a\u00020oH\u0002J\u0012\u0010\u008c\u0001\u001a\u00020\n2\u0007\u0010\u008d\u0001\u001a\u00020lH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0016\u0010)\u001a\u0004\u0018\u00010*8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R&\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u00101\u001a\u0004\b2\u00103R&\u00105\u001a\u0002042\u0006\u0010-\u001a\u0002048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u00101\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u00103R\u0014\u0010=\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010,R\u0014\u0010?\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u00103R\u0014\u0010A\u001a\u00020B8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0016\u0010E\u001a\u00020B8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010DR\u0014\u0010G\u001a\u00020B8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010DR\u0010\u0010I\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010J\u001a\b\u0018\u00010KR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\u00020M8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010O\u00a8\u0006\u0093\u0001"}, d2={"Lcom/android/tools/idea/emulator/EmulatorView;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ComponentListener;", "Lcom/android/tools/idea/emulator/EmulatorController$ConnectionStateListener;", "Lcom/android/tools/adtui/Zoomable;", "Lcom/intellij/openapi/Disposable;", "emulator", "Lcom/android/tools/idea/emulator/EmulatorController;", "parentDisposable", "deviceFrameVisible", "", "(Lcom/android/tools/idea/emulator/EmulatorController;Lcom/intellij/openapi/Disposable;Z)V", "clipboardFeed", "Lcom/android/ide/common/util/Cancelable;", "clipboardReceiver", "Lcom/android/tools/idea/emulator/EmulatorView$ClipboardReceiver;", "connected", "getConnected", "()Z", "value", "getDeviceFrameVisible", "setDeviceFrameVisible", "(Z)V", "disconnectedStateLabel", "Ljavax/swing/JLabel;", "displayRectangle", "Ljava/awt/Rectangle;", "Lcom/android/emulator/control/Rotation$SkinRotation;", "displayRotation", "getDisplayRotation", "()Lcom/android/emulator/control/Rotation$SkinRotation;", "setDisplayRotation", "(Lcom/android/emulator/control/Rotation$SkinRotation;)V", "displayTransform", "Ljava/awt/geom/AffineTransform;", "getEmulator", "()Lcom/android/tools/idea/emulator/EmulatorController;", "emulatorConfig", "Lcom/android/tools/idea/emulator/EmulatorConfiguration;", "getEmulatorConfig", "()Lcom/android/tools/idea/emulator/EmulatorConfiguration;", "explicitlySetPreferredSize", "Ljava/awt/Dimension;", "getExplicitlySetPreferredSize$intellij_android_emulator", "()Ljava/awt/Dimension;", "<set-?>", "", "frameNumber", "getFrameNumber$annotations", "()V", "getFrameNumber", "()I", "", "frameTimestampMillis", "getFrameTimestampMillis$annotations", "getFrameTimestampMillis", "()J", "lastScreenshot", "Lcom/android/tools/idea/emulator/EmulatorView$Screenshot;", "realHeight", "getRealHeight", "realSize", "getRealSize", "realWidth", "getRealWidth", "scale", "", "getScale", "()D", "screenScale", "getScreenScale", "screenScalingFactor", "getScreenScalingFactor", "screenshotFeed", "screenshotReceiver", "Lcom/android/tools/idea/emulator/EmulatorView$ScreenshotReceiver;", "screenshotShape", "Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "getScreenshotShape", "()Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "canZoomIn", "canZoomOut", "canZoomToActual", "canZoomToFit", "cancelClipboardFeed", "", "cancelScreenshotFeed", "componentHidden", "event", "Ljava/awt/event/ComponentEvent;", "componentMoved", "componentResized", "componentShown", "computeActualSize", "rotation", "computeAvailableSize", "computeDisplayRectangle", "skin", "Lcom/android/tools/idea/emulator/SkinLayout;", "computeRotatedDisplaySize", "config", "computeScaleToFit", "availableSize", "actualSize", "computeScaleToFitInParent", "computeScaledSize", "computeZoomedSize", "zoomType", "Lcom/android/tools/adtui/actions/ZoomType;", "connectionStateChanged", "connectionState", "Lcom/android/tools/idea/emulator/EmulatorController$ConnectionState;", "dispose", "findContainingComponent", "T", "Ljavax/swing/JComponent;", "()Ljavax/swing/JComponent;", "findLoadingPanel", "Lcom/android/tools/idea/emulator/EmulatorLoadingPanel;", "getClipboardText", "", "hideLongRunningOperationIndicator", "hideLongRunningOperationIndicatorInstantly", "notifyEmulatorIsOutOfDate", "paintComponent", "g", "Ljava/awt/Graphics;", "requestClipboardFeed", "requestScreenshotFeed", "roundSlightly", "sendMouseEvent", "x", "y", "button", "setDeviceClipboardAndListenToChanges", "showLongRunningOperationIndicator", "text", "traverseFocusLocally", "Ljava/awt/event/KeyEvent;", "updateConnectionState", "zoom", "type", "ClipboardReceiver", "DisplayShape", "Screenshot", "ScreenshotReceiver", "SkinLayoutCache", "intellij.android.emulator"})
public final class EmulatorView
extends JPanel
implements ComponentListener,
EmulatorController.ConnectionStateListener,
Zoomable,
Disposable {
    private JLabel disconnectedStateLabel;
    private Screenshot lastScreenshot;
    private Rectangle displayRectangle;
    private final AffineTransform displayTransform;
    private int frameNumber;
    private long frameTimestampMillis;
    private Cancelable screenshotFeed;
    private volatile ScreenshotReceiver screenshotReceiver;
    private Cancelable clipboardFeed;
    private volatile ClipboardReceiver clipboardReceiver;
    private boolean deviceFrameVisible;
    private double screenScale;
    @NotNull
    private final EmulatorController emulator;

    private final DisplayShape getScreenshotShape() {
        Object object = this.lastScreenshot;
        if (object == null || (object = ((Screenshot)object).getDisplayShape()) == null) {
            object = new DisplayShape(0, 0, this.emulator.getEmulatorConfig().getInitialOrientation());
        }
        return object;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFrameNumber$annotations() {
    }

    public final int getFrameNumber() {
        return this.frameNumber;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFrameTimestampMillis$annotations() {
    }

    public final long getFrameTimestampMillis() {
        return this.frameTimestampMillis;
    }

    @NotNull
    public final Rotation.SkinRotation getDisplayRotation() {
        return this.getScreenshotShape().getRotation();
    }

    public final void setDisplayRotation(@NotNull Rotation.SkinRotation value2) {
        if (value2 != this.getScreenshotShape().getRotation() && this.deviceFrameVisible) {
            this.requestScreenshotFeed(value2);
        }
    }

    public final boolean getDeviceFrameVisible() {
        return this.deviceFrameVisible;
    }

    public final void setDeviceFrameVisible(boolean value2) {
        if (this.deviceFrameVisible != value2) {
            this.deviceFrameVisible = value2;
            this.requestScreenshotFeed();
        }
    }

    private final EmulatorConfiguration getEmulatorConfig() {
        return this.emulator.getEmulatorConfig();
    }

    private final boolean getConnected() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED;
    }

    private final double getScreenScale() {
        if (this.screenScale == 0.0) {
            Object object = this.getGraphicsConfiguration();
            this.screenScale = object != null && (object = ((GraphicsConfiguration)object).getDefaultTransform()) != null ? ((AffineTransform)object).getScaleX() : 1.0;
        }
        return this.screenScale;
    }

    private final int getRealWidth() {
        return EmulatorUtilsKt.scaled(this.getWidth(), this.getScreenScale());
    }

    private final int getRealHeight() {
        return EmulatorUtilsKt.scaled(this.getHeight(), this.getScreenScale());
    }

    private final Dimension getRealSize() {
        return new Dimension(this.getRealWidth(), this.getRealHeight());
    }

    public double getScreenScalingFactor() {
        return this.getScreenScale();
    }

    public double getScale() {
        return this.computeScaleToFit(this.getRealSize(), this.getScreenshotShape().getRotation());
    }

    public void dispose() {
        this.cancelClipboardFeed();
        this.cancelScreenshotFeed();
        this.removeComponentListener(this);
        this.emulator.removeConnectionStateListener(this);
    }

    public boolean zoom(@NotNull ZoomType type) {
        Dimension scaledSize = this.computeZoomedSize(type);
        if (Intrinsics.areEqual((Object)scaledSize, (Object)this.getPreferredSize())) {
            return false;
        }
        this.setPreferredSize(scaledSize);
        this.revalidate();
        return true;
    }

    public boolean canZoomIn() {
        return this.getConnected() && Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.IN), (Object)this.getExplicitlySetPreferredSize$intellij_android_emulator()) ^ true;
    }

    public boolean canZoomOut() {
        return this.getConnected() && Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.OUT), (Object)this.getExplicitlySetPreferredSize$intellij_android_emulator()) ^ true;
    }

    public boolean canZoomToActual() {
        return this.getConnected() && Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.ACTUAL), (Object)this.getExplicitlySetPreferredSize$intellij_android_emulator()) ^ true;
    }

    public boolean canZoomToFit() {
        return this.getConnected() && this.isPreferredSizeSet();
    }

    @Nullable
    public final Dimension getExplicitlySetPreferredSize$intellij_android_emulator() {
        return this.isPreferredSizeSet() ? this.getPreferredSize() : null;
    }

    private final Dimension computeZoomedSize(ZoomType zoomType) {
        double d;
        switch (EmulatorView$WhenMappings.$EnumSwitchMapping$0[zoomType.ordinal()]) {
            case 1: {
                double d2 = (double)ZoomType.zoomIn((int)MathKt.roundToInt((double)(this.getScale() * (double)100)), (int[])EmulatorViewKt.access$getZOOM_LEVELS$p()) / 100.0;
                double d3 = 2.0;
                boolean bl = false;
                d = Math.min(d2, d3);
                break;
            }
            case 2: {
                double d2 = (double)ZoomType.zoomOut((int)MathKt.roundToInt((double)(this.getScale() * (double)100)), (int[])EmulatorViewKt.access$getZOOM_LEVELS$p()) / 100.0;
                double d3 = this.computeScaleToFitInParent();
                boolean bl = false;
                d = Math.max(d2, d3);
                break;
            }
            case 3: {
                d = 1.0;
                break;
            }
            case 4: {
                return null;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported zoom type " + zoomType);
            }
        }
        double newScale = d;
        Dimension scaledSize = this.computeScaledSize(newScale, this.getScreenshotShape().getRotation());
        Dimension availableSize = this.computeAvailableSize();
        if (scaledSize.width <= availableSize.width && scaledSize.height <= availableSize.height) {
            return null;
        }
        return EmulatorUtilsKt.scaled(scaledSize, 1.0 / this.getScreenScale());
    }

    private final double computeScaleToFitInParent() {
        return this.computeScaleToFit(this.computeAvailableSize(), this.getScreenshotShape().getRotation());
    }

    private final Dimension computeAvailableSize() {
        Insets insets = this.getParent().getInsets();
        return new Dimension(EmulatorUtilsKt.scaled(this.getParent().getWidth() - insets.left - insets.right, this.getScreenScale()), EmulatorUtilsKt.scaled(this.getParent().getHeight() - insets.top - insets.bottom, this.getScreenScale()));
    }

    private final double computeScaleToFit(Dimension availableSize, Rotation.SkinRotation rotation) {
        return this.computeScaleToFit(this.computeActualSize(rotation), availableSize);
    }

    private final double computeScaleToFit(Dimension actualSize, Dimension availableSize) {
        double d;
        double d2 = (double)availableSize.width / (double)actualSize.width;
        double d3 = (double)availableSize.height / (double)actualSize.height;
        boolean bl = false;
        double scale = Math.min(d2, d3);
        if (scale <= 1.0) {
            d = scale;
        } else {
            boolean bl2 = false;
            d = Math.floor(scale);
        }
        return d;
    }

    private final Dimension computeScaledSize(double scale, Rotation.SkinRotation rotation) {
        return EmulatorUtilsKt.scaled(this.computeActualSize(rotation), scale);
    }

    private final Dimension computeActualSize(Rotation.SkinRotation rotation) {
        SkinDefinition skin = this.emulator.getSkinDefinition$intellij_android_emulator();
        return skin != null && this.deviceFrameVisible ? skin.getRotatedFrameSize(rotation, this.emulator.getEmulatorConfig().getDisplaySize()) : this.computeRotatedDisplaySize(this.getEmulatorConfig(), rotation);
    }

    private final Dimension computeRotatedDisplaySize(EmulatorConfiguration config, Rotation.SkinRotation rotation) {
        Rotation.SkinRotation $this$is90Degrees$iv = rotation;
        boolean $i$f$is90Degrees = false;
        return $this$is90Degrees$iv.ordinal() % 2 != 0 ? new Dimension(config.getDisplayHeight(), config.getDisplayWidth()) : new Dimension(config.getDisplayWidth(), config.getDisplayHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void traverseFocusLocally(KeyEvent event) {
        if (!this.getFocusTraversalKeysEnabled()) {
            this.setFocusTraversalKeysEnabled(true);
            try {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().processKeyEvent(this, event);
            }
            finally {
                this.setFocusTraversalKeysEnabled(false);
            }
        }
    }

    private final void sendMouseEvent(int x, int y, int button2) {
        Rectangle rectangle = this.displayRectangle;
        if (rectangle == null) {
            return;
        }
        Rectangle displayRect = rectangle;
        double physicalX = (double)x * this.getScreenScale();
        double physicalY = (double)y * this.getScreenScale();
        if (!displayRect.contains(physicalX, physicalY)) {
            return;
        }
        double normalizedX = (physicalX - (double)displayRect.x) / (double)displayRect.width - 0.5;
        double normalizedY = (physicalY - (double)displayRect.y) / (double)displayRect.height - 0.5;
        int deviceDisplayWidth = this.getEmulatorConfig().getDisplayWidth();
        int deviceDisplayHeight = this.getEmulatorConfig().getDisplayHeight();
        int displayX = 0;
        int displayY = 0;
        switch (EmulatorView$WhenMappings.$EnumSwitchMapping$1[this.getScreenshotShape().getRotation().ordinal()]) {
            case 1: {
                displayX = MathKt.roundToInt((double)((0.5 + normalizedX) * (double)deviceDisplayWidth));
                displayY = MathKt.roundToInt((double)((0.5 + normalizedY) * (double)deviceDisplayHeight));
                break;
            }
            case 2: {
                displayX = MathKt.roundToInt((double)((0.5 - normalizedY) * (double)deviceDisplayWidth));
                displayY = MathKt.roundToInt((double)((0.5 + normalizedX) * (double)deviceDisplayHeight));
                break;
            }
            case 3: {
                displayX = MathKt.roundToInt((double)((0.5 - normalizedX) * (double)deviceDisplayWidth));
                displayY = MathKt.roundToInt((double)((0.5 - normalizedY) * (double)deviceDisplayHeight));
                break;
            }
            case 4: {
                displayX = MathKt.roundToInt((double)((0.5 + normalizedY) * (double)deviceDisplayWidth));
                displayY = MathKt.roundToInt((double)((0.5 - normalizedX) * (double)deviceDisplayHeight));
                break;
            }
            default: {
                return;
            }
        }
        MouseEvent mouseEvent = MouseEvent.newBuilder().setX(RangesKt.coerceIn((int)displayX, (int)0, (int)deviceDisplayWidth)).setY(RangesKt.coerceIn((int)displayY, (int)0, (int)deviceDisplayHeight)).setButtons(button2).build();
        EmulatorController.sendMouse$default(this.emulator, mouseEvent, null, 2, null);
    }

    @Override
    public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
        EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this, connectionState){
            final /* synthetic */ EmulatorView this$0;
            final /* synthetic */ EmulatorController.ConnectionState $connectionState;

            public final void invoke() {
                EmulatorView.access$updateConnectionState(this.this$0, this.$connectionState);
            }
            {
                this.this$0 = emulatorView;
                this.$connectionState = connectionState;
                super(0);
            }
        }));
    }

    private final void updateConnectionState(EmulatorController.ConnectionState connectionState) {
        if (connectionState == EmulatorController.ConnectionState.CONNECTED) {
            this.remove(this.disconnectedStateLabel);
            if (this.isVisible()) {
                if (this.screenshotFeed == null) {
                    this.requestScreenshotFeed();
                }
                if (this.isFocusOwner()) {
                    this.setDeviceClipboardAndListenToChanges();
                }
            }
        } else if (connectionState == EmulatorController.ConnectionState.DISCONNECTED) {
            this.lastScreenshot = null;
            this.hideLongRunningOperationIndicator();
            this.disconnectedStateLabel.setText("Disconnected from the Emulator");
            this.add(this.disconnectedStateLabel);
        }
        this.revalidate();
        this.repaint();
    }

    private final void setDeviceClipboardAndListenToChanges() {
        String text2 = this.getClipboardText();
        CharSequence charSequence = text2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.requestClipboardFeed();
        } else {
            this.emulator.setClipboard(ClipData.newBuilder().setText(text2).build(), (StreamObserver<Empty>)new EmptyStreamObserver<Empty>(this){
                final /* synthetic */ EmulatorView this$0;

                public void onCompleted() {
                    EmulatorView.access$requestClipboardFeed(this.this$0);
                }

                public void onError(@NotNull Throwable t) {
                    if (t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus().getCode() == Status.Code.UNIMPLEMENTED) {
                        EmulatorView.access$notifyEmulatorIsOutOfDate(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
    }

    private final String getClipboardText() {
        String string;
        ClipboardSynchronizer synchronizer = ClipboardSynchronizer.getInstance();
        if (synchronizer.areDataFlavorsAvailable(new DataFlavor[]{DataFlavor.stringFlavor})) {
            string = (String)synchronizer.getData(DataFlavor.stringFlavor);
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    private final void notifyEmulatorIsOutOfDate() {
        if (EmulatorViewKt.access$getEmulatorOutOfDateNotificationShown$p()) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
        if (project == null) {
            return;
        }
        Project project2 = project;
        String title = "Emulator is out of date";
        String message2 = "Please update the Android Emulator";
        Notification notification = EmulatorViewKt.access$getNOTIFICATION_GROUP$p().createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message2), NotificationType.WARNING, null);
        notification.setCollapseActionsDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.addAction((AnAction)new NotificationAction("Check for updates"){

            public void actionPerformed(@NotNull AnActionEvent event, @NotNull Notification notification) {
                notification.expire();
                AnAction action2 = ActionManager.getInstance().getAction("CheckForUpdate");
                ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
            }
        });
        notification.notify(project2);
        EmulatorViewKt.access$setEmulatorOutOfDateNotificationShown$p(true);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Rectangle displayRect;
        super.paintComponent(g);
        Screenshot screenshot = this.lastScreenshot;
        if (screenshot == null) {
            return;
        }
        Screenshot screenshot2 = screenshot;
        SkinLayout skin = screenshot2.getSkinLayout();
        boolean bl = this.getScreenshotShape().getWidth() != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.getScreenshotShape().getHeight() != 0;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.displayRectangle = displayRect = this.computeDisplayRectangle(skin);
        Graphics graphics = g;
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D cfr_ignored_0 = (Graphics2D)graphics;
        double physicalToVirtualScale = 1.0 / this.getScreenScale();
        ((Graphics2D)g).scale(physicalToVirtualScale, physicalToVirtualScale);
        if (displayRect.width == this.getScreenshotShape().getWidth() && displayRect.height == this.getScreenshotShape().getHeight()) {
            ((Graphics2D)g).drawImage(screenshot2.getImage(), null, displayRect.x, displayRect.y);
        } else {
            this.displayTransform.setToTranslation(displayRect.x, displayRect.y);
            this.displayTransform.scale((double)displayRect.width / (double)this.getScreenshotShape().getWidth(), (double)displayRect.height / (double)this.getScreenshotShape().getHeight());
            ((Graphics2D)g).drawImage(screenshot2.getImage(), this.displayTransform, null);
        }
        if (this.deviceFrameVisible) {
            skin.drawFrameAndMask((Graphics2D)g, displayRect);
        }
    }

    private final Rectangle computeDisplayRectangle(SkinLayout skin) {
        Rectangle rectangle;
        if (this.deviceFrameVisible) {
            Rectangle frameRectangle = skin.getFrameRectangle();
            double d = (double)this.getRealWidth() / (double)frameRectangle.width;
            double d2 = (double)this.getRealHeight() / (double)frameRectangle.height;
            boolean bl = false;
            double scale = this.roundSlightly(Math.min(d, d2));
            int fw = EmulatorUtilsKt.scaled(frameRectangle.width, scale);
            int fh = EmulatorUtilsKt.scaled(frameRectangle.height, scale);
            int w = EmulatorUtilsKt.scaled(this.getScreenshotShape().getWidth(), scale);
            int h = EmulatorUtilsKt.scaled(this.getScreenshotShape().getHeight(), scale);
            rectangle = new Rectangle((this.getRealWidth() - fw) / 2 - EmulatorUtilsKt.scaled(frameRectangle.x, scale), (this.getRealHeight() - fh) / 2 - EmulatorUtilsKt.scaled(frameRectangle.y, scale), w, h);
        } else {
            double d = (double)this.getRealWidth() / (double)this.getScreenshotShape().getWidth();
            double d3 = (double)this.getRealHeight() / (double)this.getScreenshotShape().getHeight();
            boolean bl = false;
            double scale = this.roundSlightly(Math.min(d, d3));
            int w = EmulatorUtilsKt.scaled(this.getScreenshotShape().getWidth(), scale);
            int h = EmulatorUtilsKt.scaled(this.getScreenshotShape().getHeight(), scale);
            rectangle = new Rectangle((this.getRealWidth() - w) / 2, (this.getRealHeight() - h) / 2, w, h);
        }
        return rectangle;
    }

    private final double roundSlightly(double value2) {
        double d = value2 * (double)128;
        boolean bl = false;
        return Math.rint(d) / (double)128;
    }

    private final void requestScreenshotFeed() {
        this.requestScreenshotFeed(this.getScreenshotShape().getRotation());
    }

    private final void requestScreenshotFeed(Rotation.SkinRotation rotation) {
        this.cancelScreenshotFeed();
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.getConnected()) {
            ScreenshotReceiver receiver;
            Dimension rotatedDisplaySize = this.computeRotatedDisplaySize(this.getEmulatorConfig(), rotation);
            Dimension actualSize = this.computeActualSize(rotation);
            double scaleX = RangesKt.coerceAtMost((double)((double)this.getRealSize().width / (double)actualSize.width), (double)1.0);
            double scaleY = RangesKt.coerceAtMost((double)((double)this.getRealSize().height / (double)actualSize.height), (double)1.0);
            int w = EmulatorUtilsKt.scaledDown(rotatedDisplaySize.width, scaleX);
            int h = EmulatorUtilsKt.scaledDown(rotatedDisplaySize.height, scaleY);
            ImageFormat imageFormat = ImageFormat.newBuilder().setFormat(ImageFormat.ImgFormat.RGB888).setWidth(w).setHeight(h).build();
            this.screenshotReceiver = receiver = new ScreenshotReceiver(rotation);
            this.screenshotFeed = this.emulator.streamScreenshot(imageFormat, (StreamObserver<Image>)((StreamObserver)receiver));
        }
    }

    private final void cancelScreenshotFeed() {
        ScreenshotReceiver screenshotReceiver = this.screenshotReceiver;
        if (screenshotReceiver != null) {
            ScreenshotReceiver screenshotReceiver2 = screenshotReceiver;
            boolean bl = false;
            boolean bl2 = false;
            ScreenshotReceiver it = screenshotReceiver2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)it);
        }
        this.screenshotReceiver = null;
        Cancelable cancelable = this.screenshotFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.screenshotFeed = null;
    }

    private final void requestClipboardFeed() {
        this.cancelClipboardFeed();
        if (this.getConnected()) {
            ClipboardReceiver receiver;
            this.clipboardReceiver = receiver = new ClipboardReceiver();
            this.clipboardFeed = this.emulator.streamClipboard((StreamObserver<ClipData>)((StreamObserver)receiver));
        }
    }

    private final void cancelClipboardFeed() {
        this.clipboardReceiver = null;
        Cancelable cancelable = this.clipboardFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.clipboardFeed = null;
    }

    @Override
    public void componentResized(@NotNull ComponentEvent event) {
        this.requestScreenshotFeed();
    }

    @Override
    public void componentShown(@NotNull ComponentEvent event) {
        this.requestScreenshotFeed();
    }

    @Override
    public void componentHidden(@NotNull ComponentEvent event) {
        this.cancelClipboardFeed();
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent event) {
    }

    public final void showLongRunningOperationIndicator(@NotNull String text2) {
        block0: {
            EmulatorLoadingPanel emulatorLoadingPanel = this.findLoadingPanel();
            if (emulatorLoadingPanel == null) break block0;
            EmulatorLoadingPanel emulatorLoadingPanel2 = emulatorLoadingPanel;
            boolean bl = false;
            boolean bl2 = false;
            EmulatorLoadingPanel $this$apply = emulatorLoadingPanel2;
            boolean bl3 = false;
            $this$apply.setLoadingText(text2);
            $this$apply.startLoading();
        }
    }

    public final void hideLongRunningOperationIndicator() {
        block0: {
            EmulatorLoadingPanel emulatorLoadingPanel = this.findLoadingPanel();
            if (emulatorLoadingPanel == null) break block0;
            emulatorLoadingPanel.stopLoading();
        }
    }

    public final void hideLongRunningOperationIndicatorInstantly() {
        block0: {
            EmulatorLoadingPanel emulatorLoadingPanel = this.findLoadingPanel();
            if (emulatorLoadingPanel == null) break block0;
            emulatorLoadingPanel.stopLoadingInstantly();
        }
    }

    private final EmulatorLoadingPanel findLoadingPanel() {
        JComponent jComponent;
        block1: {
            EmulatorView this_$iv = this;
            boolean $i$f$findContainingComponent = false;
            for (Container component$iv = this_$iv.getParent(); component$iv != null; component$iv = component$iv.getParent()) {
                if (!(component$iv instanceof EmulatorLoadingPanel)) continue;
                jComponent = (JComponent)component$iv;
                break block1;
            }
            jComponent = null;
        }
        return (EmulatorLoadingPanel)((Object)jComponent);
    }

    private final /* synthetic */ <T extends JComponent> T findContainingComponent() {
        int $i$f$findContainingComponent = 0;
        for (Container component = this.getParent(); component != null; component = component.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(component instanceof JComponent)) continue;
            return (T)((JComponent)component);
        }
        return null;
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    public EmulatorView(@NotNull EmulatorController emulator, @NotNull Disposable parentDisposable, boolean deviceFrameVisible) {
        super(new BorderLayout());
        this.emulator = emulator;
        this.displayTransform = new AffineTransform();
        this.deviceFrameVisible = deviceFrameVisible;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.disconnectedStateLabel = new JLabel();
        this.disconnectedStateLabel.setHorizontalAlignment(0);
        this.disconnectedStateLabel.setFont(this.disconnectedStateLabel.getFont().deriveFont((float)this.disconnectedStateLabel.getFont().getSize() * 1.2f));
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.emulator.addConnectionStateListener(this);
        this.addComponentListener(this);
        MouseAdapter mouseListener2 = new MouseAdapter(this){
            final /* synthetic */ EmulatorView this$0;

            public void mousePressed(@NotNull java.awt.event.MouseEvent event) {
                EmulatorView.access$sendMouseEvent(this.this$0, event.getX(), event.getY(), 1);
            }

            public void mouseReleased(@NotNull java.awt.event.MouseEvent event) {
                EmulatorView.access$sendMouseEvent(this.this$0, event.getX(), event.getY(), 0);
            }

            public void mouseClicked(@NotNull java.awt.event.MouseEvent event) {
                this.this$0.requestFocusInWindow();
            }

            public void mouseDragged(@NotNull java.awt.event.MouseEvent event) {
                EmulatorView.access$sendMouseEvent(this.this$0, event.getX(), event.getY(), 1);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                char c = event.getKeyChar();
                if (c == '\uffff' || Character.isISOControl(c)) {
                    return;
                }
                KeyboardEvent keyboardEvent = KeyboardEvent.newBuilder().setText(String.valueOf(c)).build();
                EmulatorController.sendKey$default(this.getEmulator(), keyboardEvent, null, 2, null);
            }

            @Override
            public void keyPressed(@NotNull KeyEvent event) {
                String string;
                if (event.getKeyCode() == 9 && event.getModifiersEx() == 64) {
                    Object object = event.getSource();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.awt.Component");
                    }
                    KeyEvent tabEvent = new KeyEvent((Component)object, event.getID(), event.getWhen(), 0, event.getKeyCode(), event.getKeyChar(), event.getKeyLocation());
                    this.traverseFocusLocally(tabEvent);
                    return;
                }
                if (event.getModifiersEx() != 0) {
                    return;
                }
                switch (event.getKeyCode()) {
                    case 8: {
                        string = "Backspace";
                        break;
                    }
                    case 127: {
                        if (SystemInfo.isMac) {
                            string = "Backspace";
                            break;
                        }
                        string = "Delete";
                        break;
                    }
                    case 10: {
                        string = "Enter";
                        break;
                    }
                    case 27: {
                        string = "Escape";
                        break;
                    }
                    case 9: {
                        string = "Tab";
                        break;
                    }
                    case 37: 
                    case 226: {
                        string = "ArrowLeft";
                        break;
                    }
                    case 39: 
                    case 227: {
                        string = "ArrowRight";
                        break;
                    }
                    case 38: 
                    case 224: {
                        string = "ArrowUp";
                        break;
                    }
                    case 40: 
                    case 225: {
                        string = "ArrowDown";
                        break;
                    }
                    case 36: {
                        string = "Home";
                        break;
                    }
                    case 35: {
                        string = "End";
                        break;
                    }
                    case 33: {
                        string = "PageUp";
                        break;
                    }
                    case 34: {
                        string = "PageDown";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                String keyName = string;
                EmulatorController.sendKey$default(this.getEmulator(), EmulatorUtilsKt.createHardwareKeyEvent$default(keyName, null, 2, null), null, 2, null);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (this.getConnected()) {
                    this.setDeviceClipboardAndListenToChanges();
                }
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                this.cancelClipboardFeed();
            }
        });
        this.updateConnectionState(this.emulator.getConnectionState());
    }

    public static final /* synthetic */ void access$setClipboardReceiver$p(EmulatorView $this, ClipboardReceiver clipboardReceiver) {
        $this.clipboardReceiver = clipboardReceiver;
    }

    public static final /* synthetic */ void access$setScreenshotReceiver$p(EmulatorView $this, ScreenshotReceiver screenshotReceiver) {
        $this.screenshotReceiver = screenshotReceiver;
    }

    public static final /* synthetic */ void access$requestScreenshotFeed(EmulatorView $this, Rotation.SkinRotation rotation) {
        $this.requestScreenshotFeed(rotation);
    }

    public static final /* synthetic */ int access$getFrameNumber$p(EmulatorView $this) {
        return $this.frameNumber;
    }

    public static final /* synthetic */ long access$getFrameTimestampMillis$p(EmulatorView $this) {
        return $this.frameTimestampMillis;
    }

    public static final /* synthetic */ void access$updateConnectionState(EmulatorView $this, EmulatorController.ConnectionState connectionState) {
        $this.updateConnectionState(connectionState);
    }

    public static final /* synthetic */ void access$requestClipboardFeed(EmulatorView $this) {
        $this.requestClipboardFeed();
    }

    public static final /* synthetic */ void access$notifyEmulatorIsOutOfDate(EmulatorView $this) {
        $this.notifyEmulatorIsOutOfDate();
    }

    public static final /* synthetic */ void access$sendMouseEvent(EmulatorView $this, int x, int y, int button2) {
        $this.sendMouseEvent(x, y, button2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/emulator/EmulatorView$ClipboardReceiver;", "Lcom/android/tools/idea/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/ClipData;", "(Lcom/android/tools/idea/emulator/EmulatorView;)V", "responseCount", "", "getResponseCount", "()I", "setResponseCount", "(I)V", "onNext", "", "response", "intellij.android.emulator"})
    private final class ClipboardReceiver
    extends EmptyStreamObserver<ClipData> {
        private int responseCount;

        public final int getResponseCount() {
            return this.responseCount;
        }

        public final void setResponseCount(int n) {
            this.responseCount = n;
        }

        @Override
        public void onNext(@NotNull ClipData response) {
            if (Intrinsics.areEqual((Object)EmulatorView.this.clipboardReceiver, (Object)this) ^ true) {
                return;
            }
            if (this.responseCount != 0) {
                CharSequence charSequence = response.getText();
                boolean bl = false;
                if (charSequence.length() > 0) {
                    EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(response){
                        final /* synthetic */ ClipData $response;

                        public final void invoke() {
                            StringSelection content2 = new StringSelection(this.$response.getText());
                            ClipboardSynchronizer.getInstance().setContent((Transferable)content2, (ClipboardOwner)content2);
                        }
                        {
                            this.$response = clipData;
                            super(0);
                        }
                    }));
                }
            }
            int n = this.responseCount;
            this.responseCount = n + 1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0015H\u0003J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/emulator/EmulatorView$ScreenshotReceiver;", "Lcom/android/tools/idea/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Image;", "Lcom/intellij/openapi/Disposable;", "rotation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "(Lcom/android/tools/idea/emulator/EmulatorView;Lcom/android/emulator/control/Rotation$SkinRotation;)V", "alarm", "Lcom/intellij/util/Alarm;", "recycledImage", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/SofterReference;", "Ljava/awt/image/BufferedImage;", "getRotation", "()Lcom/android/emulator/control/Rotation$SkinRotation;", "screenshotForDisplay", "Lcom/android/tools/idea/emulator/EmulatorView$Screenshot;", "screenshotForProcessing", "skinLayoutCache", "Lcom/android/tools/idea/emulator/EmulatorView$SkinLayoutCache;", "computeSkinLayoutOnPooledThread", "", "screenshotWithoutSkin", "dispose", "onNext", "response", "unpackPixels", "imageBytes", "Lcom/android/tools/idea/protobuf/ByteString;", "pixels", "", "updateDisplayImage", "updateDisplayImageOnUiThread", "screenshot", "intellij.android.emulator"})
    private final class ScreenshotReceiver
    extends EmptyStreamObserver<Image>
    implements Disposable {
        private final AtomicReference<Screenshot> screenshotForProcessing;
        private final AtomicReference<Screenshot> screenshotForDisplay;
        private final SkinLayoutCache skinLayoutCache;
        private final AtomicReference<SofterReference<BufferedImage>> recycledImage;
        private final Alarm alarm;
        @NotNull
        private final Rotation.SkinRotation rotation;

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onNext(@NotNull Image response) {
            BufferedImage bufferedImage;
            int[] pixels;
            BufferedImage recycledImage;
            ImageFormat imageFormat = response.getFormat();
            Rotation.SkinRotation imageRotation = imageFormat.getRotation().getRotation();
            if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_SCREENSHOTS.get()).booleanValue()) {
                EmulatorViewKt.access$getLOG$p().info("Screenshot " + response.getSeq() + ' ' + imageFormat.getWidth() + 'x' + imageFormat.getHeight() + ' ' + imageRotation);
            }
            if (Intrinsics.areEqual((Object)EmulatorView.this.screenshotReceiver, (Object)this) ^ true) {
                return;
            }
            if (imageFormat.getWidth() == 0) return;
            if (imageFormat.getHeight() == 0) {
                return;
            }
            if (imageRotation != this.rotation) {
                EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this, imageRotation){
                    final /* synthetic */ ScreenshotReceiver this$0;
                    final /* synthetic */ Rotation.SkinRotation $imageRotation;

                    public final void invoke() {
                        EmulatorView.access$requestScreenshotFeed(this.this$0.EmulatorView.this, this.$imageRotation);
                    }
                    {
                        this.this$0 = screenshotReceiver;
                        this.$imageRotation = skinRotation;
                        super(0);
                    }
                }));
                return;
            }
            this.alarm.cancelAllRequests();
            SofterReference softerReference = this.recycledImage.getAndSet(null);
            BufferedImage bufferedImage2 = recycledImage = softerReference != null ? (BufferedImage)softerReference.get() : null;
            if (bufferedImage2 != null && bufferedImage2.getWidth() == imageFormat.getWidth() && recycledImage.getHeight() == imageFormat.getHeight()) {
                DataBuffer dataBuffer = recycledImage.getRaster().getDataBuffer();
                if (dataBuffer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.image.DataBufferInt");
                }
                pixels = ((DataBufferInt)dataBuffer).getData();
                this.unpackPixels(response.getImage(), pixels);
                bufferedImage = recycledImage;
            } else {
                pixels = new int[imageFormat.getWidth() * imageFormat.getHeight()];
                this.unpackPixels(response.getImage(), pixels);
                DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
                SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, imageFormat.getWidth(), imageFormat.getHeight(), new int[]{0xFF0000, 65280, 255, -16777216});
                WritableRaster raster = Raster.createWritableRaster(sampleModel, buffer, EmulatorViewKt.access$getZERO_POINT$p());
                bufferedImage = new BufferedImage(EmulatorViewKt.access$getCOLOR_MODEL$p(), raster, false, null);
            }
            BufferedImage image = bufferedImage;
            DisplayShape displayShape = new DisplayShape(imageFormat);
            Screenshot screenshot = new Screenshot(displayShape, image);
            SkinLayout skinLayout = this.skinLayoutCache.getCached(displayShape);
            if (skinLayout == null) {
                this.computeSkinLayoutOnPooledThread(screenshot);
                return;
            }
            screenshot.setSkinLayout(skinLayout);
            this.updateDisplayImageOnUiThread(screenshot);
        }

        private final void computeSkinLayoutOnPooledThread(Screenshot screenshotWithoutSkin) {
            this.screenshotForProcessing.set(screenshotWithoutSkin);
            FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ScreenshotReceiver this$0;

                public final void invoke() {
                    if (Intrinsics.areEqual((Object)EmulatorView.access$getScreenshotReceiver$p(this.this$0.EmulatorView.this), (Object)this.this$0)) {
                        Screenshot screenshot = ScreenshotReceiver.access$getScreenshotForProcessing$p(this.this$0).getAndSet(null);
                        if (screenshot == null) {
                            return;
                        }
                        Screenshot screenshot2 = screenshot;
                        screenshot2.setSkinLayout(ScreenshotReceiver.access$getSkinLayoutCache$p(this.this$0).get(screenshot2.getDisplayShape()));
                        ScreenshotReceiver.access$updateDisplayImageOnUiThread(this.this$0, screenshot2);
                    }
                }
                {
                    this.this$0 = screenshotReceiver;
                    super(0);
                }
            }));
        }

        private final void updateDisplayImageOnUiThread(Screenshot screenshot) {
            this.screenshotForDisplay.set(screenshot);
            EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ScreenshotReceiver this$0;

                public final void invoke() {
                    if (Intrinsics.areEqual((Object)EmulatorView.access$getScreenshotReceiver$p(this.this$0.EmulatorView.this), (Object)this.this$0)) {
                        ScreenshotReceiver.access$updateDisplayImage(this.this$0);
                    }
                }
                {
                    this.this$0 = screenshotReceiver;
                    super(0);
                }
            }));
        }

        @UiThread
        private final void updateDisplayImage() {
            EmulatorView.this.hideLongRunningOperationIndicatorInstantly();
            Screenshot screenshot = this.screenshotForDisplay.getAndSet(null);
            if (screenshot == null) {
                return;
            }
            Screenshot screenshot2 = screenshot;
            Object object = EmulatorView.this.lastScreenshot;
            if (object != null && (object = ((Screenshot)object).getImage()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                if (((BufferedImage)it).getWidth() == screenshot2.getDisplayShape().getWidth() && ((BufferedImage)it).getHeight() == screenshot2.getDisplayShape().getHeight()) {
                    this.recycledImage.set((SofterReference<BufferedImage>)new SofterReference(it));
                    this.alarm.cancelAllRequests();
                    this.alarm.addRequest(new Runnable(this, screenshot2){
                        final /* synthetic */ ScreenshotReceiver this$0;
                        final /* synthetic */ Screenshot $screenshot$inlined;
                        {
                            this.this$0 = screenshotReceiver;
                            this.$screenshot$inlined = screenshot;
                        }

                        public final void run() {
                            ScreenshotReceiver.access$getRecycledImage$p(this.this$0).set(null);
                        }
                    }, 2000, ModalityState.any());
                }
            }
            EmulatorView.this.lastScreenshot = screenshot2;
            EmulatorView emulatorView = EmulatorView.this;
            int n = emulatorView.getFrameNumber();
            emulatorView.frameNumber = n + 1;
            EmulatorView.this.frameTimestampMillis = System.currentTimeMillis();
            EmulatorView.this.repaint();
        }

        /*
         * WARNING - void declaration
         */
        public final void unpackPixels(@NotNull ByteString imageBytes, @NotNull int[] pixels) {
            int alpha = -16777216;
            int j = 0;
            int n = 0;
            int n2 = pixels.length;
            while (n < n2) {
                void i2;
                int red = imageBytes.byteAt(j) & 0xFF;
                int green = imageBytes.byteAt(j + 1) & 0xFF;
                int blue = imageBytes.byteAt(j + 2) & 0xFF;
                j += 3;
                pixels[i2] = alpha | red << 16 | green << 8 | blue;
                ++i2;
            }
        }

        public void dispose() {
        }

        @NotNull
        public final Rotation.SkinRotation getRotation() {
            return this.rotation;
        }

        public ScreenshotReceiver(Rotation.SkinRotation rotation) {
            this.rotation = rotation;
            this.screenshotForProcessing = new AtomicReference();
            this.screenshotForDisplay = new AtomicReference();
            this.skinLayoutCache = new SkinLayoutCache(EmulatorView.this.getEmulator());
            this.recycledImage = new AtomicReference();
            this.alarm = new Alarm((Disposable)this);
        }

        public static final /* synthetic */ AtomicReference access$getScreenshotForProcessing$p(ScreenshotReceiver $this) {
            return $this.screenshotForProcessing;
        }

        public static final /* synthetic */ SkinLayoutCache access$getSkinLayoutCache$p(ScreenshotReceiver $this) {
            return $this.skinLayoutCache;
        }

        public static final /* synthetic */ void access$updateDisplayImageOnUiThread(ScreenshotReceiver $this, Screenshot screenshot) {
            $this.updateDisplayImageOnUiThread(screenshot);
        }

        public static final /* synthetic */ void access$updateDisplayImage(ScreenshotReceiver $this) {
            $this.updateDisplayImage();
        }

        public static final /* synthetic */ AtomicReference access$getRecycledImage$p(ScreenshotReceiver $this) {
            return $this.recycledImage;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/emulator/EmulatorView$Screenshot;", "", "displayShape", "Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "image", "Ljava/awt/image/BufferedImage;", "(Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;Ljava/awt/image/BufferedImage;)V", "getDisplayShape", "()Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "getImage", "()Ljava/awt/image/BufferedImage;", "skinLayout", "Lcom/android/tools/idea/emulator/SkinLayout;", "getSkinLayout", "()Lcom/android/tools/idea/emulator/SkinLayout;", "setSkinLayout", "(Lcom/android/tools/idea/emulator/SkinLayout;)V", "intellij.android.emulator"})
    private static final class Screenshot {
        @NotNull
        public SkinLayout skinLayout;
        @NotNull
        private final DisplayShape displayShape;
        @NotNull
        private final BufferedImage image;

        @NotNull
        public final SkinLayout getSkinLayout() {
            SkinLayout skinLayout = this.skinLayout;
            if (skinLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"skinLayout");
            }
            return skinLayout;
        }

        public final void setSkinLayout(@NotNull SkinLayout skinLayout) {
            this.skinLayout = skinLayout;
        }

        @NotNull
        public final DisplayShape getDisplayShape() {
            return this.displayShape;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        public Screenshot(@NotNull DisplayShape displayShape, @NotNull BufferedImage image) {
            this.displayShape = displayShape;
            this.image = image;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/emulator/EmulatorView$SkinLayoutCache;", "", "emulator", "Lcom/android/tools/idea/emulator/EmulatorController;", "(Lcom/android/tools/idea/emulator/EmulatorController;)V", "displayShape", "Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "getDisplayShape", "()Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "setDisplayShape", "(Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;)V", "getEmulator", "()Lcom/android/tools/idea/emulator/EmulatorController;", "skinLayout", "Lcom/android/tools/idea/emulator/SkinLayout;", "getSkinLayout", "()Lcom/android/tools/idea/emulator/SkinLayout;", "setSkinLayout", "(Lcom/android/tools/idea/emulator/SkinLayout;)V", "get", "getCached", "intellij.android.emulator"})
    private static final class SkinLayoutCache {
        @Nullable
        private DisplayShape displayShape;
        @Nullable
        private SkinLayout skinLayout;
        @NotNull
        private final EmulatorController emulator;

        @Nullable
        public final DisplayShape getDisplayShape() {
            return this.displayShape;
        }

        public final void setDisplayShape(@Nullable DisplayShape displayShape) {
            this.displayShape = displayShape;
        }

        @Nullable
        public final SkinLayout getSkinLayout() {
            return this.skinLayout;
        }

        public final void setSkinLayout(@Nullable SkinLayout skinLayout) {
            this.skinLayout = skinLayout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final SkinLayout getCached(@NotNull DisplayShape displayShape) {
            SkinLayoutCache skinLayoutCache = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (skinLayoutCache) {
                boolean bl3 = false;
                SkinLayout skinLayout = Intrinsics.areEqual((Object)displayShape, (Object)this.displayShape) ? this.skinLayout : null;
                return skinLayout;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Slow
        @NotNull
        public final SkinLayout get(@NotNull DisplayShape displayShape) {
            SkinLayoutCache skinLayoutCache = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (skinLayoutCache) {
                boolean bl3 = false;
                Object layout2 = this.skinLayout;
                if (Intrinsics.areEqual((Object)displayShape, (Object)this.displayShape) ^ true || layout2 == null) {
                    Object object = this.emulator.getSkinDefinition$intellij_android_emulator();
                    if (object == null || (object = ((SkinDefinition)object).createScaledLayout(displayShape.getWidth(), displayShape.getHeight(), displayShape.getRotation())) == null) {
                        object = new SkinLayout(displayShape.getWidth(), displayShape.getHeight());
                    }
                    layout2 = object;
                    this.displayShape = displayShape;
                    this.skinLayout = layout2;
                }
                SkinLayout skinLayout = layout2;
                return skinLayout;
            }
        }

        @NotNull
        public final EmulatorController getEmulator() {
            return this.emulator;
        }

        public SkinLayoutCache(@NotNull EmulatorController emulator) {
            this.emulator = emulator;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\tH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/emulator/EmulatorView$DisplayShape;", "", "imageFormat", "Lcom/android/emulator/control/ImageFormat;", "(Lcom/android/emulator/control/ImageFormat;)V", "width", "", "height", "rotation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "(IILcom/android/emulator/control/Rotation$SkinRotation;)V", "getHeight", "()I", "getRotation", "()Lcom/android/emulator/control/Rotation$SkinRotation;", "getWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.emulator"})
    private static final class DisplayShape {
        private final int width;
        private final int height;
        @NotNull
        private final Rotation.SkinRotation rotation;

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final Rotation.SkinRotation getRotation() {
            return this.rotation;
        }

        public DisplayShape(int width, int height, @NotNull Rotation.SkinRotation rotation) {
            this.width = width;
            this.height = height;
            this.rotation = rotation;
        }

        public DisplayShape(@NotNull ImageFormat imageFormat) {
            this(imageFormat.getWidth(), imageFormat.getHeight(), imageFormat.getRotation().getRotation());
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final Rotation.SkinRotation component3() {
            return this.rotation;
        }

        @NotNull
        public final DisplayShape copy(int width, int height, @NotNull Rotation.SkinRotation rotation) {
            return new DisplayShape(width, height, rotation);
        }

        public static /* synthetic */ DisplayShape copy$default(DisplayShape displayShape, int n, int n2, Rotation.SkinRotation skinRotation, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = displayShape.width;
            }
            if ((n3 & 2) != 0) {
                n2 = displayShape.height;
            }
            if ((n3 & 4) != 0) {
                skinRotation = displayShape.rotation;
            }
            return displayShape.copy(n, n2, skinRotation);
        }

        @NotNull
        public String toString() {
            return "DisplayShape(width=" + this.width + ", height=" + this.height + ", rotation=" + this.rotation + ")";
        }

        public int hashCode() {
            Rotation.SkinRotation skinRotation = this.rotation;
            return (Integer.hashCode(this.width) * 31 + Integer.hashCode(this.height)) * 31 + (skinRotation != null ? skinRotation.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DisplayShape)) break block3;
                    DisplayShape displayShape = (DisplayShape)object;
                    if (this.width != displayShape.width || this.height != displayShape.height || !Intrinsics.areEqual((Object)this.rotation, (Object)displayShape.rotation)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

