/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeResolver {
    private static final StyleResourceValue[] NO_BASE_THEMES = new StyleResourceValue[0];
    private final Map<ResourceReference, ConfiguredThemeEditorStyle> myThemesByStyle = new HashMap<ResourceReference, ConfiguredThemeEditorStyle>();
    private final ImmutableList<ConfiguredThemeEditorStyle> myFrameworkThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myLocalThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myExternalLibraryThemes;
    private final Configuration myConfiguration;
    private final ResourceResolver myResolver;
    private List<ResourceReference> myRecommendedThemes;

    public ThemeResolver(@NotNull Configuration configuration) {
        this.myConfiguration = configuration;
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(configuration.getModule());
        if (repositoryManager == null) {
            throw new IllegalArgumentException("\"" + configuration.getModule().getName() + "\" is not an Android module");
        }
        this.myResolver = configuration.getResourceResolver();
        if (this.myResolver == null) {
            throw new IllegalArgumentException("Acquired ResourceResolver is null, not an Android module?");
        }
        this.myFrameworkThemes = this.fillThemeResolverFromStyles(this.resolveFrameworkThemes());
        ImmutableList.Builder localThemes = ImmutableList.builder();
        for (Pair<StyleResourceValue, Module> pair : this.resolveLocallyDefinedModuleThemes()) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue((StyleResourceValue)pair.getFirst());
            if (theme == null) continue;
            localThemes.add((Object)theme);
        }
        this.myLocalThemes = localThemes.build();
        this.myExternalLibraryThemes = this.fillThemeResolverFromStyles(this.resolveNonFrameworkThemes());
    }

    @Nullable
    private ConfiguredThemeEditorStyle constructThemeFromResourceValue(@NotNull StyleResourceValue value2) {
        ResourceReference styleReference = value2.asReference();
        if (this.myThemesByStyle.containsKey(styleReference)) {
            return null;
        }
        ConfiguredThemeEditorStyle theme = ResolutionUtils.getThemeEditorStyle(this.myConfiguration, styleReference);
        if (theme != null) {
            this.myThemesByStyle.put(styleReference, theme);
        }
        return theme;
    }

    private ImmutableList<ConfiguredThemeEditorStyle> fillThemeResolverFromStyles(@NotNull List<StyleResourceValue> source) {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (StyleResourceValue value2 : source) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue(value2);
            if (theme == null) continue;
            builder2.add((Object)theme);
        }
        return builder2.build();
    }

    @NotNull
    private List<StyleResourceValue> resolveFrameworkThemes() {
        ConfigurationManager configurationManager = this.myConfiguration.getConfigurationManager();
        ResourceResolverCache resolverCache = configurationManager.getResolverCache();
        IAndroidTarget target = this.myConfiguration.getTarget();
        if (target == null) {
            return Collections.emptyList();
        }
        Map<ResourceType, ResourceValueMap> resources = resolverCache.getConfiguredFrameworkResources(target, this.myConfiguration.getFullConfig());
        ResourceValueMap styles2 = resources.get(ResourceType.STYLE);
        return ThemeResolver.getFrameworkThemes(styles2);
    }

    @NotNull
    private List<StyleResourceValue> resolveNonFrameworkThemes() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myConfiguration.getModule());
        if (repositoryManager == null) {
            return Collections.emptyList();
        }
        LocalResourceRepository repository = repositoryManager.getAppResources();
        ResourceValueMap configuredResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)repository, (ResourceNamespace)repositoryManager.getNamespace(), (ResourceType)ResourceType.STYLE, (FolderConfiguration)this.myConfiguration.getFullConfig());
        return this.getNonFrameworkThemes(configuredResources);
    }

    @NotNull
    private List<Pair<StyleResourceValue, Module>> resolveLocallyDefinedModuleThemes() {
        Module module2 = this.myConfiguration.getModule();
        ArrayList<Pair<StyleResourceValue, Module>> result2 = new ArrayList<Pair<StyleResourceValue, Module>>();
        this.fillModuleResources(module2, ResourceRepositoryManager.getModuleResources(module2), result2);
        List<AndroidFacet> allAndroidDependencies = AndroidUtils.getAllAndroidDependencies(module2, false);
        for (AndroidFacet facet2 : allAndroidDependencies) {
            this.fillModuleResources(facet2.getModule(), ResourceRepositoryManager.getModuleResources(facet2), result2);
        }
        return result2;
    }

    private void fillModuleResources(@NotNull Module module2, @Nullable LocalResourceRepository repository, @NotNull List<Pair<StyleResourceValue, Module>> sink) {
        if (repository == null) {
            return;
        }
        ResourceNamespace namespace = ((SingleNamespaceResourceRepository)repository).getNamespace();
        ResourceValueMap configuredResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)repository, (ResourceNamespace)namespace, (ResourceType)ResourceType.STYLE, (FolderConfiguration)this.myConfiguration.getFullConfig());
        for (StyleResourceValue value2 : this.getNonFrameworkThemes(configuredResources)) {
            sink.add((Pair<StyleResourceValue, Module>)Pair.create((Object)value2, (Object)module2));
        }
    }

    @NotNull
    private List<StyleResourceValue> getNonFrameworkThemes(@NotNull ResourceValueMap styles2) {
        Collection values2 = styles2.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values2.size());
        HashMap cache = Maps.newHashMapWithExpectedSize((int)values2.size());
        for (ResourceValue value2 : values2) {
            StyleResourceValue styleValue;
            if (!(value2 instanceof StyleResourceValue) || !this.myResolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value2), (Map)cache)) continue;
            themes.add(styleValue);
        }
        return themes;
    }

    @NotNull
    private static List<StyleResourceValue> getFrameworkThemes(@NotNull ResourceValueMap styles2) {
        Collection values2 = styles2.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values2.size());
        for (ResourceValue value2 : values2) {
            String name = value2.getName();
            if (!name.startsWith("Theme.") && !name.equals("Theme")) continue;
            themes.add((StyleResourceValue)value2);
        }
        return themes;
    }

    @Deprecated
    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull String themeName) {
        ResourceReference styleReference = ResolutionUtils.getStyleReference(themeName);
        return this.myThemesByStyle.get(styleReference);
    }

    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull ResourceReference styleReference) {
        assert (styleReference.getResourceType() == ResourceType.STYLE);
        return this.myThemesByStyle.get(styleReference);
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getLocalThemes() {
        return this.myLocalThemes;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getExternalLibraryThemes() {
        return this.myExternalLibraryThemes;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getFrameworkThemes() {
        return this.myFrameworkThemes;
    }

    public int getThemesCount() {
        return this.myFrameworkThemes.size() + this.myExternalLibraryThemes.size() + this.myLocalThemes.size();
    }

    @NotNull
    public List<ResourceReference> getRecommendedThemes() {
        if (this.myRecommendedThemes == null) {
            this.myRecommendedThemes = ThemeResolver.computeRecommendedThemes(this.myConfiguration.getModule());
        }
        return this.myRecommendedThemes;
    }

    @NotNull
    public StyleResourceValue[] requiredBaseThemes() {
        Module module2 = this.myConfiguration.getModule();
        if (!DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.DESIGN) && !DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.ANDROIDX_DESIGN)) {
            return NO_BASE_THEMES;
        }
        ResourceNamespace namespace = ThemeResolver.getAppCompatNamespace(module2);
        if (namespace == null) {
            return NO_BASE_THEMES;
        }
        StyleResourceValue theme1 = this.findTheme(namespace, "Platform.AppCompat");
        StyleResourceValue theme2 = this.findTheme(namespace, "Platform.AppCompat.Light");
        if (theme1 == null || theme2 == null) {
            return NO_BASE_THEMES;
        }
        return new StyleResourceValue[]{theme1, theme2};
    }

    public boolean themeIsChildOfAny(@NotNull StyleResourceValue childTheme, StyleResourceValue ... parentThemes) {
        return this.myResolver.themeIsChildOfAny(childTheme, parentThemes);
    }

    private StyleResourceValue findTheme(@NotNull ResourceNamespace namespace, @NotNull String themeName) {
        ResourceReference reference2 = ResourceReference.style((ResourceNamespace)namespace, (String)themeName);
        return this.myResolver.getStyle(reference2);
    }

    @Nullable
    private static ResourceNamespace getAppCompatNamespace(@NotNull Module module2) {
        if (DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7)) {
            return ThemeResolver.isNamespacingEnabled(module2) ? ResourceNamespace.APPCOMPAT : ResourceNamespace.RES_AUTO;
        }
        if (DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.APP_COMPAT_V7)) {
            return ThemeResolver.isNamespacingEnabled(module2) ? ResourceNamespace.APPCOMPAT_LEGACY : ResourceNamespace.RES_AUTO;
        }
        return null;
    }

    @NotNull
    private static List<ResourceReference> computeRecommendedThemes(@NotNull Module module2) {
        ResourceNamespace appcompatNamespace = ThemeResolver.getAppCompatNamespace(module2);
        if (appcompatNamespace == null) {
            return ImmutableList.of((Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.NoActionBar"));
        }
        return ImmutableList.of((Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)appcompatNamespace, (String)"Theme.AppCompat.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)appcompatNamespace, (String)"Theme.AppCompat.NoActionBar"));
    }

    private static boolean isNamespacingEnabled(@NotNull Module module2) {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(module2);
        return repositoryManager != null && repositoryManager.getNamespacing() == Namespacing.REQUIRED;
    }
}

