/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ThemeEditorUtils {
    private ThemeEditorUtils() {
    }

    static int getMinApiLevel(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet2);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    public static int getMinFolderApi(@NotNull List<String> folderNames, @NotNull Module module2) {
        int minFolderApi = Integer.MAX_VALUE;
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(module2);
        for (String folderName : folderNames) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfig == null) continue;
            VersionQualifier version2 = folderConfig.getVersionQualifier();
            int folderApi = version2 != null ? version2.getVersion() : minModuleApi;
            minFolderApi = Math.min(minFolderApi, folderApi);
        }
        return minFolderApi;
    }

    @NotNull
    public static Configuration getConfigurationForModule(@NotNull Module module2) {
        Project project = module2.getProject();
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null) : "moduleComboModel must contain only Android modules";
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(module2);
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        return configurationManager.getConfiguration(projectFile);
    }

    @NotNull
    public static RenderTask configureRenderTask(@NotNull Module module2, @NotNull Configuration configuration) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null);
        RenderService service = RenderService.getInstance(module2.getProject());
        RenderLogger logger2 = new RenderLogger("ThemeEditorLogger", null);
        RenderTask task2 = service.taskBuilder(facet2, configuration).withLogger(logger2).buildSynchronously();
        assert (task2 != null);
        task2.getLayoutlibCallback().setLogger(logger2);
        return task2;
    }

    @NotNull
    public static String generateWordEnumeration(@NotNull Collection<String> words) {
        return AndroidTextUtils.generateCommaSeparatedList(words, (String)"and");
    }

    @NotNull
    public static Font scaleFontForAttribute(@NotNull Font font) {
        return font.deriveFont((float)Math.ceil((float)font.getSize() * 0.9f));
    }

    public static void setInheritsPopupMenuRecursive(JComponent comp) {
        comp.setInheritsPopupMenu(true);
        for (Component child : comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            ThemeEditorUtils.setInheritsPopupMenuRecursive((JComponent)child);
        }
    }
}

