/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.Client;
import com.android.layoutinspector.model.ClientWindow;
import com.android.layoutinspector.parser.LayoutFileDataParser;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorContext;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorEditorPanel;
import com.android.tools.idea.flags.ExperimentalSettingsConfigurable;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.DataManager;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.SearchTextField;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private LayoutInspectorEditorPanel myPanel;
    private LayoutInspectorContext myContext;

    public LayoutInspectorEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        this.myVirtualFile = file2;
        this.myProject = project;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myPanel == null) {
            try {
                this.myContext = new LayoutInspectorContext(LayoutFileDataParser.parseFromFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile)), (Disposable)this);
            }
            catch (IOException e) {
                return new JLabel(e.getLocalizedMessage(), 0);
            }
            this.myPanel = new LayoutInspectorEditorPanel(this, this.myProject, this.myContext);
        }
        return this.myPanel;
    }

    public void dispose() {
    }

    @NotNull
    public String getName() {
        return "Layout Inspector";
    }

    public void setState(@NotNull FileEditorState state) {
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void deselectNotify() {
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void selectNotify() {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }

    public void setSources(@Nullable Client client, @Nullable ClientWindow window2) {
        this.myContext.setSources(client, window2);
    }

    public static class NewVersionNotificationProvider
    extends EditorNotifications.Provider<EditorNotificationPanel> {
        private static Key<EditorNotificationPanel> KEY = Key.create((String)"new.layout.inspector.notification");
        private static final Key<String> HIDDEN_KEY = Key.create((String)"new.layout.inspector.notification.hidden");
        private static final String DISABLE_KEY = "new.layout.inspector.notification.disabled";

        @NotNull
        public Key<EditorNotificationPanel> getKey() {
            return KEY;
        }

        @Nullable
        public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
            if (fileEditor instanceof LayoutInspectorEditor && ((Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_ENABLED.get()).booleanValue()) {
                EditorNotificationPanel panel2 = new EditorNotificationPanel();
                panel2.setText("Using API 29? Try out the new Live Layout Inspector.");
                if (fileEditor.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
                    return null;
                }
                panel2.createActionLabel("Try it", () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, ExperimentalSettingsConfigurable.class, c -> {
                    AtomicReference<Runnable> runnableReference = new AtomicReference<Runnable>();
                    Runnable runnable2 = () -> {
                        JComponent component = c.createComponent();
                        if (component.getParent() == null) {
                            ApplicationManager.getApplication().invokeLater((Runnable)runnableReference.get());
                            return;
                        }
                        SearchTextField textField = (SearchTextField)DataManager.getInstance().getDataContext((Component)component).getData(SearchTextField.KEY);
                        if (textField != null) {
                            textField.setText("Enable Live Layout Inspector");
                        }
                    };
                    runnableReference.set(runnable2);
                    ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.any());
                }));
                panel2.createActionLabel("Hide notification", () -> {
                    fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
                    NewVersionNotificationProvider.update(file2, project);
                });
                panel2.createActionLabel("Don't show again", () -> {
                    PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
                    NewVersionNotificationProvider.update(file2, project);
                });
                return panel2;
            }
            return null;
        }

        private static void update(@NotNull VirtualFile file2, @NotNull Project project) {
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        }
    }
}

