/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layeredimage;

import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayersTree
extends Tree {
    private DefaultMutableTreeNode myRoot;

    LayersTree() {
        this.configure();
        DefaultTreeModel model2 = new DefaultTreeModel(null);
        this.setModel(model2);
    }

    void setImage(@Nullable Image image) {
        this.myRoot = new DefaultMutableTreeNode("Layers");
        if (image != null) {
            LayersTree.addLayers(this.myRoot, image.getLayers());
        }
        DefaultTreeModel model2 = (DefaultTreeModel)this.getModel();
        model2.setRoot(this.myRoot);
        model2.reload();
        this.expandAllRows();
    }

    private static void addLayers(@NotNull DefaultMutableTreeNode root2, @NotNull List<Layer> layers) {
        for (Layer layer : layers) {
            DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(layer);
            if (layer.getType() == Layer.Type.GROUP) {
                LayersTree.addLayers(node2, layer.getChildren());
            }
            root2.add(node2);
        }
    }

    private void configure() {
        this.createCellRenderer();
        this.getSelectionModel().setSelectionMode(1);
        this.setToggleClickCount(2);
        TreeUtil.installActions((JTree)((Object)this));
    }

    private void expandAllRows() {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)this.getPathForRow(i2).getLastPathComponent();
            if (node2 == this.myRoot) {
                this.expandRow(i2);
                continue;
            }
            Layer layer = (Layer)node2.getUserObject();
            if (layer.getType() != Layer.Type.GROUP || !layer.isOpen()) continue;
            this.expandRow(i2);
        }
        this.setRootVisible(false);
    }

    private void createCellRenderer() {
        LayerTreeCellRenderer renderer2 = new LayerTreeCellRenderer();
        renderer2.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
        this.setCellRenderer((TreeCellRenderer)((Object)renderer2));
    }

    private static class LayerTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Composite mAlphaComposite = AlphaComposite.getInstance(3, 0.5f);
        private boolean mVisible;

        private LayerTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)value2;
            Object content2 = node2.getUserObject();
            if (content2 instanceof Layer) {
                Layer layer = (Layer)content2;
                this.append(layer.getName());
                switch (layer.getType()) {
                    case ADJUSTMENT: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.SEEK_BAR);
                        break;
                    }
                    case IMAGE: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.IMAGE_VIEW);
                        break;
                    }
                    case GROUP: {
                        this.setIcon(AllIcons.Nodes.Folder);
                        break;
                    }
                    case SHAPE: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.TEXTURE_VIEW);
                        break;
                    }
                    case TEXT: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.TEXT_VIEW);
                    }
                }
                this.mVisible = layer.isVisible();
            }
        }

        protected void doPaint(Graphics2D g) {
            Composite old2 = g.getComposite();
            if (!this.mVisible) {
                g.setComposite(this.mAlphaComposite);
            }
            super.doPaint(g);
            if (!this.mVisible) {
                g.setComposite(old2);
            }
        }
    }
}

