/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.tools.idea.ddms.actions.PullRecordingTask;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScreenRecorderTask
implements Runnable {
    private static final CharSequence MEDIA_UNSUPPORTED_ERROR = "-1010";
    private static final long MAX_RECORDING_TIME_MILLIS = TimeUnit.MINUTES.toMillis(3L);
    private final Project myProject;
    private final IDevice myDevice;
    private final Path myHostRecordingFile;
    private final ScreenRecorderOptions myOptions;
    private DialogWrapper myDialogWrapper;

    public ScreenRecorderTask(@NotNull Project project, @NotNull IDevice device, @Nullable Path hostRecordingFile, @NotNull ScreenRecorderOptions options2) {
        this.myProject = project;
        this.myDevice = device;
        this.myHostRecordingFile = hostRecordingFile;
        this.myOptions = options2;
    }

    @Override
    @Slow
    public void run() {
        CountDownLatch completionLatch = null;
        CollectingOutputReceiver receiver = null;
        EmulatorConsole console = null;
        if (this.myHostRecordingFile != null) {
            console = EmulatorConsole.getConsole((IDevice)this.myDevice);
            if (console == null) {
                return;
            }
            try {
                console.startEmulatorScreenRecording(ScreenRecorderTask.getEmulatorScreenRecorderOptions(this.myHostRecordingFile, this.myOptions));
            }
            catch (Exception e) {
                EventQueue.invokeLater(() -> this.showError("Unexpected error while launching screen recording", e));
                return;
            }
        } else {
            completionLatch = new CountDownLatch(1);
            receiver = new CollectingOutputReceiver(completionLatch);
            this.startDeviceRecording(receiver, completionLatch);
        }
        long start2 = System.currentTimeMillis();
        CountDownLatch stoppingLatch = new CountDownLatch(1);
        ScreenRecorderDialog dialog2 = new ScreenRecorderDialog("Screen Recorder", stoppingLatch::countDown);
        EventQueue.invokeLater(() -> {
            this.myDialogWrapper = dialog2.createWrapper(this.myProject);
            this.myDialogWrapper.show();
        });
        try {
            while (!(stoppingLatch.await(this.millisUntilNextSecondTick(start2), TimeUnit.MILLISECONDS) || System.currentTimeMillis() - start2 >= MAX_RECORDING_TIME_MILLIS || completionLatch != null && completionLatch.getCount() <= 0L)) {
                EventQueue.invokeLater(() -> dialog2.setRecordingTimeMillis(System.currentTimeMillis() - start2));
                if (console == null || (console = EmulatorConsole.getConsole((IDevice)this.myDevice)) != null) continue;
            }
            EventQueue.invokeLater(() -> dialog2.setRecordingLabelText("Stopping..."));
            this.stopRecording(receiver, completionLatch, console);
        }
        catch (InterruptedException e) {
            this.stopRecording(receiver, null, console);
            throw new ProcessCanceledException();
        }
        finally {
            EventQueue.invokeLater(() -> this.myDialogWrapper.close(1));
        }
        if (receiver != null) {
            this.pullRecording(receiver);
        } else {
            this.pullEmulatorRecording();
        }
    }

    private long millisUntilNextSecondTick(long start2) {
        return 1000L - (System.currentTimeMillis() - start2) % 1000L;
    }

    private void startDeviceRecording(@NotNull CollectingOutputReceiver receiver, @NotNull CountDownLatch completionLatch) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myDevice.startScreenRecorder("/sdcard/ddmsrec.mp4", this.myOptions, (IShellOutputReceiver)receiver);
            }
            catch (Exception e) {
                completionLatch.countDown();
                EventQueue.invokeLater(() -> this.showError("Unexpected error while launching screen recording", e));
            }
        });
    }

    private void stopRecording(@Nullable CollectingOutputReceiver receiver, @Nullable CountDownLatch completionLatch, @Nullable EmulatorConsole console) {
        if (receiver != null) {
            receiver.cancel();
            if (completionLatch != null) {
                try {
                    completionLatch.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
            }
        } else if (console != null) {
            console.stopScreenRecording();
        }
    }

    private void pullEmulatorRecording() {
        assert (this.myHostRecordingFile != null);
        if (!Files.exists(this.myHostRecordingFile, new LinkOption[0])) {
            return;
        }
        EventQueue.invokeLater(() -> {
            VirtualFileWrapper fileWrapper = this.getTargetFile("webm");
            if (fileWrapper == null) {
                return;
            }
            try {
                Files.move(this.myHostRecordingFile, fileWrapper.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.showError("Unable to copy file to destination", e);
            }
        });
    }

    private void pullRecording(@NotNull CollectingOutputReceiver receiver) {
        EventQueue.invokeLater(() -> {
            if (receiver.getOutput().contains(MEDIA_UNSUPPORTED_ERROR)) {
                Messages.showErrorDialog((String)receiver.getOutput(), (String)"Screen Recorder Error");
                return;
            }
            VirtualFileWrapper fileWrapper = this.getTargetFile("mp4");
            if (fileWrapper == null) {
                return;
            }
            File file2 = fileWrapper.getFile();
            new PullRecordingTask(this.myProject, this.myDevice, file2.getAbsolutePath()).queue();
        });
    }

    @Nullable
    private VirtualFileWrapper getTargetFile(@NotNull String extension) {
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[]{extension});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
        VirtualFile baseDir = VfsUtil.getUserHomeDir();
        return saveFileDialog.save(baseDir, ScreenRecorderTask.getDefaultFileName(extension));
    }

    @UiThread
    private void showError(@NotNull String message2, @Nullable Throwable throwable) {
        ScreenRecorderAction.showError(this.myProject, message2, throwable);
    }

    @NotNull
    private static String getDefaultFileName(@NotNull String extension) {
        Calendar now = Calendar.getInstance();
        String fileName = "device-%tF-%tH%tM%tS";
        return String.format(Locale.US, SystemInfo.isMac ? fileName + '.' + extension : fileName, now, now, now, now);
    }

    @VisibleForTesting
    @NotNull
    static String getEmulatorScreenRecorderOptions(@NotNull Path filePath, @NotNull ScreenRecorderOptions options2) {
        StringBuilder sb = new StringBuilder();
        if (options2.width > 0 && options2.height > 0) {
            sb.append("--size ");
            sb.append(options2.width);
            sb.append('x');
            sb.append(options2.height);
            sb.append(' ');
        }
        if (options2.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options2.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options2.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options2.timeLimit, options2.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(filePath);
        return sb.toString();
    }
}

