/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.ddms.actions.Features;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.DeviceStateCache;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

final class CachedFeatures
implements Features {
    private final DeviceStateCache<CompletableFuture<DeviceFeatures>> myCache;

    CachedFeatures(@NotNull Disposable parent) {
        this.myCache = new DeviceStateCache(parent);
    }

    @Override
    public boolean watch(@NotNull IDevice device) {
        return this.getFeatures(device).myWatch;
    }

    @Override
    public boolean screenRecord(@NotNull IDevice device) {
        if (device.isEmulator()) {
            AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
            StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(CachedFeatures.class);
            LogWrapper logger2 = new LogWrapper(Logger.getInstance(CachedFeatures.class));
            return EmulatorAdvFeatures.emulatorSupportsScreenRecording(handler2, (ProgressIndicator)indicator, (ILogger)logger2);
        }
        return this.getFeatures(device).myScreenRecord;
    }

    @NotNull
    private DeviceFeatures getFeatures(@NotNull IDevice device) {
        CompletableFuture<DeviceFeatures> features = this.myCache.get(device, "");
        if (features == null) {
            features = CompletableFuture.supplyAsync(() -> new DeviceFeatures(device));
            this.myCache.put(device, "", features);
        }
        return features.getNow(new DeviceFeatures());
    }

    private static final class DeviceFeatures {
        private final boolean myWatch;
        private final boolean myScreenRecord;

        private DeviceFeatures() {
            this(false, false);
        }

        private DeviceFeatures(@NotNull IDevice device) {
            this(device.supportsFeature(IDevice.HardwareFeature.WATCH), device.supportsFeature(IDevice.Feature.SCREEN_RECORD));
        }

        private DeviceFeatures(boolean watch, boolean screenRecord) {
            this.myWatch = watch;
            this.myScreenRecord = screenRecord;
        }
    }
}

