/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.util;

import com.android.utils.XmlUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class XmlTagUtil {
    @NotNull
    public static XmlTag createTag(@NotNull Project project, @NotNull String text2) {
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        XmlTag tag = null;
        if (XmlUtils.parseDocumentSilently((String)text2, (boolean)false) != null) {
            try {
                tag = elementFactory.createTagFromText((CharSequence)text2);
                XmlTagUtil.setNamespaceUri(tag, "android", "http://schemas.android.com/apk/res/android");
                XmlTagUtil.setNamespaceUri(tag, "app", "http://schemas.android.com/apk/res-auto");
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (tag == null) {
            tag = elementFactory.createTagFromText((CharSequence)("<TextView xmlns:android=\"http://schemas.android.com/apk/res/android\"  android:text=\"" + XmlUtils.toXmlAttributeValue((String)text2) + "\" android:layout_width=\"wrap_content\" android:layout_height=\"wrap_content\"/>"));
        }
        return tag;
    }

    public static void setNamespaceUri(@NotNull XmlTag tag, @NotNull String prefix, @NotNull String uri) {
        boolean anyMatch = Arrays.stream(tag.getAttributes()).anyMatch(attribute -> attribute.getNamespacePrefix().equals(prefix));
        if (anyMatch) {
            tag.setAttribute("xmlns:" + prefix, uri);
        }
    }
}

