/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.MouseWheelMovedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollInteraction
extends Interaction {
    private static final int MAX_SCROLL_MULTIPLIER = 5;
    private final ScrollHandler myHandler;
    private int myScrolledAmount;
    private short myLastScrollSign;
    private int myScrollMultiplier = 1;
    private SceneView mySceneView;

    public ScrollInteraction(SceneView sceneView, ScrollHandler scrollHandler) {
        this.mySceneView = sceneView;
        this.myHandler = scrollHandler;
    }

    @Nullable
    public static ScrollInteraction createScrollInteraction(SceneView sceneView, NlComponent component) {
        ViewGroupHandler viewGroupHandler;
        ViewHandler viewHandler;
        ScrollHandler scrollHandler = null;
        ViewEditorImpl editor2 = new ViewEditorImpl(sceneView);
        for (NlComponent currentComponent = component; !(currentComponent == null || (viewHandler = NlComponentHelperKt.getViewHandler(currentComponent)) instanceof ViewGroupHandler && (scrollHandler = (viewGroupHandler = (ViewGroupHandler)viewHandler).createScrollHandler(editor2, currentComponent)) != null); currentComponent = currentComponent.getParent()) {
        }
        if (scrollHandler == null) {
            return null;
        }
        return new ScrollInteraction(sceneView, scrollHandler);
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        assert (event instanceof MouseWheelMovedEvent) : "The instance of event should be MouseWheelMovedEvent but it is " + event.getClass() + "; The Scroll Handler is  component is " + this.myHandler.getClass() + "; The SceneView is " + this.mySceneView + ", start (x, y) = " + this.myStartX + ", " + this.myStartY + ", start mask is " + this.myStartMask;
        MouseWheelEvent mouseEvent = (MouseWheelEvent)((MouseWheelMovedEvent)event).getEventObject();
        this.begin(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        if (event instanceof MouseWheelMovedEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)((MouseWheelMovedEvent)event).getEventObject();
            int x = mouseWheelEvent.getX();
            int y = mouseWheelEvent.getY();
            int scrollAmount = mouseWheelEvent.getScrollType() == 0 ? mouseWheelEvent.getUnitsToScroll() : (mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1);
            DesignSurface surface2 = this.mySceneView.getSurface();
            SceneView sceneView = surface2.getSceneView(x, y);
            if (sceneView == null) {
                mouseWheelEvent.getComponent().getParent().dispatchEvent(mouseWheelEvent);
                return;
            }
            NlComponent component = Coordinates.findComponent(sceneView, x, y);
            if (component == null) {
                mouseWheelEvent.getComponent().getParent().dispatchEvent(mouseWheelEvent);
                return;
            }
            if (!this.canScroll(scrollAmount)) {
                Dimension extentSize = surface2.getExtentSize();
                Dimension viewSize = surface2.getViewSize();
                if (viewSize.width > extentSize.width || viewSize.height > extentSize.height) {
                    mouseWheelEvent.getComponent().getParent().dispatchEvent(mouseWheelEvent);
                    return;
                }
            }
            this.scroll(x, y, scrollAmount);
        }
    }

    private void scroll(int x, int y, int scrollAmount) {
        short currentScrollSign = (short)(scrollAmount < 0 ? -1 : 0);
        if (this.myLastScrollSign != currentScrollSign) {
            this.myScrollMultiplier = 1;
            this.myLastScrollSign = currentScrollSign;
        } else if (this.myScrollMultiplier < 5) {
            ++this.myScrollMultiplier;
        }
        int newScrolledAmount = this.myScrolledAmount + scrollAmount * this.myScrollMultiplier;
        int scrolled = this.myHandler.update(newScrolledAmount);
        if (scrolled != 0) {
            this.myScrolledAmount += scrollAmount;
            this.mySceneView.getSceneManager().requestLayoutAndRender(false);
        }
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        this.end(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.myScrollMultiplier = 1;
        this.myHandler.commit(this.myScrolledAmount);
        this.myScrolledAmount = 0;
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        this.cancel(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void cancel(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.myHandler.update(0);
        this.mySceneView.getSceneManager().requestLayoutAndRender(false);
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return null;
    }

    public boolean canScroll(int scrollAmount) {
        return this.myHandler.canScroll(scrollAmount);
    }
}

