/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.TooManyIssuesIssue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    private static final int MAX_ISSUE_NUMBER_LIMIT = 200;
    private final int myIssueNumberLimit;
    private ImmutableList<Issue> myIssues = ImmutableList.of();
    private final ListenerCollection<IssueModelListener> myListeners;
    protected int myWarningCount;
    protected int myErrorCount;
    @VisibleForTesting
    public final Runnable myUpdateCallback = () -> this.updateErrorsList();
    private List<IssueProvider> myIssueProviders = new ArrayList<IssueProvider>();

    @VisibleForTesting
    IssueModel(@NotNull Executor listenerExecutor, int issueNumberLimit) {
        this.myListeners = ListenerCollection.createWithExecutor(listenerExecutor);
        this.myIssueNumberLimit = issueNumberLimit;
    }

    @VisibleForTesting
    IssueModel(@NotNull Executor listenerExecutor) {
        this(listenerExecutor, 200);
    }

    public IssueModel() {
        this(command -> GuiUtils.invokeLaterIfNeeded((Runnable)command, (ModalityState)ModalityState.defaultModalityState()));
    }

    @Nullable
    public Issue getHighestSeverityIssue(NlComponent component) {
        IssueSource componentSource = IssueSource.fromNlComponent(component);
        Issue[] filtered = (Issue[])this.myIssues.stream().filter(it -> componentSource.equals(it.getSource())).toArray(Issue[]::new);
        if (filtered.length == 0) {
            return null;
        }
        Issue max = filtered[0];
        for (int i2 = 1; i2 < filtered.length; ++i2) {
            Issue it2 = filtered[i2];
            if (max.getSeverity().compareTo(it2.getSeverity()) >= 0) continue;
            max = it2;
        }
        return max;
    }

    @Nullable
    public static Icon getIssueIcon(@NotNull HighlightSeverity severity, boolean selected) {
        boolean isError;
        boolean bl = isError = severity == HighlightSeverity.ERROR;
        if (selected) {
            return isError ? StudioIcons.Common.ERROR_INLINE_SELECTED : StudioIcons.Common.WARNING_INLINE_SELECTED;
        }
        return isError ? StudioIcons.Common.ERROR_INLINE : StudioIcons.Common.WARNING_INLINE;
    }

    @VisibleForTesting
    public void updateErrorsList() {
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        for (IssueProvider provider2 : ImmutableList.copyOf(this.myIssueProviders)) {
            provider2.collectIssues((ImmutableCollection.Builder<Issue>)issueListBuilder);
        }
        ImmutableList newIssueList = issueListBuilder.build();
        if (newIssueList.size() > this.myIssueNumberLimit) {
            newIssueList = ImmutableList.builder().addAll((Iterable)newIssueList.subList(0, this.myIssueNumberLimit)).add((Object)new TooManyIssuesIssue(newIssueList.size() - this.myIssueNumberLimit)).build();
        }
        newIssueList.forEach(issue2 -> this.updateIssuesCounts((Issue)issue2));
        this.myIssues = newIssueList;
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull Issue issue2) {
        if (issue2.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue2.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    public void addIssueProvider(@NotNull IssueProvider issueProvider2) {
        this.myIssueProviders.add(issueProvider2);
        issueProvider2.addListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    public void removeIssueProvider(@NotNull IssueProvider issueProvider2) {
        this.myIssueProviders.remove(issueProvider2);
        issueProvider2.removeListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        return this.myIssues;
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    @Nullable
    public Issue findIssue(@NotNull NlComponent component) {
        for (Issue issue2 : this.myIssues) {
            if (!component.equals(issue2.getSource())) continue;
            return issue2;
        }
        return null;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

