/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerTypeRegistrar;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DesignerEditorProvider
implements FileEditorProvider,
QuickDefinitionProvider,
DumbAware {
    @NotNull
    private final List<DesignerEditorFileType> myAcceptedTypes;

    protected DesignerEditorProvider(@NotNull List<DesignerEditorFileType> acceptedTypes) {
        this.myAcceptedTypes = acceptedTypes;
        this.myAcceptedTypes.forEach(DesignerTypeRegistrar.INSTANCE::register);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile);
        if (psiFile2 instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile2;
            return this.myAcceptedTypes.stream().anyMatch(type -> type.isResourceTypeOf((PsiFile)xmlFile));
        }
        return false;
    }

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        DesignerEditor designEditor = this.createDesignEditor(project, file2);
        DesignerEditorPanel editorPanel2 = designEditor.getComponent();
        TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file2);
        DesignerEditorProvider.addCaretListener(textEditor, designEditor);
        editorPanel2.getSurface().setFileEditorDelegate((FileEditor)textEditor);
        DesignToolsSplitEditor splitEditor = new DesignToolsSplitEditor(textEditor, designEditor, project);
        editorPanel2.getWorkBench().setFileEditor((FileEditor)splitEditor);
        DataManager.registerDataProvider((JComponent)editorPanel2, (DataProvider)splitEditor);
        return splitEditor;
    }

    private static void addCaretListener(@NotNull TextEditor editor2, final @NotNull DesignerEditor designEditor) {
        final CaretModel caretModel = editor2.getEditor().getCaretModel();
        final MergingUpdateQueue updateQueue = new MergingUpdateQueue("split.editor.preview.edit", 250, true, null, (Disposable)designEditor, null, Alarm.ThreadToUse.SWING_THREAD);
        updateQueue.setRestartTimerOnAdd(true);
        caretModel.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                final DesignSurface surface2 = designEditor.getComponent().getSurface();
                SceneView sceneView = surface2.getFocusedSceneView();
                int offset2 = caretModel.getOffset();
                if (sceneView == null || offset2 == -1) {
                    return;
                }
                NlModel model2 = sceneView.getSceneManager().getModel();
                ImmutableList<NlComponent> views2 = model2.findByOffset(offset2);
                if (views2.isEmpty()) {
                    views2 = model2.getComponents();
                }
                SelectionModel selectionModel = sceneView.getSelectionModel();
                selectionModel.setSelection((List<? extends NlComponent>)views2);
                updateQueue.queue(new Update("Design editor update"){

                    public void run() {
                        surface2.repaint();
                    }

                    public boolean canEat(Update update2) {
                        return true;
                    }
                });
            }
        });
    }

    @NotNull
    public abstract DesignerEditor createDesignEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract String getEditorTypeId();

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

