/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.editor.ActionToolbarUtil;
import com.android.tools.editor.PanZoomListener;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsToolbar
implements DesignSurfaceListener,
Disposable,
PanZoomListener,
ConfigurationListener,
ModelListener {
    private static final int CONFIGURATION_UPDATE_FLAGS = 34;
    private final DesignSurface mySurface;
    private final JComponent myToolbarComponent;
    private ActionToolbar myNorthToolbar;
    private ActionToolbar myNorthEastToolbar;
    private ActionToolbarImpl myCenterToolbar;
    private ActionToolbar myEastToolbar;
    private final DefaultActionGroup myDynamicGroup = new DefaultActionGroup();
    private Configuration myConfiguration;
    private DesignerEditorFileType myLayoutType;
    private ToolbarActionGroups myToolbarActionGroups;
    private NlModel myModel = null;

    public ActionsToolbar(@NotNull Disposable parent, @NotNull DesignSurface surface2) {
        Disposer.register((Disposable)parent, (Disposable)this);
        this.mySurface = surface2;
        this.mySurface.addListener(this);
        this.mySurface.addPanZoomListener(this);
        if (this.myConfiguration == null) {
            this.myConfiguration = (Configuration)Iterables.getFirst(this.mySurface.getConfigurations(), null);
            if (this.myConfiguration != null) {
                this.myConfiguration.addListener(this);
            }
        }
        this.myToolbarComponent = ActionsToolbar.createToolbarComponent();
        this.updateActionGroups(surface2.getLayoutType());
        this.updateActions();
    }

    public void dispose() {
        this.mySurface.removePanZoomListener(this);
        this.mySurface.removeListener(this);
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener(this);
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel = null;
        }
    }

    @NotNull
    public JComponent getToolbarComponent() {
        return this.myToolbarComponent;
    }

    ActionToolbarImpl getCenterToolbar() {
        return this.myCenterToolbar;
    }

    @NotNull
    private static JComponent createToolbarComponent() {
        AdtPrimaryPanel panel2 = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        panel2.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder()));
        return panel2;
    }

    private void updateActionGroups(@NotNull DesignerEditorFileType layoutType) {
        this.myToolbarComponent.removeAll();
        if (this.myToolbarActionGroups != null) {
            Disposer.dispose((Disposable)this.myToolbarActionGroups);
        }
        this.myToolbarActionGroups = layoutType.getToolbarActionGroups(this.mySurface);
        Disposer.register((Disposable)this, (Disposable)this.myToolbarActionGroups);
        this.myNorthToolbar = ActionsToolbar.createActionToolbar("NlConfigToolbar", this.myToolbarActionGroups.getNorthGroup());
        this.myNorthToolbar.setLayoutPolicy(2);
        this.myNorthToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent northToolbarComponent = this.myNorthToolbar.getComponent();
        northToolbarComponent.setName("NlConfigToolbar");
        this.myNorthEastToolbar = ActionsToolbar.createActionToolbar("NlRhsConfigToolbar", this.myToolbarActionGroups.getNorthEastGroup());
        this.myNorthEastToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent northEastToolbarComponent = this.myNorthEastToolbar.getComponent();
        northEastToolbarComponent.setName("NlRhsConfigToolbar");
        this.myCenterToolbar = ActionsToolbar.createActionToolbar("NlLayoutToolbar", (ActionGroup)this.myDynamicGroup);
        this.myCenterToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent centerToolbarComponent = this.myCenterToolbar.getComponent();
        centerToolbarComponent.setName("NlLayoutToolbar");
        AdtPrimaryPanel centerToolbarComponentWrapper = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        centerToolbarComponentWrapper.add(centerToolbarComponent);
        this.myEastToolbar = ActionsToolbar.createActionToolbar("NlRhsToolbar", this.myToolbarActionGroups.getEastGroup());
        this.myEastToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent eastToolbarComponent = this.myEastToolbar.getComponent();
        eastToolbarComponent.setName("NlRhsToolbar");
        if (northToolbarComponent.isVisible() || northEastToolbarComponent.isVisible()) {
            AdtPrimaryPanel northPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
            northPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder()));
            northPanel.add((Component)northToolbarComponent, "Center");
            northPanel.add((Component)northEastToolbarComponent, "East");
            this.myToolbarComponent.add((Component)northPanel, "North");
        }
        this.myToolbarComponent.add((Component)centerToolbarComponentWrapper, "Center");
        this.myToolbarComponent.add((Component)eastToolbarComponent, "East");
    }

    @NotNull
    private static ActionToolbarImpl createActionToolbar(@NotNull String place, @NotNull ActionGroup group2) {
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar(place, group2, true);
        toolbar2.setLayoutPolicy(1);
        if (group2 == ActionGroup.EMPTY_GROUP) {
            toolbar2.getComponent().setVisible(false);
        }
        ActionToolbarUtil.makeToolbarNavigable(toolbar2);
        return (ActionToolbarImpl)toolbar2;
    }

    public void updateActions() {
        SceneView view = this.mySurface.getFocusedSceneView();
        if (view != null) {
            SelectionModel selectionModel = view.getSelectionModel();
            List<NlComponent> selection = selectionModel.getSelection();
            if (selection.isEmpty()) {
                ImmutableList<NlComponent> roots = view.getModel().getComponents();
                if (roots.size() == 1) {
                    selection = Collections.singletonList(roots.get(0));
                } else {
                    this.updateBottomActionBarBorder();
                    return;
                }
            }
            this.updateActions(selection);
        }
    }

    private void updateActions(@NotNull List<NlComponent> newSelection) {
        SceneView screenView = this.mySurface.getFocusedSceneView();
        if (screenView == null) {
            return;
        }
        DesignerEditorFileType surfaceLayoutType = this.mySurface.getLayoutType();
        DefaultActionGroup selectionToolbar = surfaceLayoutType.getSelectionContextToolbar(this.mySurface, newSelection);
        if (selectionToolbar.getChildrenCount() > 0) {
            this.myDynamicGroup.copyFromGroup(selectionToolbar);
        }
        this.updateBottomActionBarBorder();
        this.myCenterToolbar.clearPresentationCache();
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface2, @NotNull List<NlComponent> newSelection) {
        assert (surface2 == this.mySurface);
        if (!newSelection.isEmpty()) {
            this.updateActions(newSelection);
        } else {
            this.updateActions();
        }
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface2, @Nullable NlModel model2) {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        if (model2 != null) {
            model2.addListener(this);
        }
        this.myModel = model2;
        this.myNorthToolbar.updateActionsImmediately();
        this.myNorthEastToolbar.updateActionsImmediately();
        DesignerEditorFileType surfaceLayoutType = surface2.getLayoutType();
        if (surfaceLayoutType != this.myLayoutType) {
            this.myLayoutType = surfaceLayoutType;
            this.updateActionGroups(this.myLayoutType);
        }
        this.updateActions();
    }

    private void updateBottomActionBarBorder() {
        boolean hasBottomActionBar = this.myEastToolbar.getComponent().isVisible() || this.myDynamicGroup.getChildrenCount() > 0;
        int bottom2 = hasBottomActionBar ? 1 : 0;
        this.myToolbarComponent.setBorder(BorderFactory.createMatteBorder(0, 0, bottom2, 0, (Color)StudioColorsKt.getBorder()));
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface2, @NotNull NlComponent component) {
        return false;
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.mySurface.getProject().isDisposed()) {
                return;
            }
            if (model2.getComponents().size() == 1) {
                this.updateActions();
            }
        });
    }

    @Override
    public void zoomChanged() {
        UIUtil.invokeLaterIfNeeded(() -> this.myNorthEastToolbar.updateActionsImmediately());
    }

    @Override
    public void panningChanged(@NotNull AdjustmentEvent event) {
        UIUtil.invokeLaterIfNeeded(() -> this.myNorthEastToolbar.updateActionsImmediately());
    }

    @Override
    public boolean changed(int flags) {
        if ((flags & 0x22) > 0 && this.myNorthToolbar != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myNorthEastToolbar.updateActionsImmediately());
        }
        return true;
    }
}

