/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DeleteDeviceAction
extends DeviceUiAction {
    public DeleteDeviceAction(@NotNull DeviceUiAction.DeviceProvider provider2) {
        super(provider2, "Delete");
    }

    @Override
    public boolean isEnabled() {
        Device device = this.myProvider.getDevice();
        return device != null && DeviceManagerConnection.getDefaultDeviceManagerConnection().isUserDevice(device);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Device device = this.myProvider.getDevice();
        int result2 = Messages.showYesNoDialog((Project)this.myProvider.getProject(), (String)("Do you really want to delete Device " + device.getDisplayName() + "?"), (String)"Confirm Deletion", (Icon)AllIcons.General.QuestionDialog);
        if (result2 == 0) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().deleteDevice(device);
            this.myProvider.refreshDevices();
            this.myProvider.selectDefaultDevice();
        }
    }
}

