/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.utils.HtmlBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class AvdSummaryAction
extends AvdUiAction {
    public AvdSummaryAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "View Details", "View details for debugging", AllIcons.General.BalloonInformation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdInfo info2 = this.getAvdInfo();
        if (info2 == null) {
            return;
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.openHtmlBody();
        htmlBuilder.addHtml("<br>Name: ").add(info2.getName());
        htmlBuilder.addHtml("<br>CPU/ABI: ").add(AvdInfo.getPrettyAbiType((AvdInfo)info2));
        htmlBuilder.addHtml("<br>Path: ").add(info2.getDataFolderPath());
        if (info2.getStatus() != AvdInfo.AvdStatus.OK) {
            htmlBuilder.addHtml("<br>Error: ").add(info2.getErrorMessage());
        } else {
            String snapshot;
            String sdcard;
            AndroidVersion version2 = info2.getAndroidVersion();
            htmlBuilder.addHtml("<br>Target: ").add(String.format("%1$s (API level %2$s)", info2.getTag(), version2.getApiString()));
            Map properties2 = info2.getProperties();
            String skin = (String)properties2.get("skin.name");
            if (skin != null) {
                htmlBuilder.addHtml("<br>Skin: ").add(skin);
            }
            if ((sdcard = (String)properties2.get("sdcard.size")) == null) {
                sdcard = (String)properties2.get("sdcard.path");
            }
            if (sdcard != null) {
                htmlBuilder.addHtml("<br>SD Card: ").add(sdcard);
            }
            if ((snapshot = (String)properties2.get("snapshot.present")) != null) {
                htmlBuilder.addHtml("<br>Snapshot: ").add(snapshot);
            }
            HashMap copy2 = new HashMap(properties2);
            copy2.remove("abi.type");
            copy2.remove("hw.cpu.arch");
            copy2.remove("skin.name");
            copy2.remove("skin.path");
            copy2.remove("sdcard.size");
            copy2.remove("sdcard.path");
            copy2.remove("image.sysdir.2");
            if (!copy2.isEmpty()) {
                for (Map.Entry entry : copy2.entrySet()) {
                    htmlBuilder.addHtml("<br>").add((String)entry.getKey()).add(": ").add((String)entry.getValue());
                }
            }
        }
        htmlBuilder.closeHtmlBody();
        String[] options2 = new String[]{"Copy to Clipboard and Close", "Close"};
        int i2 = Messages.showDialog((Project)this.getProject(), (String)htmlBuilder.getHtml(), (String)("Details for " + info2.getName()), (String[])options2, (int)0, (Icon)AllIcons.General.InformationDialog);
        if (i2 == 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.stripHtml((String)htmlBuilder.getHtml(), (boolean)true)));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getAvdInfo() != null;
    }
}

