/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdSummaryAction;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.ColdBootNowAction;
import com.android.tools.idea.avdmanager.DeleteAvdAction;
import com.android.tools.idea.avdmanager.DuplicateAvdAction;
import com.android.tools.idea.avdmanager.EditAvdAction;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.avdmanager.InstallSystemImageAction;
import com.android.tools.idea.avdmanager.RepairAvdAction;
import com.android.tools.idea.avdmanager.RunAvdAction;
import com.android.tools.idea.avdmanager.ShowAvdOnDiskAction;
import com.android.tools.idea.avdmanager.StopAvdAction;
import com.android.tools.idea.avdmanager.WipeAvdDataAction;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdActionPanel
extends JPanel
implements AvdUiAction.AvdInfoProvider {
    @NotNull
    private final AvdInfo myAvdInfo;
    private final AvdRefreshProvider myRefreshProvider;
    private final JBPopupMenu myOverflowMenu = new JBPopupMenu();
    private final FocusableHyperlinkLabel myOverflowMenuButton = new FocusableHyperlinkLabel("", AllIcons.Actions.MoveDown);
    private final Border myMargins = JBUI.Borders.empty((int)5, (int)3, (int)5, (int)3);
    public List<FocusableHyperlinkLabel> myVisibleComponents = Lists.newArrayList();
    private boolean myFocused;
    private int myFocusedComponent = -1;
    private boolean myHighlighted = false;

    public AvdActionPanel(@NotNull AvdInfo avdInfo, int numVisibleActions, AvdRefreshProvider refreshProvider) {
        this.myRefreshProvider = refreshProvider;
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.myAvdInfo = avdInfo;
        List<AvdUiAction> actions2 = this.getActions();
        this.setLayout(new FlowLayout(2, 3, 0));
        int visibleActionCount = 0;
        boolean errorState = false;
        if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            AvdUiAction action2 = null;
            if (AvdManagerConnection.isSystemImageDownloadProblem(avdInfo.getStatus())) {
                action2 = new InstallSystemImageAction(this);
            } else if (AvdManagerConnection.isAvdRepairable(avdInfo.getStatus())) {
                action2 = new RepairAvdAction(this);
            }
            if (action2 != null) {
                FocusableHyperlinkLabel repairAction = new FocusableHyperlinkLabel(action2.getText(), action2.getIcon(), action2.isEnabled());
                this.add((Component)((Object)repairAction));
                repairAction.addHyperlinkListener(action2);
                this.myVisibleComponents.add(repairAction);
            } else {
                this.add((Component)new JBLabel("Failed to load", AllIcons.General.BalloonError, 10));
            }
            numVisibleActions = 0;
            errorState = true;
        }
        for (AvdUiAction action3 : actions2) {
            FocusableHyperlinkLabel actionLabel;
            if (errorState || numVisibleActions != -1 && visibleActionCount >= numVisibleActions) {
                JBMenuItem menuItem = new JBMenuItem((Action)action3);
                this.myOverflowMenu.add((JMenuItem)menuItem);
                actionLabel = menuItem;
            } else {
                actionLabel = new FocusableHyperlinkLabel("", action3.getIcon());
                actionLabel.addHyperlinkListener(action3);
                this.add((Component)((Object)actionLabel));
                this.myVisibleComponents.add(actionLabel);
                ++visibleActionCount;
            }
            ((JComponent)((Object)actionLabel)).setToolTipText(action3.getDescription());
            ((JComponent)((Object)actionLabel)).setBorder(this.myMargins);
        }
        this.myOverflowMenuButton.setBorder(this.myMargins);
        this.add((Component)((Object)this.myOverflowMenuButton));
        this.myVisibleComponents.add(this.myOverflowMenuButton);
        this.myOverflowMenuButton.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AvdActionPanel.this.myOverflowMenu.show((Component)((Object)AvdActionPanel.this.myOverflowMenuButton), AvdActionPanel.this.myOverflowMenuButton.getX() - ((AvdActionPanel)AvdActionPanel.this).myOverflowMenu.getPreferredSize().width, AvdActionPanel.this.myOverflowMenuButton.getY());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    AvdActionPanel.this.runFocusedAction();
                }
            }
        });
    }

    @NotNull
    private List<AvdUiAction> getActions() {
        ArrayList<AvdUiAction> actionList = new ArrayList<AvdUiAction>();
        actionList.add(new RunAvdAction(this));
        actionList.add(new EditAvdAction(this));
        actionList.add(new DuplicateAvdAction(this));
        actionList.add(new WipeAvdDataAction(this));
        if (EmulatorAdvFeatures.emulatorSupportsFastBoot(AndroidSdks.getInstance().tryToChooseSdkHandler(), (ProgressIndicator)new StudioLoggerProgressIndicator(AvdActionPanel.class), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class)))) {
            actionList.add(new ColdBootNowAction(this));
        }
        actionList.add(new ShowAvdOnDiskAction(this));
        actionList.add(new AvdSummaryAction(this));
        actionList.add(new DeleteAvdAction(this));
        actionList.add(new StopAvdAction(this));
        return actionList;
    }

    @Override
    @NotNull
    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }

    @Override
    public void refreshAvds() {
        this.myRefreshProvider.refreshAvds();
    }

    @Override
    public void refreshAvdsAndSelect(@Nullable AvdInfo avdToSelect) {
        this.myRefreshProvider.refreshAvdsAndSelect(avdToSelect);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myRefreshProvider.getProject();
    }

    @Override
    @NotNull
    public JComponent getAvdProviderComponent() {
        return this.myRefreshProvider.getComponent();
    }

    public void showPopup(@NotNull Component c, @NotNull MouseEvent e) {
        this.myOverflowMenu.show(c, e.getX(), e.getY());
    }

    public void runFocusedAction() {
        this.myVisibleComponents.get(this.myFocusedComponent).doClick();
    }

    public boolean cycleFocus(boolean backward) {
        if (backward) {
            if (this.myFocusedComponent == -1) {
                this.myFocusedComponent = this.myVisibleComponents.size() - 1;
                return true;
            }
            --this.myFocusedComponent;
            return this.myFocusedComponent != -1;
        }
        if (this.myFocusedComponent == this.myVisibleComponents.size() - 1) {
            this.myFocusedComponent = -1;
            return false;
        }
        ++this.myFocusedComponent;
        return true;
    }

    public void setFocused(boolean focused) {
        this.myFocused = focused;
        if (!focused) {
            this.myFocusedComponent = -1;
        }
    }

    public void setHighlighted(boolean highlighted) {
        this.myHighlighted = highlighted;
    }

    private class FocusableHyperlinkLabel
    extends HyperlinkLabel {
        Icon myHighlightedIcon;

        FocusableHyperlinkLabel(String text2, Icon icon2) {
            super(text2, JBColor.foreground(), JBColor.background(), JBColor.foreground());
            this.setIcon(icon2);
            this.setOpaque(false);
            this.setUseIconAsLink(true);
            if (icon2 != null) {
                this.myHighlightedIcon = ColoredIconGenerator.generateWhiteIcon((Icon)this.myIcon);
            }
        }

        FocusableHyperlinkLabel(String text2, Icon icon2, boolean enabled) {
            this(text2, icon2);
            this.setEnabled(enabled);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (AvdActionPanel.this.myFocused && AvdActionPanel.this.myFocusedComponent != -1 && AvdActionPanel.this.myVisibleComponents.get(AvdActionPanel.this.myFocusedComponent) == this) {
                g.setColor(UIManager.getColor("Table.selectionForeground"));
                UIUtil.drawDottedRectangle((Graphics)g, (int)0, (int)0, (int)(this.getWidth() - 2), (int)(this.getHeight() - 2));
            }
            if (this.myIcon != null) {
                Icon theIcon = this.myIcon;
                if (AvdActionPanel.this.myHighlighted && this.myHighlightedIcon != null) {
                    theIcon = this.myHighlightedIcon;
                }
                theIcon.paintIcon((Component)((Object)this), g, 0, (this.getHeight() - theIcon.getIconHeight()) / 2);
            }
        }
    }

    public static interface AvdRefreshProvider {
        public void refreshAvds();

        public void refreshAvdsAndSelect(@Nullable AvdInfo var1);

        @Nullable
        public Project getProject();

        @NotNull
        public JComponent getComponent();
    }
}

