/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.AssistantGetBundleFromConfigTask;
import com.android.tools.idea.assistant.AssistantGetBundleTask;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.view.FeaturesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.http.concurrent.FutureCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/assistant/AssistSidePanel;", "Ljavax/swing/JPanel;", "actionId", "", "project", "Lcom/intellij/openapi/project/Project;", "titleCallback", "Lorg/apache/http/concurrent/FutureCallback;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/apache/http/concurrent/FutureCallback;)V", "bundleCreator", "Lcom/android/tools/idea/assistant/AssistantBundleCreator;", "errorPanel", "errorText", "Lcom/intellij/ui/components/JBLabel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "getLoadingPanel", "()Lcom/intellij/ui/components/JBLoadingPanel;", "setLoadingPanel", "(Lcom/intellij/ui/components/JBLoadingPanel;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "createFeaturesPanel", "", "bundle", "Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;", "AssistantLoadingCallback", "assistant"})
public final class AssistSidePanel
extends JPanel {
    @NotNull
    private JBLoadingPanel loadingPanel;
    private JPanel errorPanel;
    private JBLabel errorText;
    private AssistantBundleCreator bundleCreator;
    private final String actionId;
    private final Project project;
    private final FutureCallback<String> titleCallback;

    @NotNull
    public final JBLoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    public final void setLoadingPanel(@NotNull JBLoadingPanel jBLoadingPanel) {
        this.loadingPanel = jBLoadingPanel;
    }

    private final Logger getLog() {
        return Logger.getInstance(AssistSidePanel.class);
    }

    private final void createFeaturesPanel(TutorialBundleData bundle, String actionId, AssistantBundleCreator bundleCreator, Project project) {
        if (bundle == null) {
            this.getLog().error("Unable to get Assistant configuration for action: " + actionId);
            this.errorPanel.setVisible(true);
        } else {
            bundle.setResourceClass(bundleCreator.getClass());
            for (FeatureData featureData : bundle.getFeatures()) {
                featureData.setResourceClass(bundleCreator.getClass());
            }
            FutureCallback<String> futureCallback = this.titleCallback;
            if (futureCallback != null) {
                futureCallback.completed((Object)bundle.getName());
            }
            AnalyticsProvider analyticsProvider = bundleCreator.getAnalyticsProvider();
            analyticsProvider.trackPanelOpened(project);
            FeaturesPanel featuresPanel = new FeaturesPanel(bundle, project, analyticsProvider);
            this.add(featuresPanel);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AssistSidePanel(@NotNull String actionId, @NotNull Project project, @Nullable FutureCallback<String> titleCallback) {
        super(new BorderLayout());
        this.actionId = actionId;
        this.project = project;
        this.titleCallback = titleCallback;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.project, 200);
        this.loadingPanel.add((Component)this, (Object)"Center");
        this.loadingPanel.setLoadingText("Loading assistant content");
        this.loadingPanel.setName("assistantPanel");
        this.loadingPanel.startLoading();
        this.errorPanel = new JPanel(new BorderLayout());
        String message2 = "Error loading assistant panel. Please check idea.log for detailed error message.";
        Object[] objectArray = StringCompanionObject.INSTANCE;
        String string = "<html><div style='text-align: center;'>%s</div></html>";
        Object[] objectArray2 = new Object[]{StringUtil.escapeXml((String)message2)};
        int n = 0;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String htmlText = string2;
        this.errorText = new JBLabel(htmlText);
        this.errorText.setHorizontalAlignment(0);
        this.errorPanel.add((Component)this.errorText, "Center");
        this.add((Component)this.errorPanel, "Center");
        this.errorPanel.setVisible(false);
        try {
            Object element$iv2;
            block8: {
                void $this$first$iv;
                objectArray = AssistantBundleCreator.EP_NAME.getExtensions();
                AssistSidePanel assistSidePanel = this;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    AssistantBundleCreator it = (AssistantBundleCreator)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getBundleId(), (Object)this.actionId)) {
                        continue;
                    }
                    break block8;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Object object = element$iv2;
            assistSidePanel.bundleCreator = (AssistantBundleCreator)object;
        }
        catch (NoSuchElementException e) {
            throw (Throwable)new RuntimeException("Unable to find configuration for the selected action: " + this.actionId);
        }
        URL config = null;
        try {
            config = this.bundleCreator.getConfig();
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((Throwable)e);
        }
        if (config != null) {
            AssistantGetBundleFromConfigTask task2 = new AssistantGetBundleFromConfigTask(this.project, config, (FutureCallback<TutorialBundleData>)((FutureCallback)new AssistantLoadingCallback()), this.bundleCreator.getBundleId());
            task2.queue();
        } else {
            AssistantGetBundleTask task3 = new AssistantGetBundleTask(this.project, this.bundleCreator, (FutureCallback<TutorialBundleData>)((FutureCallback)new AssistantLoadingCallback()));
            task3.queue();
        }
    }

    public static final /* synthetic */ void access$setBundleCreator$p(AssistSidePanel $this, AssistantBundleCreator assistantBundleCreator) {
        $this.bundleCreator = assistantBundleCreator;
    }

    public static final /* synthetic */ void access$setErrorPanel$p(AssistSidePanel $this, JPanel jPanel) {
        $this.errorPanel = jPanel;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/assistant/AssistSidePanel$AssistantLoadingCallback;", "Lorg/apache/http/concurrent/FutureCallback;", "Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;", "(Lcom/android/tools/idea/assistant/AssistSidePanel;)V", "cancelled", "", "completed", "bundle", "failed", "ex", "Ljava/lang/Exception;", "assistant"})
    public final class AssistantLoadingCallback
    implements FutureCallback<TutorialBundleData> {
        public void cancelled() {
            AssistSidePanel.this.getLoadingPanel().stopLoading();
        }

        public void completed(@Nullable TutorialBundleData bundle) {
            AssistSidePanel.this.createFeaturesPanel(bundle, AssistSidePanel.this.actionId, AssistSidePanel.this.bundleCreator, AssistSidePanel.this.project);
            AssistSidePanel.this.getLoadingPanel().stopLoading();
        }

        public void failed(@Nullable Exception ex) {
            AssistSidePanel.this.getLog().error((Object)ex);
            AssistSidePanel.this.getLoadingPanel().stopLoading();
            AssistSidePanel.this.errorPanel.setVisible(true);
        }
    }
}

