/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.resolver;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.appinspection.ide.resolver.AppInspectorJarPaths;
import com.android.tools.idea.appinspection.inspector.api.AppInspectorJar;
import com.android.tools.idea.appinspection.inspector.api.launch.ArtifactCoordinate;
import com.android.tools.idea.appinspection.inspector.api.service.FileService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\nH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/appinspection/ide/resolver/AppInspectorJarPaths;", "", "fileService", "Lcom/android/tools/idea/appinspection/inspector/api/service/FileService;", "(Lcom/android/tools/idea/appinspection/inspector/api/service/FileService;)V", "jars", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/idea/appinspection/inspector/api/launch/ArtifactCoordinate;", "Lcom/android/tools/idea/appinspection/inspector/api/AppInspectorJar;", "scratchDir", "Ljava/nio/file/Path;", "getInspectorJar", "inspector", "populateJars", "", "inspectorJars", "", "unzipInspectorJarFromLibrary", "url", "libraryPath", "intellij.android.app-inspection.ide"})
public final class AppInspectorJarPaths {
    private final Path scratchDir;
    private final ConcurrentHashMap<ArtifactCoordinate, AppInspectorJar> jars;
    private final FileService fileService;

    @Nullable
    public final AppInspectorJar getInspectorJar(@NotNull ArtifactCoordinate inspector) {
        if (!this.jars.containsKey(inspector)) {
            Path cachePath = this.fileService.getOrCreateCacheDir("inspector-jars");
            Path jarPath = Paths.get(((Object)cachePath).toString(), inspector.getGroupId(), inspector.getArtifactId(), inspector.getVersion(), "inspector.jar");
            if (PathKt.exists((Path)jarPath)) {
                ((Map)this.jars).put(inspector, new AppInspectorJar("inspector.jar", ((Object)jarPath.getParent()).toString(), ((Object)jarPath.getParent()).toString()));
            }
        }
        return this.jars.get(inspector);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void populateJars(@NotNull Map<ArtifactCoordinate, ? extends Path> inspectorJars) {
        Map<ArtifactCoordinate, ? extends Path> $this$forEach$iv = inspectorJars;
        boolean $i$f$forEach = false;
        Map<ArtifactCoordinate, ? extends Path> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<ArtifactCoordinate, ? extends Path>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ArtifactCoordinate, ? extends Path> element$iv;
            Map.Entry<ArtifactCoordinate, ? extends Path> $dstr$url$path = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<ArtifactCoordinate, ? extends Path> entry = $dstr$url$path;
            boolean bl3 = false;
            ArtifactCoordinate artifactCoordinate = entry.getKey();
            entry = $dstr$url$path;
            bl3 = false;
            Path path2 = entry.getValue();
            try {
                void url;
                Path jarPath = this.unzipInspectorJarFromLibrary((ArtifactCoordinate)url, path2);
                ((Map)this.jars).put(url, new AppInspectorJar(((Object)jarPath.getFileName()).toString(), ((Object)jarPath.getParent()).toString(), ((Object)jarPath.getParent()).toString()));
            }
            catch (IOException e) {
                Logger.getInstance(AppInspectorJarPaths.class).error((Throwable)e);
            }
        }
    }

    @WorkerThread
    private final Path unzipInspectorJarFromLibrary(ArtifactCoordinate url, Path libraryPath) {
        ZipUtil.extract((File)libraryPath.toFile(), (File)this.scratchDir.toFile(), (FilenameFilter)unzipInspectorJarFromLibrary.1.INSTANCE);
        Path srcFile = this.scratchDir.resolve("META-INF").resolve("inspector.jar");
        Path destDir = this.fileService.getOrCreateCacheDir("inspector-jars").resolve(url.getGroupId()).resolve(url.getArtifactId()).resolve(url.getVersion());
        Files.createDirectories(destDir, new FileAttribute[0]);
        Path destFile = destDir.resolve("inspector.jar");
        Files.move(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
        return destFile;
    }

    public AppInspectorJarPaths(@NotNull FileService fileService) {
        this.fileService = fileService;
        this.scratchDir = this.fileService.getOrCreateTempDir("inspector-jars");
        this.jars = new ConcurrentHashMap();
    }
}

