/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.apk.debugging.ApkPackage;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ApkClass {
    @NotNull
    private final String myName;
    @NotNull
    private final String myFqn;
    @NotNull
    private final ApkPackage myParent;

    public ApkClass(@NotNull String name, @NotNull ApkPackage parent) {
        this.myName = name;
        this.myParent = parent;
        String parentFqn = this.myParent.getFqn();
        this.myFqn = parentFqn.isEmpty() ? this.myName : parentFqn + "." + this.myName;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getFqn() {
        return this.myFqn;
    }

    @NotNull
    public ApkPackage getParent() {
        return this.myParent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApkClass)) {
            return false;
        }
        ApkClass aClass = (ApkClass)o;
        return Objects.equals(this.myName, aClass.myName) && Objects.equals(this.myFqn, aClass.myFqn) && Objects.equals(this.myParent, aClass.myParent);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myFqn, this.myParent);
    }

    public String toString() {
        return this.myFqn;
    }
}

