/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.ui.ImagePanel;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

@UiThread
public class QrCodePanel {
    @NotNull
    private final Logger LOG;
    @NotNull
    private JBLabel myFirstLineLabel;
    @NotNull
    private JBLabel mySecondLineLabel;
    @NotNull
    private ImagePanel myQrCodePanel;
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myPairingStatusPanel;
    @NotNull
    private JPanel myPairingStatusIconPanel;
    @NotNull
    private JBLabel myPairingStatusIconLabel;
    @NotNull
    private AsyncProcessIcon myPairingStatusProcessIcon;
    @NotNull
    private JBLabel myPairingStatusLabel;
    @NotNull
    private JPanel myScanAnotherDevicePanel;
    @NotNull
    private JButton myScanAnotherDeviceButton;

    public QrCodePanel(final @NotNull Runnable scanAnotherDeviceRunnable) {
        this.$$$setupUI$$$();
        this.LOG = Logger.getInstance(QrCodePanel.class);
        this.myRootComponent.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myQrCodePanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusIconPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusIconLabel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusProcessIcon.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myScanAnotherDevicePanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myScanAnotherDeviceButton.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusLabel.setForeground(UIColors.PAIRING_STATUS_LABEL);
        this.myScanAnotherDeviceButton.setForeground(UIColors.PAIRING_STATUS_LABEL);
        this.myFirstLineLabel.setForeground(UIColors.PAIRING_HINT_LABEL);
        this.mySecondLineLabel.setForeground(UIColors.PAIRING_HINT_LABEL);
        this.myScanAnotherDeviceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scanAnotherDeviceRunnable.run();
            }
        });
    }

    private void createUIComponents() {
        this.myPairingStatusProcessIcon = new AsyncProcessIcon("pin code pairing progress");
    }

    @NotNull
    public JPanel getComponent() {
        return this.myRootComponent;
    }

    public void setQrCode(@NotNull QrCodeImage image) {
        this.LOG.info("New QR Code generated: " + image.getPairingString());
        this.myQrCodePanel.setImage((Image)image.getImage());
    }

    public void showQrCodePairingStarted() {
        this.myQrCodePanel.setActive(true);
        this.myPairingStatusLabel.setText(" ");
        this.myPairingStatusIconLabel.setVisible(false);
        this.myPairingStatusProcessIcon.setVisible(false);
        this.myScanAnotherDeviceButton.setVisible(false);
    }

    public void showQrCodePairingInProgress() {
        this.myQrCodePanel.setActive(false);
        this.myPairingStatusLabel.setText("Connected. Gathering device information.");
        this.myPairingStatusIconLabel.setVisible(false);
        this.myPairingStatusProcessIcon.setVisible(true);
        this.myScanAnotherDeviceButton.setVisible(false);
    }

    public void showQrCodePairingWaitForDevice() {
        this.showQrCodePairingInProgress();
    }

    public void showQrCodePairingSuccess(@NotNull AdbOnlineDevice device) {
        this.myQrCodePanel.setActive(false);
        this.myPairingStatusIconLabel.setVisible(true);
        this.myPairingStatusIconLabel.setIcon(StudioIcons.Common.SUCCESS);
        this.myPairingStatusProcessIcon.setVisible(false);
        this.myPairingStatusLabel.setText(device.getDisplayString() + " connected");
        this.myScanAnotherDeviceButton.setVisible(true);
    }

    public void showQrCodePairingError() {
        this.myQrCodePanel.setActive(false);
        this.myPairingStatusIconLabel.setVisible(true);
        this.myPairingStatusIconLabel.setIcon(StudioIcons.Common.ERROR);
        this.myPairingStatusProcessIcon.setVisible(false);
        this.myPairingStatusLabel.setText("An error occurred connecting device");
        this.myScanAnotherDeviceButton.setVisible(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JButton jButton;
        JPanel jPanel;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel2;
        JPanel jPanel3;
        ImagePanel imagePanel;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRootComponent = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(14, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, new Dimension(5, 15), null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("<html>To pair an <b>Android 11+</b> device<html>");
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, new Dimension(5, 4), null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("scan the QR code from your device");
        jPanel4.add((Component)jBLabel6, new GridConstraints(3, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, new Dimension(5, 5), null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(5, 0, 1, 1, 0, 1, 2, 1, new Dimension(5, 5), null, null));
        this.myQrCodePanel = imagePanel = new ImagePanel();
        jPanel4.add((Component)imagePanel, new GridConstraints(5, 1, 1, 1, 0, 3, 7, 7, new Dimension(100, 100), new Dimension(250, 250), null));
        Spacer spacer5 = new Spacer();
        jPanel4.add((Component)spacer5, new GridConstraints(5, 2, 1, 1, 0, 1, 2, 1, new Dimension(5, 5), null, null));
        Spacer spacer6 = new Spacer();
        jPanel4.add((Component)spacer6, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, new Dimension(5, 5), null, null));
        this.myPairingStatusPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(7, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myPairingStatusIconPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPairingStatusIconLabel = jBLabel4 = new JBLabel();
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myPairingStatusProcessIcon;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 3, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel2.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(2, 0), null));
        this.myPairingStatusLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("(some text)");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScanAnotherDevicePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(8, 0, 1, 3, 1, 1, 3, 2, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0), null, 0, 0, null, null));
        this.myScanAnotherDeviceButton = jButton = new JButton();
        jButton.setText("Scan another device");
        jPanel.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 0, 1, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel4.add((Component)spacer8, new GridConstraints(9, 1, 1, 1, 0, 2, 1, 0, new Dimension(0, 30), null, null));
        this.myFirstLineLabel = jBLabel2 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel2.getFont());
        if (font != null) {
            jBLabel2.setFont(font);
        }
        jBLabel2.setText("QR scanner available at:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(10, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel4.add((Component)spacer9, new GridConstraints(11, 1, 1, 1, 0, 2, 1, 0, new Dimension(0, 4), null, null));
        this.mySecondLineLabel = jBLabel = new JBLabel();
        jBLabel.setText("Developer options > Wireless debugging > Pair using QR code");
        jPanel4.add((Component)jBLabel, new GridConstraints(12, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel4.add((Component)spacer10, new GridConstraints(13, 1, 1, 1, 0, 2, 1, 0, new Dimension(5, 20), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootComponent;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

