/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.Slow;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/adb/wireless/QrCodeGenerator;", "", "()V", "encodeQrCode", "Lcom/google/zxing/common/BitMatrix;", "contents", "", "size", "", "encodeQrCodeToImage", "Ljava/awt/image/BufferedImage;", "backgroundColor", "Ljava/awt/Color;", "foregroundColor", "isIso88591", "", "intellij.android.adb"})
public final class QrCodeGenerator {
    public static final QrCodeGenerator INSTANCE;

    @JvmStatic
    @Slow
    @NotNull
    public static final BitMatrix encodeQrCode(@NotNull String contents, int size) throws WriterException {
        EnumMap hints = new EnumMap(EncodeHintType.class);
        if (!INSTANCE.isIso88591(contents)) {
            ((Map)hints).put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
        }
        return new MultiFormatWriter().encode(contents, BarcodeFormat.QR_CODE, size, size, (Map)hints);
    }

    public static /* synthetic */ BitMatrix encodeQrCode$default(String string, int n, int n2, Object object) throws WriterException {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return QrCodeGenerator.encodeQrCode(string, n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Slow
    @NotNull
    public static final BufferedImage encodeQrCodeToImage(@NotNull String contents, @NotNull Color backgroundColor, @NotNull Color foregroundColor) throws WriterException {
        BitMatrix bits = QrCodeGenerator.encodeQrCode$default(contents, 0, 2, null);
        BufferedImage img = new BufferedImage(bits.getWidth(), bits.getHeight(), 2);
        int n = 0;
        int n2 = bits.getHeight();
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = bits.getWidth();
            while (n3 < n4) {
                void x;
                img.setRGB((int)x, (int)y, bits.get((int)x, (int)y) ? foregroundColor.getRGB() : backgroundColor.getRGB());
                ++x;
            }
            ++y;
        }
        return img;
    }

    private final boolean isIso88591(String contents) {
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        return encoder.canEncode(contents);
    }

    private QrCodeGenerator() {
    }

    static {
        QrCodeGenerator qrCodeGenerator;
        INSTANCE = qrCodeGenerator = new QrCodeGenerator();
    }
}

