/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LineChartModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final List<RangedContinuousSeries> mySeries = new ArrayList<RangedContinuousSeries>();
    private boolean myFirstUpdate = true;

    @Override
    public void update(long elapsedNs) {
        HashMap<Range, Double> maxPerRangeObject = new HashMap<Range, Double>();
        for (RangedContinuousSeries ranged : this.mySeries) {
            Range range = ranged.getYRange();
            double yMax = -1.7976931348623157E308;
            List seriesList = ranged.getSeries();
            if (seriesList.isEmpty()) continue;
            for (SeriesData series : seriesList) {
                double value = ((Long)series.value).longValue();
                if (!(yMax < value)) continue;
                yMax = value;
            }
            Double rangeMax = (Double)maxPerRangeObject.get(range);
            if (rangeMax != null && !(yMax > rangeMax)) continue;
            maxPerRangeObject.put(range, yMax);
        }
        boolean changed = this.myFirstUpdate;
        for (Map.Entry entry : maxPerRangeObject.entrySet()) {
            Range range = (Range)entry.getKey();
            if (!(range.getMax() < (Double)entry.getValue())) continue;
            double max = this.myFirstUpdate ? (Double)entry.getValue() : Updater.lerp(range.getMax(), (Double)entry.getValue(), 0.99f, elapsedNs, (double)((float)((Double)entry.getValue() * (double)0.001f)));
            range.setMax(max);
            changed = true;
        }
        this.myFirstUpdate = false;
        if (changed) {
            this.changed(Aspect.LINE_CHART);
        }
    }

    public void addAll(@NotNull List<RangedContinuousSeries> series) {
        series.forEach(this::add);
    }

    public void add(@NotNull RangedContinuousSeries series) {
        this.mySeries.add(series);
        series.getXRange().addDependency(this).onChange(Range.Aspect.RANGE, () -> this.changed(Aspect.LINE_CHART));
    }

    public void remove(@NotNull RangedContinuousSeries series) {
        series.getXRange().removeDependencies(this);
        this.mySeries.remove(series);
    }

    @NotNull
    public List<RangedContinuousSeries> getSeries() {
        return this.mySeries;
    }

    public static enum Aspect {
        LINE_CHART;

    }
}

