/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.event.NestedScrollPaneMouseWheelListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class AdtUiUtils {
    public static final JBFont DEFAULT_FONT = JBUI.Fonts.label((float)10.0f);
    public static final JBFont EMPTY_TOOL_WINDOW_FONT = JBUI.Fonts.label((float)16.0f);
    public static final Color DEFAULT_FONT_COLOR = JBColor.foreground();
    public static final Color DEFAULT_BORDER_COLOR = StudioColorsKt.getBorder();
    public static final Border DEFAULT_TOP_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_LEFT_BORDER = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_BOTTOM_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_RIGHT_BORDER = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_HORIZONTAL_BORDERS = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_VERTICAL_BORDERS = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
    public static final GridBagConstraints GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);

    private AdtUiUtils() {
    }

    @NotNull
    public static String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace, float spaceThreshold) {
        return AdtUiUtils.shrinkToFit(text, s -> availableSpace > spaceThreshold && availableSpace >= (float)metrics.stringWidth((String)s));
    }

    @NotNull
    public static String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace) {
        return AdtUiUtils.shrinkToFit(text, metrics, availableSpace, 0.0f);
    }

    @NotNull
    public static String shrinkToFit(@NotNull String text, @NotNull Predicate<String> textFitPredicate) {
        if (textFitPredicate.test(text)) {
            return text;
        }
        if (!textFitPredicate.test("...")) {
            return "";
        }
        int smallestLength = 0;
        int largestLength = text.length();
        int bestLength = smallestLength;
        do {
            int midLength;
            if (textFitPredicate.test(text.substring(0, midLength = smallestLength + (largestLength - smallestLength) / 2) + "...")) {
                bestLength = midLength;
                smallestLength = midLength + 1;
                continue;
            }
            largestLength = midLength - 1;
        } while (smallestLength <= largestLength);
        return bestLength > 0 ? text.substring(0, bestLength) + "..." : "";
    }

    public static int unscale(int i) {
        return Math.round((float)i / JBUI.scale((float)1.0f));
    }

    public static Color overlayColor(int backgroundRgb, int foregroundRbg, float foregroundOpacity) {
        Color background = new Color(backgroundRgb);
        Color forground = new Color(foregroundRbg);
        return new Color(Math.round((float)background.getRed() * (1.0f - foregroundOpacity) + (float)forground.getRed() * foregroundOpacity), Math.round((float)background.getGreen() * (1.0f - foregroundOpacity) + (float)forground.getGreen() * foregroundOpacity), Math.round((float)background.getBlue() * (1.0f - foregroundOpacity) + (float)forground.getBlue() * foregroundOpacity));
    }

    public static boolean isActionKeyDown(@NotNull InputEvent event) {
        return SystemInfo.isMac ? event.isMetaDown() : event.isControlDown();
    }

    @JdkConstants.InputEventMask
    public static int getActionMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    public static String getActionKeyText() {
        if (SystemInfo.isMac) {
            Font labelFont = UIUtil.getLabelFont();
            return labelFont != null && labelFont.canDisplayUpTo("\u2318") == -1 ? "\u2318" : "Cmd";
        }
        return "Ctrl";
    }

    public static JComponent createHorizontalSeparator() {
        JPanel separatorWrapper = new JPanel(new TabularLayout("*", "*,Fit,*"));
        separatorWrapper.add((Component)new JSeparator(), new TabularLayout.Constraint(1, 0));
        Dimension size = new Dimension(1, 2);
        separatorWrapper.setMinimumSize(size);
        separatorWrapper.setPreferredSize(size);
        separatorWrapper.setOpaque(false);
        return separatorWrapper;
    }

    @NotNull
    public static JBScrollPane createNestedVScrollPane(@NotNull JComponent component) {
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        NestedScrollPaneMouseWheelListener.installOn((JScrollPane)scrollPane);
        return scrollPane;
    }
}

