/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.version;

import org.gradle.internal.impldep.org.sonatype.aether.util.version.GenericVersion;
import org.gradle.internal.impldep.org.sonatype.aether.util.version.GenericVersionConstraint;
import org.gradle.internal.impldep.org.sonatype.aether.util.version.GenericVersionRange;
import org.gradle.internal.impldep.org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.gradle.internal.impldep.org.sonatype.aether.version.Version;
import org.gradle.internal.impldep.org.sonatype.aether.version.VersionConstraint;
import org.gradle.internal.impldep.org.sonatype.aether.version.VersionRange;
import org.gradle.internal.impldep.org.sonatype.aether.version.VersionScheme;

public class GenericVersionScheme
implements VersionScheme {
    public Version parseVersion(String version) throws InvalidVersionSpecificationException {
        return new GenericVersion(version);
    }

    public VersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        return new GenericVersionRange(range);
    }

    public VersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        GenericVersionConstraint result = new GenericVersionConstraint();
        String process = constraint;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            VersionRange range = this.parseVersionRange(process.substring(0, index + 1));
            result.addRange(range);
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0 && !result.getRanges().isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process);
        }
        if (result.getRanges().isEmpty()) {
            result.setVersion(this.parseVersion(constraint));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

