/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleImpl
extends ResourceBundle {
    @NotNull
    private final SmartPsiElementPointer<PsiFile> myDefaultPropertiesFile;
    private boolean myValid = true;

    public ResourceBundleImpl(@NotNull PropertiesFile defaultPropertiesFile) {
        this.myDefaultPropertiesFile = SmartPointerManager.getInstance((Project)defaultPropertiesFile.getProject()).createSmartPsiElementPointer((PsiElement)defaultPropertiesFile.getContainingFile());
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        return PropertiesImplUtil.getResourceBundleFiles(this.getDefaultPropertiesFile());
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        return Objects.requireNonNull(PropertiesImplUtil.getPropertiesFile((PsiFile)this.myDefaultPropertiesFile.getElement()));
    }

    @Override
    @NotNull
    public String getBaseName() {
        return ResourceBundleManager.getInstance(this.getProject()).getBaseName((PsiFile)Objects.requireNonNull(this.myDefaultPropertiesFile.getElement()));
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        return this.getDefaultPropertiesFile().getVirtualFile().getParent();
    }

    @Override
    public boolean isValid() {
        return this.myValid && PropertiesImplUtil.getPropertiesFile((PsiFile)this.myDefaultPropertiesFile.getElement()) != null;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }
}

