/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unsorted;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unsorted.AlphaUnsortedPropertiesFileInspectionSuppressor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AlphaUnsortedPropertiesFileInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AlphaUnsortedPropertiesFileInspection.class);
    private static final String MESSAGE_TEMPLATE_WHOLE_RESOURCE_BUNDLE = "Property keys of resource bundle '%s' aren't alphabetically sorted";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
                if (!(propertiesFile instanceof PropertiesFileImpl)) {
                    return;
                }
                for (AlphaUnsortedPropertiesFileInspectionSuppressor filter : (AlphaUnsortedPropertiesFileInspectionSuppressor[])AlphaUnsortedPropertiesFileInspectionSuppressor.EP_NAME.getExtensions()) {
                    if (!filter.suppressInspectionFor(propertiesFile)) continue;
                    return;
                }
                ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
                String resourceBundleBaseName = resourceBundle.getBaseName();
                if (!AlphaUnsortedPropertiesFileInspection.isResourceBundleAlphaSortedExceptOneFile(resourceBundle, propertiesFile)) {
                    List<PropertiesFile> allFiles = resourceBundle.getPropertiesFiles();
                    holder.registerProblem((PsiElement)file, String.format(AlphaUnsortedPropertiesFileInspection.MESSAGE_TEMPLATE_WHOLE_RESOURCE_BUNDLE, resourceBundleBaseName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new PropertiesSorterQuickFix(allFiles.toArray(new PropertiesFile[0]))});
                    return;
                }
                if (!propertiesFile.isAlphaSorted()) {
                    holder.registerProblem((PsiElement)file, "Properties file is alphabetically unsorted", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new PropertiesSorterQuickFix(new PropertiesFile[]{propertiesFile})});
                }
            }
        };
    }

    private static boolean isResourceBundleAlphaSortedExceptOneFile(@NotNull ResourceBundle resourceBundle, @NotNull PropertiesFile exceptedFile) {
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (!(file instanceof PropertiesFileImpl)) {
                return true;
            }
            if (file.equals(exceptedFile) || file.isAlphaSorted()) continue;
            return false;
        }
        return true;
    }

    private static void sortPropertiesFile(PropertiesFile file) {
        ArrayList<IProperty> properties = new ArrayList<IProperty>(file.getProperties());
        properties.sort((p1, p2) -> Comparing.compare((Object)p1.getKey(), (Object)p2.getKey(), (Comparator)String.CASE_INSENSITIVE_ORDER));
        char delimiter = PropertiesCodeStyleSettings.getInstance(file.getProject()).getDelimiter();
        StringBuilder rawText = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            String key;
            IProperty property = (IProperty)properties.get(i);
            String value = property.getValue();
            String commentAboveProperty = property.getDocCommentText();
            if (commentAboveProperty != null) {
                rawText.append(commentAboveProperty).append("\n");
            }
            if ((key = property.getKey()) == null) continue;
            String propertyText = PropertiesElementFactory.getPropertyText(key, value != null ? value : "", Character.valueOf(delimiter), null, PropertyKeyValueFormat.FILE);
            rawText.append(propertyText);
            if (i == properties.size() - 1) continue;
            rawText.append("\n");
        }
        PropertiesFile fakeFile = PropertiesElementFactory.createPropertiesFile(file.getProject(), rawText.toString());
        PropertiesList propertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)file.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(propertiesList != null);
        PropertiesList fakePropertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)fakeFile.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(fakePropertiesList != null);
        propertiesList.replace((PsiElement)fakePropertiesList);
    }

    @NotNull
    public String getShortName() {
        return "AlphaUnsortedPropertiesFile";
    }

    private static class PropertiesSorterQuickFix
    implements LocalQuickFix {
        private final PropertiesFile[] myFilesToSort;

        private PropertiesSorterQuickFix(PropertiesFile ... toSort) {
            this.myFilesToSort = toSort;
        }

        @NotNull
        public String getFamilyName() {
            return "Sort resource bundle files";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            boolean force = this.myFilesToSort.length == 1;
            for (PropertiesFile file : this.myFilesToSort) {
                if (!force && file.isAlphaSorted()) continue;
                AlphaUnsortedPropertiesFileInspection.sortPropertiesFile(file);
            }
        }
    }
}

