/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle.roots;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotifications;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupportBase;
import org.jetbrains.kotlin.idea.core.script.configuration.ScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.idea.core.util.EDT;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleImportHelperKt;
import org.jetbrains.kotlin.idea.scripting.gradle.LastModifiedFiles;
import org.jetbrains.kotlin.idea.scripting.gradle.UtilsKt;
import org.jetbrains.kotlin.idea.scripting.gradle.importing.KotlinDslGradleBuildSync;
import org.jetbrains.kotlin.idea.scripting.gradle.importing.KotlinDslScriptModel;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootData;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootDataSerializer;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootIndex;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootKt;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleScriptInfo;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.Imported;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.Legacy;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.New;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.StandaloneScriptsUpdater;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 d2\u00020\u00012\u00020\u0002:\u0001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020!H\u0016J\b\u0010)\u001a\u00020!H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u00132\b\b\u0002\u0010/\u001a\u000200J\u0012\u00101\u001a\u0004\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u0013H\u0016J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u0013H\u0016J\u0010\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00072\u0006\u00108\u001a\u00020;H\u0016J\u000e\u0010<\u001a\u00020\u00072\u0006\u00108\u001a\u000209J\u001a\u0010=\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010>\u001a\u00020\u0013H\u0002J\u0016\u0010?\u001a\u00020!2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00130AH\u0002J\u0018\u0010B\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00132\b\b\u0002\u0010C\u001a\u00020\u0007J\u0018\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020$H\u0002J\u001c\u0010G\u001a\u0004\u0018\u00010\u001d2\u0006\u0010H\u001a\u00020\u00132\b\u0010>\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010I\u001a\u00020!2\u0006\u0010H\u001a\u00020\u0013H\u0002J\u0010\u0010J\u001a\u00020!2\u0006\u0010H\u001a\u00020\u0013H\u0002J\u000e\u0010K\u001a\u00020!2\u0006\u0010.\u001a\u00020\u0013JA\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020\u00132\b\b\u0002\u0010O\u001a\u00020P2#\u0010Q\u001a\u001f\u0012\u0013\u0012\u001109\u00a2\u0006\f\bS\u0012\b\bT\u0012\u0004\b\b(U\u0012\u0006\u0012\u0004\u0018\u00010$0RH\u0002J\u001a\u0010V\u001a\u0004\u0018\u00010M2\u0006\u0010&\u001a\u00020'2\u0006\u0010>\u001a\u00020\u0013H\u0002J\u000e\u0010W\u001a\u00020!2\u0006\u0010X\u001a\u00020YJ\u0010\u0010Z\u001a\u00020!2\u0006\u00108\u001a\u000209H\u0002J$\u0010[\u001a\u00020!2\b\b\u0002\u0010\\\u001a\u00020\u00072\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070RJ\u001a\u0010^\u001a\u0004\u0018\u00010M2\u0006\u0010_\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020YH\u0002J\u001f\u0010`\u001a\u00020!2\u0017\u0010W\u001a\u0013\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020!0R\u00a2\u0006\u0002\bbJ\u0016\u0010c\u001a\u00020\u0007*\u00020\u001d2\b\u0010>\u001a\u0004\u0018\u00010\u0013H\u0002R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006e"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsManager;", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/ScriptingSupport;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "manager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "getManager", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "modifiedFiles", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "modifiedFilesCheckScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updater", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "getUpdater", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "actualizeBuildRoot", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;", "workingDir", "gradleVersion", "add", "", "newRoot", "addFromSettings", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootData;", "data", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "afterUpdate", "checkModifiedFiles", "collectConfigurations", "builder", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "fileChanged", "filePath", "ts", "", "getGradleProjectSettings", "getScriptFirstSeenTs", "path", "getScriptInfo", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleScriptInfo;", "localPath", "isApplicable", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isConfigurationLoadingInProgress", "Lorg/jetbrains/kotlin/psi/KtFile;", "isConfigurationOutOfDate", "loadLinkedRoot", "version", "loadStandaloneScriptConfigurations", "files", "", "markImportingInProgress", "inProgress", "merge", "old", "new", "reloadBuildRoot", "rootPath", "remove", "removeData", "scheduleModifiedFilesCheck", "tryCreateImportedRoot", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/Imported;", "externalProjectPath", "lastModifiedFiles", "Lorg/jetbrains/kotlin/idea/scripting/gradle/LastModifiedFiles;", "dataProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "buildRoot", "tryLoadFromFsCache", "update", "sync", "Lorg/jetbrains/kotlin/idea/scripting/gradle/importing/KotlinDslGradleBuildSync;", "updateFloatingAction", "updateNotifications", "restartAnalyzer", "shouldUpdatePath", "updateRoot", "oldRoot", "updateStandaloneScripts", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/StandaloneScriptsUpdater;", "Lkotlin/ExtensionFunctionType;", "checkActual", "Companion", "kotlin.gradle.gradle-idea"})
public final class GradleBuildRootsManager
extends GradleBuildRootsLocator
implements ScriptingSupport {
    private boolean enabled;
    private final AtomicBoolean modifiedFilesCheckScheduled;
    private final ConcurrentLinkedQueue<String> modifiedFiles;
    @NotNull
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final CompositeScriptConfigurationManager getManager() {
        ScriptConfigurationManager scriptConfigurationManager = ScriptConfigurationManager.Companion.getInstance(this.project);
        if (scriptConfigurationManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager");
        }
        return (CompositeScriptConfigurationManager)scriptConfigurationManager;
    }

    private final ScriptClassRootsUpdater getUpdater() {
        return this.getManager().getUpdater();
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.getRoots().getList());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradleBuildRoot it = (GradleBuildRoot)element$iv;
                boolean bl = false;
                this.reloadBuildRoot(it.getPathPrefix(), null);
            }
        }
    }

    public boolean isApplicable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot = this.findScriptBuildRoot(file);
        if (scriptUnderRoot == null) {
            return false;
        }
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot2 = scriptUnderRoot;
        if (scriptUnderRoot2.getNearest() instanceof Legacy) {
            return false;
        }
        GradleBuildRootIndex gradleBuildRootIndex = this.getRoots();
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return !gradleBuildRootIndex.isStandaloneScript(string);
    }

    public boolean isConfigurationLoadingInProgress(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = file.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.originalFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.originalFile.virtualFile");
        Object object = this.findScriptBuildRoot(virtualFile);
        if (object == null || (object = ((GradleBuildRootsLocator.ScriptUnderRoot)object).getNearest()) == null) {
            return false;
        }
        return ((GradleBuildRoot)object).isImportingInProgress();
    }

    public final boolean isConfigurationOutOfDate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GradleScriptInfo gradleScriptInfo = this.getScriptInfo(file);
        if (gradleScriptInfo == null) {
            return false;
        }
        GradleScriptInfo script = gradleScriptInfo;
        if (script.getBuildRoot().isImportingInProgress()) {
            return false;
        }
        return !CachedConfigurationInputs.DefaultImpls.isUpToDate$default((CachedConfigurationInputs)script.getModel().getInputs(), (Project)this.project, (VirtualFile)file, null, (int)4, null);
    }

    public void collectConfigurations(@NotNull ScriptClassRootsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Iterable $this$forEach$iv = this.getRoots().getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot root = (GradleBuildRoot)element$iv;
            boolean bl = false;
            if (!(root instanceof Imported)) continue;
            ((Imported)root).collectConfigurations(builder);
        }
    }

    public void afterUpdate() {
        Iterable $this$forEach$iv = this.getRoots().getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot root = (GradleBuildRoot)element$iv;
            boolean bl = false;
            if (!root.getImporting().compareAndSet(GradleBuildRoot.ImportingStatus.updatingCaches, GradleBuildRoot.ImportingStatus.updated)) continue;
            GradleBuildRootsManager.updateNotifications$default(this, false, (Function1)new Function1<String, Boolean>(root){
                final /* synthetic */ GradleBuildRoot $root;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return StringsKt.startsWith$default((String)it, (String)this.$root.getPathPrefix(), (boolean)false, (int)2, null);
                }
                {
                    this.$root = gradleBuildRoot;
                    super(1);
                }
            }, 1, null);
        }
    }

    @Override
    @Nullable
    public GradleScriptInfo getScriptInfo(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        ScriptClassRootsCache.LightScriptInfo lightScriptInfo = this.getManager().getLightScriptInfo(localPath);
        if (!(lightScriptInfo instanceof GradleScriptInfo)) {
            lightScriptInfo = null;
        }
        return (GradleScriptInfo)lightScriptInfo;
    }

    @Override
    public long getScriptFirstSeenTs(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path nioPath = FileSystems.getDefault().getPath(path, new String[0]);
        Object object = Files.readAttributes(nioPath, BasicFileAttributes.class, new LinkOption[0]);
        return object != null && (object = object.creationTime()) != null ? ((FileTime)object).toMillis() : Long.MAX_VALUE;
    }

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        GradleBuildRoot gradleBuildRoot = this.findAffectedFileRoot(filePath);
        if (gradleBuildRoot != null) {
            gradleBuildRoot.fileChanged(filePath, ts);
        }
        this.scheduleModifiedFilesCheck(filePath);
    }

    public static /* synthetic */ void fileChanged$default(GradleBuildRootsManager gradleBuildRootsManager, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        gradleBuildRootsManager.fileChanged(string, l);
    }

    public final void markImportingInProgress(@NotNull String workingDir, boolean inProgress) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Object object = this.actualizeBuildRoot(workingDir, null);
        if (object != null && (object = ((GradleBuildRoot)object).getImporting()) != null) {
            ((AtomicReference)object).set(inProgress ? GradleBuildRoot.ImportingStatus.importing : GradleBuildRoot.ImportingStatus.updated);
        }
        GradleBuildRootsManager.updateNotifications$default(this, false, (Function1)new Function1<String, Boolean>(workingDir){
            final /* synthetic */ String $workingDir;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$workingDir, (boolean)false, (int)2, null);
            }
            {
                this.$workingDir = string;
                super(1);
            }
        }, 1, null);
    }

    public static /* synthetic */ void markImportingInProgress$default(GradleBuildRootsManager gradleBuildRootsManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        gradleBuildRootsManager.markImportingInProgress(string, bl);
    }

    public final void update(@NotNull KotlinDslGradleBuildSync sync) {
        Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
        GradleBuildRoot gradleBuildRoot = this.actualizeBuildRoot(sync.getWorkingDir(), sync.getGradleVersion());
        if (gradleBuildRoot == null) {
            return;
        }
        GradleBuildRoot oldRoot = gradleBuildRoot;
        try {
            Imported newRoot2 = this.updateRoot(oldRoot, sync);
            if (newRoot2 == null) {
                this.markImportingInProgress(sync.getWorkingDir(), false);
                return;
            }
            this.add(newRoot2);
        }
        catch (Exception e) {
            this.markImportingInProgress(sync.getWorkingDir(), false);
            return;
        }
    }

    private final Imported updateRoot(GradleBuildRoot oldRoot, KotlinDslGradleBuildSync sync) {
        if (sync.getModels().isEmpty() && oldRoot instanceof Imported && ((Imported)oldRoot).getData().getModels().isEmpty()) {
            return null;
        }
        if (oldRoot instanceof Legacy) {
            return null;
        }
        ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)((Function0)new Function0<String>(sync){
            final /* synthetic */ KotlinDslGradleBuildSync $sync;

            @NotNull
            public final String invoke() {
                return "gradle project info after import: " + this.$sync;
            }
            {
                this.$sync = kotlinDslGradleBuildSync;
                super(0);
            }
        }), (int)1, null);
        String gradleHome = sync.getGradleHome();
        if (gradleHome == null) {
            ScriptUtilsKt.scriptingInfoLog((String)("Cannot find valid gradle home for " + sync.getGradleHome() + " with version = " + sync.getGradleVersion() + ", script models cannot be saved"));
            return null;
        }
        oldRoot.getImporting().set(GradleBuildRoot.ImportingStatus.updatingCaches);
        ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)((Function0)new Function0<String>(sync){
            final /* synthetic */ KotlinDslGradleBuildSync $sync;

            @NotNull
            public final String invoke() {
                return "save script models after import: " + this.$sync.getModels();
            }
            {
                this.$sync = kotlinDslGradleBuildSync;
                super(0);
            }
        }), (int)1, null);
        GradleBuildRootData newData = new GradleBuildRootData(sync.getTs(), (Collection<String>)sync.getProjectRoots(), gradleHome, sync.getJavaHome(), (Collection<KotlinDslScriptModel>)sync.getModels());
        GradleBuildRootData mergedData = sync.getFailed() && oldRoot instanceof Imported ? this.merge(((Imported)oldRoot).getData(), newData) : newData;
        Imported imported = this.tryCreateImportedRoot(sync.getWorkingDir(), new LastModifiedFiles(null, null, 3, null), (Function1<? super VirtualFile, GradleBuildRootData>)((Function1)new Function1<VirtualFile, GradleBuildRootData>(mergedData){
            final /* synthetic */ GradleBuildRootData $mergedData;

            @Nullable
            public final GradleBuildRootData invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$mergedData;
            }
            {
                this.$mergedData = gradleBuildRootData;
                super(1);
            }
        }));
        if (imported == null) {
            return null;
        }
        Imported newRoot2 = imported;
        VirtualFile virtualFile = newRoot2.getDir();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile buildRootDir = virtualFile;
        GradleBuildRootDataSerializer.INSTANCE.write(buildRootDir, mergedData);
        newRoot2.saveLastModifiedFiles();
        return newRoot2;
    }

    /*
     * WARNING - void declaration
     */
    private final GradleBuildRootData merge(GradleBuildRootData old, GradleBuildRootData gradleBuildRootData) {
        String string;
        void var12_15;
        void destination$iv;
        Iterable $this$associateByTo$iv;
        Set roots = CollectionsKt.toMutableSet((Iterable)old.getProjectRoots());
        roots.addAll(gradleBuildRootData.getProjectRoots());
        Iterable iterable = old.getModels();
        boolean bl = false;
        Map map = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv2 : $this$associateByTo$iv) {
            void it;
            KotlinDslScriptModel kotlinDslScriptModel = (KotlinDslScriptModel)element$iv2;
            var12_15 = destination$iv;
            boolean bl2 = false;
            string = it.getFile();
            var12_15.put(string, element$iv2);
        }
        void models = destination$iv;
        $this$associateByTo$iv = gradleBuildRootData.getModels();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            Object element$iv2;
            element$iv2 = (KotlinDslScriptModel)element$iv;
            var12_15 = models;
            boolean bl3 = false;
            string = it.getFile();
            var12_15.put(string, element$iv);
        }
        return new GradleBuildRootData(gradleBuildRootData.getImportTs(), roots, gradleBuildRootData.getGradleHome(), gradleBuildRootData.getJavaHome(), models.values());
    }

    public final void scheduleModifiedFilesCheck(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.modifiedFiles.add(filePath);
        if (this.modifiedFilesCheckScheduled.compareAndSet(false, true)) {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)this.project), (Runnable)new Runnable(this){
                final /* synthetic */ GradleBuildRootsManager this$0;

                public final void run() {
                    if (GradleBuildRootsManager.access$getModifiedFilesCheckScheduled$p(this.this$0).compareAndSet(true, false)) {
                        GradleBuildRootsManager.access$checkModifiedFiles(this.this$0);
                    }
                }
                {
                    this.this$0 = gradleBuildRootsManager;
                }
            });
        }
    }

    private final void checkModifiedFiles() {
        this.updateNotifications(false, (Function1<? super String, Boolean>)((Function1)checkModifiedFiles.1.INSTANCE));
        Iterable $this$forEach$iv = this.getRoots().getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot it = (GradleBuildRoot)element$iv;
            boolean bl = false;
            it.saveLastModifiedFiles();
        }
        while (this.modifiedFiles.poll() != null) {
            String file;
            String buildDir = this.findGradleWrapperPropertiesBuildDir(file);
            if (buildDir == null) continue;
            this.actualizeBuildRoot(buildDir, null);
        }
    }

    public final void updateStandaloneScripts(@NotNull Function1<? super StandaloneScriptsUpdater, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        StandaloneScriptsUpdater.Changes changes = StandaloneScriptsUpdater.Companion.collectChanges(this.getRoots(), update);
        GradleBuildRootsManager.updateNotifications$default(this, false, (Function1)new Function1<String, Boolean>(changes){
            final /* synthetic */ StandaloneScriptsUpdater.Changes $changes;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$changes.getNew().contains(it) || this.$changes.getRemoved().contains(it);
            }
            {
                this.$changes = changes;
                super(1);
            }
        }, 1, null);
        this.loadStandaloneScriptConfigurations(changes.getNew());
    }

    private final GradleProjectSettings getGradleProjectSettings(String workingDir) {
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (abstractExternalSystemSettings == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.gradle.settings.GradleSettings");
        }
        return (GradleProjectSettings)((GradleSettings)abstractExternalSystemSettings).getLinkedProjectSettings(workingDir);
    }

    private final GradleBuildRoot actualizeBuildRoot(String workingDir, String gradleVersion) {
        GradleProjectSettings actualSettings = this.getGradleProjectSettings(workingDir);
        GradleBuildRoot buildRoot = this.getBuildRootByWorkingDir(workingDir);
        String string = gradleVersion;
        if (string == null) {
            GradleProjectSettings gradleProjectSettings = actualSettings;
            if (gradleProjectSettings != null) {
                GradleProjectSettings gradleProjectSettings2 = gradleProjectSettings;
                boolean bl = false;
                boolean bl2 = false;
                GradleProjectSettings it = gradleProjectSettings2;
                boolean bl3 = false;
                string = GradleImportHelperKt.getGradleVersion(this.project, it);
            } else {
                string = null;
            }
        }
        String version = string;
        return buildRoot != null ? (!this.checkActual(buildRoot, version) ? this.reloadBuildRoot(workingDir, version) : buildRoot) : (actualSettings != null && version != null ? this.loadLinkedRoot(actualSettings, version) : null);
    }

    private final boolean checkActual(GradleBuildRoot $this$checkActual, String version) {
        if (version == null) {
            return false;
        }
        boolean knownAsSupported = !($this$checkActual instanceof Legacy);
        boolean shouldBeSupported = UtilsKt.kotlinDslScriptsModelImportSupported(version);
        return knownAsSupported == shouldBeSupported;
    }

    private final GradleBuildRoot reloadBuildRoot(String rootPath, String version) {
        GradleProjectSettings settings = this.getGradleProjectSettings(rootPath);
        if (settings == null) {
            this.remove(rootPath);
            return null;
        }
        String string = version;
        if (string == null) {
            string = GradleImportHelperKt.getGradleVersion(this.project, settings);
        }
        String gradleVersion = string;
        GradleBuildRoot newRoot2 = this.loadLinkedRoot(settings, gradleVersion);
        this.add(newRoot2);
        return newRoot2;
    }

    private final GradleBuildRoot loadLinkedRoot(GradleProjectSettings settings, String version) {
        GradleBuildRoot gradleBuildRoot;
        if (!this.enabled) {
            return new Legacy(settings, null, 2, null);
        }
        boolean supported = UtilsKt.kotlinDslScriptsModelImportSupported(version);
        if (supported) {
            Imported imported = this.tryLoadFromFsCache(settings, version);
            gradleBuildRoot = imported != null ? (GradleBuildRoot)imported : (GradleBuildRoot)new New(settings, null, 2, null);
        } else {
            gradleBuildRoot = new Legacy(settings, null, 2, null);
        }
        return gradleBuildRoot;
    }

    static /* synthetic */ GradleBuildRoot loadLinkedRoot$default(GradleBuildRootsManager gradleBuildRootsManager, GradleProjectSettings gradleProjectSettings, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = GradleImportHelperKt.getGradleVersion(gradleBuildRootsManager.project, gradleProjectSettings);
        }
        return gradleBuildRootsManager.loadLinkedRoot(gradleProjectSettings, string);
    }

    private final Imported tryLoadFromFsCache(GradleProjectSettings settings, String version) {
        String string = settings.getExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settings.externalProjectPath");
        return GradleBuildRootsManager.tryCreateImportedRoot$default(this, string, null, (Function1)new Function1<VirtualFile, GradleBuildRootData>(this, version, settings){
            final /* synthetic */ GradleBuildRootsManager this$0;
            final /* synthetic */ String $version;
            final /* synthetic */ GradleProjectSettings $settings;

            @Nullable
            public final GradleBuildRootData invoke(@NotNull VirtualFile it) {
                GradleBuildRootData gradleBuildRootData;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GradleBuildRootData gradleBuildRootData2 = GradleBuildRootDataSerializer.INSTANCE.read(it);
                if (gradleBuildRootData2 != null) {
                    GradleBuildRootData gradleBuildRootData3 = gradleBuildRootData2;
                    boolean bl = false;
                    boolean bl2 = false;
                    GradleBuildRootData data = gradleBuildRootData3;
                    boolean bl3 = false;
                    String gradleHome = data.getGradleHome();
                    CharSequence charSequence = gradleHome;
                    boolean bl4 = false;
                    gradleBuildRootData = !StringsKt.isBlank((CharSequence)charSequence) && Intrinsics.areEqual((Object)GradleInstallationManager.getGradleVersion((String)gradleHome), (Object)this.$version) ^ true ? null : GradleBuildRootsManager.access$addFromSettings(this.this$0, data, this.$settings);
                } else {
                    gradleBuildRootData = null;
                }
                return gradleBuildRootData;
            }
            {
                this.this$0 = gradleBuildRootsManager;
                this.$version = string;
                this.$settings = gradleProjectSettings;
                super(1);
            }
        }, 2, null);
    }

    private final GradleBuildRootData addFromSettings(GradleBuildRootData data, GradleProjectSettings settings) {
        Set set = CollectionsKt.toSet((Iterable)data.getProjectRoots());
        Set set2 = settings.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"settings.modules");
        return GradleBuildRootData.copy$default(data, 0L, SetsKt.plus((Set)set, (Iterable)set2), null, null, null, 29, null);
    }

    private final Imported tryCreateImportedRoot(String externalProjectPath, LastModifiedFiles lastModifiedFiles, Function1<? super VirtualFile, GradleBuildRootData> dataProvider) {
        try {
            VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(externalProjectPath, new String[0]), (boolean)true);
            if (virtualFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.findFile(Paths.g\u2026th), true) ?: return null");
            VirtualFile buildRoot = virtualFile;
            GradleBuildRootData gradleBuildRootData = (GradleBuildRootData)dataProvider.invoke((Object)buildRoot);
            if (gradleBuildRootData == null) {
                return null;
            }
            GradleBuildRootData data = gradleBuildRootData;
            return new Imported(externalProjectPath, data, lastModifiedFiles);
        }
        catch (Exception e) {
            ScriptUtilsKt.scriptingErrorLog((String)("Cannot load script configurations from file attributes for " + externalProjectPath), (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Imported tryCreateImportedRoot$default(GradleBuildRootsManager gradleBuildRootsManager, String string, LastModifiedFiles lastModifiedFiles, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            LastModifiedFiles lastModifiedFiles2 = GradleBuildRootKt.loadLastModifiedFiles(string);
            if (lastModifiedFiles2 == null) {
                lastModifiedFiles2 = new LastModifiedFiles(null, null, 3, null);
            }
            lastModifiedFiles = lastModifiedFiles2;
        }
        return gradleBuildRootsManager.tryCreateImportedRoot(string, lastModifiedFiles, (Function1<? super VirtualFile, GradleBuildRootData>)function1);
    }

    private final void add(GradleBuildRoot newRoot2) {
        GradleBuildRoot old = this.getRoots().add(newRoot2);
        if (old instanceof Imported && !(newRoot2 instanceof Imported)) {
            this.removeData(old.getPathPrefix());
        }
        if (!(old instanceof Legacy) || !(newRoot2 instanceof Legacy)) {
            this.getUpdater().invalidateAndCommit();
        }
        GradleBuildRootsManager.updateNotifications$default(this, false, (Function1)new Function1<String, Boolean>(newRoot2){
            final /* synthetic */ GradleBuildRoot $newRoot;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$newRoot.getPathPrefix(), (boolean)false, (int)2, null);
            }
            {
                this.$newRoot = gradleBuildRoot;
                super(1);
            }
        }, 1, null);
    }

    private final void remove(String rootPath) {
        GradleBuildRoot removed = this.getRoots().remove(rootPath);
        if (removed instanceof Imported) {
            this.removeData(rootPath);
            this.getUpdater().invalidateAndCommit();
        }
        GradleBuildRootsManager.updateNotifications$default(this, false, (Function1)new Function1<String, Boolean>(rootPath){
            final /* synthetic */ String $rootPath;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$rootPath, (boolean)false, (int)2, null);
            }
            {
                this.$rootPath = string;
                super(1);
            }
        }, 1, null);
    }

    private final void removeData(String rootPath) {
        VirtualFile buildRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (buildRoot != null) {
            GradleBuildRootDataSerializer.INSTANCE.remove(buildRoot);
            LastModifiedFiles.Companion.remove(buildRoot);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void updateNotifications(boolean restartAnalyzer, @NotNull Function1<? super String, Boolean> shouldUpdatePath) {
        Intrinsics.checkNotNullParameter(shouldUpdatePath, (String)"shouldUpdatePath");
        if (!this.project.isOpen()) {
            return;
        }
        v0 = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FileEditorManager.getInstance(project)");
        v1 = v0.getSelectedEditor();
        if (v1 != null && (v1 = v1.getFile()) != null) {
            var3_3 = v1;
            var4_4 = false;
            var5_6 = false;
            it = var3_3;
            $i$a$-let-GradleBuildRootsManager$updateNotifications$1 = false;
            v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            v3 = v2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.path");
            if (((Boolean)shouldUpdatePath.invoke((Object)v3)).booleanValue()) {
                v4 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it.path");
                if (this.maybeAffectedGradleProjectFile(v4)) {
                    this.updateFloatingAction((VirtualFile)it);
                }
            }
        }
        v5 = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"FileEditorManager.getInstance(project)");
        v6 = v5.getSelectedEditors();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"FileEditorManager.getIns\u2026(project).selectedEditors");
        var4_5 = v6;
        $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var11_14 = $this$forEach$iv$iv$iv;
        var12_15 = ((void)var11_14).length;
        for (var13_16 = 0; var13_16 < var12_15; ++var13_16) {
            element$iv$iv = element$iv$iv$iv = var11_14[var13_16];
            $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
            it = element$iv$iv;
            $i$a$-mapNotNull-GradleBuildRootsManager$updateNotifications$openedScripts$1 = false;
            v7 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
            if (v7.getFile() == null) continue;
            var20_23 = false;
            var21_24 = false;
            it$iv$iv = var19_22;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            $i$a$-filter-GradleBuildRootsManager$updateNotifications$openedScripts$2 = false;
            v8 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
            v9 = v8.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"it.path");
            if (!((Boolean)shouldUpdatePath.invoke((Object)v9)).booleanValue()) ** GOTO lbl-1000
            v10 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"it.path");
            if (this.maybeAffectedGradleProjectFile(v10)) {
                v11 = true;
            } else lbl-1000:
            // 2 sources

            {
                v11 = false;
            }
            if (!v11) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        openedScripts = (List)destination$iv$iv;
        if (openedScripts.isEmpty()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)EDT.INSTANCE.invoke(this.project), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, openedScripts, restartAnalyzer, null){
            int label;
            final /* synthetic */ GradleBuildRootsManager this$0;
            final /* synthetic */ List $openedScripts;
            final /* synthetic */ boolean $restartAnalyzer;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.this$0.getProject().isDisposed()) {
                            return Unit.INSTANCE;
                        }
                        Iterable $this$forEach$iv = this.$openedScripts;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            PsiFile ktFile;
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl = false;
                            VirtualFile virtualFile = it;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                            if (this.this$0.isApplicable(virtualFile)) {
                                DefaultScriptingSupport.Companion.getInstance(this.this$0.getProject()).ensureNotificationsRemoved(it);
                            }
                            if (this.$restartAnalyzer && (ktFile = PsiManager.getInstance((Project)this.this$0.getProject()).findFile(it)) != null) {
                                DaemonCodeAnalyzer.getInstance((Project)this.this$0.getProject()).restart(ktFile);
                            }
                            EditorNotifications.getInstance((Project)this.this$0.getProject()).updateAllNotifications();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = gradleBuildRootsManager;
                this.$openedScripts = list;
                this.$restartAnalyzer = bl;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void updateNotifications$default(GradleBuildRootsManager gradleBuildRootsManager, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        gradleBuildRootsManager.updateNotifications(bl, (Function1<? super String, Boolean>)function1);
    }

    private final void updateFloatingAction(VirtualFile file) {
        if (this.isConfigurationOutOfDate(file)) {
            GradleImportHelperKt.scriptConfigurationsNeedToBeUpdated(this.project, file);
        } else {
            GradleImportHelperKt.scriptConfigurationsAreUpToDate(this.project);
        }
    }

    private final void loadStandaloneScriptConfigurations(Set<String> files) {
        ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this, files){
            final /* synthetic */ GradleBuildRootsManager this$0;
            final /* synthetic */ Set $files;

            public final void invoke() {
                Iterable $this$forEach$iv = this.$files;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtFile ktFile;
                    String it = (String)element$iv;
                    boolean bl = false;
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
                    if (virtualFile == null) continue;
                    PsiFile psiFile = PsiManager.getInstance((Project)this.this$0.getProject()).findFile(virtualFile);
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    if ((ktFile = (KtFile)psiFile) == null) continue;
                    DefaultScriptingSupportBase.ensureUpToDatedConfigurationSuggested$default((DefaultScriptingSupportBase)((DefaultScriptingSupportBase)DefaultScriptingSupport.Companion.getInstance(this.this$0.getProject())), (KtFile)ktFile, (boolean)true, (boolean)false, (int)4, null);
                }
            }
            {
                this.this$0 = gradleBuildRootsManager;
                this.$files = set;
                super(0);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public GradleBuildRootsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.enabled = true;
        this.modifiedFilesCheckScheduled = new AtomicBoolean();
        this.modifiedFiles = new ConcurrentLinkedQueue();
        Iterable $this$forEach$iv = UtilsKt.getGradleProjectSettings(this.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleProjectSettings it = (GradleProjectSettings)element$iv;
            boolean bl = false;
            this.getRoots().add(GradleBuildRootsManager.loadLinkedRoot$default(this, it, null, 2, null));
        }
        GradleSettingsListenerAdapter listener2 = new GradleSettingsListenerAdapter(this){
            final /* synthetic */ GradleBuildRootsManager this$0;

            public void onProjectsLinked(@NotNull Collection<GradleProjectSettings> settings) {
                Intrinsics.checkNotNullParameter(settings, (String)"settings");
                Iterable $this$forEach$iv = settings;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    GradleProjectSettings it = (GradleProjectSettings)element$iv;
                    boolean bl = false;
                    GradleBuildRootsManager.access$add(this.this$0, GradleBuildRootsManager.loadLinkedRoot$default(this.this$0, it, null, 2, null));
                }
            }

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                Intrinsics.checkNotNullParameter(linkedProjectPaths, (String)"linkedProjectPaths");
                Iterable $this$forEach$iv = linkedProjectPaths;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    GradleBuildRootsManager.access$remove(this.this$0, it);
                }
            }

            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                String version = GradleInstallationManager.getGradleVersion((String)newPath);
                GradleBuildRootsManager.access$reloadBuildRoot(this.this$0, linkedProjectPath, version);
            }

            public void onGradleDistributionTypeChange(@Nullable DistributionType currentValue, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleBuildRootsManager.access$reloadBuildRoot(this.this$0, linkedProjectPath, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.project.getMessageBus().connect((Disposable)this.project).subscribe(GradleSettingsListener.TOPIC, (Object)listener2);
    }

    public static final /* synthetic */ AtomicBoolean access$getModifiedFilesCheckScheduled$p(GradleBuildRootsManager $this) {
        return $this.modifiedFilesCheckScheduled;
    }

    public static final /* synthetic */ void access$checkModifiedFiles(GradleBuildRootsManager $this) {
        $this.checkModifiedFiles();
    }

    public static final /* synthetic */ GradleBuildRootData access$addFromSettings(GradleBuildRootsManager $this, GradleBuildRootData data, GradleProjectSettings settings) {
        return $this.addFromSettings(data, settings);
    }

    public static final /* synthetic */ void access$add(GradleBuildRootsManager $this, GradleBuildRoot newRoot2) {
        $this.add(newRoot2);
    }

    public static final /* synthetic */ void access$remove(GradleBuildRootsManager $this, String rootPath) {
        $this.remove(rootPath);
    }

    public static final /* synthetic */ GradleBuildRoot access$reloadBuildRoot(GradleBuildRootsManager $this, String rootPath, String version) {
        return $this.reloadBuildRoot(rootPath, version);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        @NotNull
        public final GradleBuildRootsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = ScriptingSupport.Companion.getEPN().findExtensionOrFail(GradleBuildRootsManager.class, (AreaInstance)project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ScriptingSupport.EPN.fin\u2026ger::class.java, project)");
            return (GradleBuildRootsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

