/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.sam;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"doFindSingleAbstractSignature", "Lcom/intellij/psi/HierarchicalMethodSignature;", "clazz", "Lcom/intellij/psi/PsiClass;", "findSingleAbstractMethod", "Lcom/intellij/psi/PsiMethod;", "findSingleAbstractSignature", "Lcom/intellij/psi/util/MethodSignature;", "findSingleAbstractSignatureCached", "isEffectivelyAbstractMethod", "", "signature", "isImplementedTraitMethod", "method", "isObjectMethod", "isSamConversionAllowed", "context", "Lcom/intellij/psi/PsiElement;", "intellij.groovy.psi"})
public final class SamConversionKt {
    @Nullable
    public static final PsiMethod findSingleAbstractMethod(@NotNull PsiClass clazz) {
        HierarchicalMethodSignature hierarchicalMethodSignature = SamConversionKt.findSingleAbstractSignatureCached(clazz);
        return hierarchicalMethodSignature != null ? hierarchicalMethodSignature.getMethod() : null;
    }

    @Nullable
    public static final MethodSignature findSingleAbstractSignature(@NotNull PsiClass clazz) {
        return (MethodSignature)SamConversionKt.findSingleAbstractSignatureCached(clazz);
    }

    private static final HierarchicalMethodSignature findSingleAbstractSignatureCached(PsiClass clazz) {
        return (HierarchicalMethodSignature)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)clazz), (CachedValueProvider)((CachedValueProvider)new CachedValueProvider<HierarchicalMethodSignature>(clazz){
            final /* synthetic */ PsiClass $clazz;

            @Nullable
            public final CachedValueProvider.Result<HierarchicalMethodSignature> compute() {
                return CachedValueProvider.Result.create((Object)SamConversionKt.access$doFindSingleAbstractSignature(this.$clazz), (Object[])new Object[]{this.$clazz});
            }
            {
                this.$clazz = psiClass;
            }
        }));
    }

    private static final HierarchicalMethodSignature doFindSingleAbstractSignature(PsiClass clazz) {
        HierarchicalMethodSignature result2 = null;
        for (HierarchicalMethodSignature signature : clazz.getVisibleSignatures()) {
            if (!SamConversionKt.isEffectivelyAbstractMethod(signature)) continue;
            if (result2 != null) {
                return null;
            }
            result2 = signature;
        }
        return result2;
    }

    private static final boolean isEffectivelyAbstractMethod(HierarchicalMethodSignature signature) {
        PsiMethod method = signature.getMethod();
        if (!method.hasModifierProperty("abstract")) {
            return false;
        }
        if (SamConversionKt.isObjectMethod(signature)) {
            return false;
        }
        return !SamConversionKt.isImplementedTraitMethod(method);
    }

    private static final boolean isObjectMethod(HierarchicalMethodSignature signature) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = signature.getSuperSignatures();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv;
                    boolean bl2 = false;
                    PsiClass psiClass = it.getMethod().getContainingClass();
                    if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.Object")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isImplementedTraitMethod(PsiMethod method) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass clazz = psiClass;
        if (!GrTraitUtil.isTrait(clazz)) {
            return false;
        }
        PsiMethod psiMethod = method;
        if (!(psiMethod instanceof GrMethod)) {
            psiMethod = null;
        }
        GrMethod grMethod = (GrMethod)psiMethod;
        if (grMethod == null) {
            return false;
        }
        GrMethod traitMethod = grMethod;
        return traitMethod.getBlock() != null;
    }

    public static final boolean isSamConversionAllowed(@NotNull PsiElement context) {
        return GroovyConfigUtils.getInstance().isVersionAtLeast(context, "2.2");
    }

    public static final /* synthetic */ HierarchicalMethodSignature access$doFindSingleAbstractSignature(PsiClass clazz) {
        return SamConversionKt.doFindSingleAbstractSignature(clazz);
    }
}

