/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public abstract class AbstractClosureParameterEnhancer
extends GrVariableEnhancer {
    @Override
    public final PsiType getVariableType(GrVariable variable) {
        int paramIndex;
        GrFunctionalExpression functionalExpression;
        if (!(variable instanceof GrParameter)) {
            return null;
        }
        if (variable instanceof ClosureSyntheticParameter) {
            functionalExpression = ((ClosureSyntheticParameter)variable).getClosure();
            paramIndex = 0;
        } else {
            PsiElement eParameterList = variable.getParent();
            if (!(eParameterList instanceof GrParameterList)) {
                return null;
            }
            PsiElement eFunctionalExpression = eParameterList.getParent();
            if (!(eFunctionalExpression instanceof GrFunctionalExpression)) {
                return null;
            }
            functionalExpression = (GrFunctionalExpression)eFunctionalExpression;
            GrParameterList parameterList = (GrParameterList)eParameterList;
            paramIndex = parameterList.getParameterNumber((GrParameter)variable);
        }
        PsiType res = this.getClosureParameterType(functionalExpression, paramIndex);
        if (res instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)res).getBoxedType((PsiElement)functionalExpression);
        }
        return res != null ? AbstractClosureParameterEnhancer.unwrapBound(res) : null;
    }

    @Nullable
    private static PsiType unwrapBound(@NotNull PsiType type2) {
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcard = (PsiWildcardType)type2;
            return wildcard.isSuper() ? wildcard.getBound() : type2;
        }
        return type2;
    }

    @Nullable
    protected abstract PsiType getClosureParameterType(@NotNull GrFunctionalExpression var1, int var2);
}

