/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrUnaryOperatorReference;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;

public class GrUnaryExpressionImpl
extends GrExpressionImpl
implements GrUnaryExpression {
    private final GroovyMethodCallReference myReference = new GrUnaryOperatorReference(this);

    public GrUnaryExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public GroovyMethodCallReference getReference() {
        return this.myReference;
    }

    public String toString() {
        return "Unary expression";
    }

    @Override
    @Nullable
    public PsiType getOperationType() {
        GroovyMethodCallReference reference = this.getReference();
        GroovyResolveResult result2 = reference.advancedResolve();
        PsiType operatorType = DefaultMethodCallTypeCalculatorKt.getTypeFromResult(result2, reference.getArguments(), this);
        if (operatorType != null) {
            return operatorType;
        }
        GrExpression operand = this.getOperand();
        if (operand == null) {
            return null;
        }
        PsiType operandType = operand.getType();
        if (TypesUtil.isNumericType(operandType)) {
            return operandType;
        }
        return null;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        PsiElement opElement = this.getOperationToken();
        ASTNode node = opElement.getNode();
        assert (node != null);
        return node.getElementType();
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement opElement = this.findChildByType(TokenSets.UNARY_OP_SET);
        assert (opElement != null);
        return opElement;
    }

    @Override
    public GrExpression getOperand() {
        return GrUnaryExpressionImpl.findExpressionChild(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitUnaryExpression(this);
    }

    @Override
    public boolean isPostfix() {
        return this.getFirstChild() instanceof GrExpression;
    }
}

