/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.impl.GrImplicitCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrExplicitMethodCallReference;

public abstract class GrMethodCallImpl
extends GrCallExpressionImpl
implements GrMethodCall {
    private final GroovyMethodCallReference myImplicitCallReference = new GrImplicitCallReference(this);
    private final GroovyMethodCallReference myExplicitCallReference = new GrExplicitMethodCallReference(this);

    public GrMethodCallImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public GroovyMethodCallReference getImplicitCallReference() {
        return PsiImplUtilKt.isImplicitCall(this) ? this.myImplicitCallReference : null;
    }

    @Override
    @Nullable
    public GroovyMethodCallReference getExplicitCallReference() {
        return PsiImplUtilKt.isExplicitCall(this) ? this.myExplicitCallReference : null;
    }

    @Override
    @Nullable
    public GroovyMethodCallReference getCallReference() {
        GroovyMethodCallReference explicitCallReference = this.getExplicitCallReference();
        return explicitCallReference == null ? this.getImplicitCallReference() : explicitCallReference;
    }

    @Override
    public GroovyResolveResult @NotNull [] getCallVariants(@Nullable GrExpression upToArgument) {
        GrExpression invoked = this.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpression)) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return ((GrReferenceExpression)invoked).multiResolve(true);
    }

    @Override
    @NotNull
    public GrExpression getInvokedExpression() {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            return (GrExpression)cur;
        }
        throw new IncorrectOperationException("invoked expression must not be null");
    }

    @Override
    public boolean isCommandExpression() {
        GrExpression expression = this.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression) || ((GrReferenceExpression)expression).getQualifier() == null) {
            return false;
        }
        return ((GrReferenceExpression)expression).getDotToken() == null;
    }

    @Override
    public GroovyResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        GroovyMethodCallReference implicitCallReference = this.getImplicitCallReference();
        if (implicitCallReference != null) {
            return implicitCallReference.multiResolve(incompleteCode);
        }
        GroovyMethodCallReference explicitCallReference = this.getExplicitCallReference();
        if (explicitCallReference != null) {
            return explicitCallReference.multiResolve(incompleteCode);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        return (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitMethodCall(this);
    }
}

