/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.ui.IconManager;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrClassInitializerImpl
extends GroovyPsiElementImpl
implements GrClassInitializer {
    public GrClassInitializerImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitClassInitializer(this);
    }

    public String toString() {
        return "Class initializer";
    }

    @Override
    @NotNull
    public GrOpenBlock getBlock() {
        return (GrOpenBlock)this.findNotNullChildByClass(GrOpenBlock.class);
    }

    @Override
    public boolean isStatic() {
        return this.getModifierList().hasExplicitModifier("static");
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (pparent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    @Override
    public GrMember[] getMembers() {
        return new GrMember[]{this};
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        return (GrModifierList)this.findNotNullChildByClass(GrModifierList.class);
    }

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiCodeBlock getBody() {
        return PsiImplUtil.getOrCreatePsiCodeBlock(this.getBlock());
    }

    @Nullable
    protected Icon getElementIcon(int flags) {
        return IconManager.getInstance().createLayeredIcon((Iconable)this, JetgroovyIcons.Groovy.ClassInitializer, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
    }
}

