/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;

public class GrAnnotationArgumentListImpl
extends GrStubElementBase<EmptyStub>
implements GrAnnotationArgumentList,
StubBasedPsiElement<EmptyStub>,
PsiListLikeElement {
    private static final Logger LOG = Logger.getInstance(GrAnnotationArgumentListImpl.class);

    public GrAnnotationArgumentListImpl(@NotNull EmptyStub stub) {
        super(stub, (IStubElementType)GroovyEmptyStubElementTypes.ANNOTATION_ARGUMENT_LIST);
    }

    public GrAnnotationArgumentListImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitAnnotationArgumentList(this);
    }

    public String toString() {
        return "Annotation arguments";
    }

    @Override
    public GrAnnotationNameValuePair @NotNull [] getAttributes() {
        return (GrAnnotationNameValuePair[])this.getStubOrPsiChildren(GroovyStubElementTypes.ANNOTATION_MEMBER_VALUE_PAIR, GrAnnotationNameValuePair.EMPTY_ARRAY);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first.getElementType() == GroovyStubElementTypes.ANNOTATION_MEMBER_VALUE_PAIR && last.getElementType() == GroovyStubElementTypes.ANNOTATION_MEMBER_VALUE_PAIR) {
            GrAnnotationNameValuePair pair;
            GrAnnotationNameValuePair[] nodes;
            ASTNode lparenth = this.getNode().getFirstChildNode();
            ASTNode rparenth = this.getNode().getLastChildNode();
            if (lparenth == null) {
                this.getNode().addLeaf(GroovyTokenTypes.mLPAREN, (CharSequence)"(", null);
            }
            if (rparenth == null) {
                this.getNode().addLeaf(GroovyTokenTypes.mRPAREN, (CharSequence)")", null);
            }
            if ((nodes = this.getAttributes()).length == 1 && (pair = nodes[0]).getName() == null) {
                String text = pair.getValue().getText();
                try {
                    GrAnnotation annotation = GroovyPsiElementFactory.getInstance(this.getProject()).createAnnotationFromText("@AAA(value = " + text + ")");
                    this.getNode().replaceChild(pair.getNode(), annotation.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (anchor == null && before != null) {
                anchor = before != false ? this.getNode().getLastChildNode() : this.getNode().getFirstChildNode();
            }
        }
        return super.addInternal(first, last, anchor, before);
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        return Arrays.asList(this.getAttributes());
    }
}

